/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.job;

import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.device42.atlas.common.job.UpdateDataTask;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42JobStatisticsManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.util.ObjectUtils;
import com.device42.atlas.confluence.manager.D42ConfluenceDataUpdaterMonitorImpl;

public class D42ConfluenceUpdateDataTask
extends UpdateDataTask
implements JobRunner {
    public static final String FORCE_START_KEY = "forceStart";
    public static final String FULL_RESCAN_KEY = "fullRescan";
    private final D42ConfluenceDataUpdaterMonitorImpl confluenceDataUpdaterMonitorImpl;

    public D42ConfluenceUpdateDataTask(D42SettingsManager d42SettingsManager, D42DataManager d42DataManager, TransactionTemplate transactionTemplate, D42JobStatisticsManager jobStatisticsManager, D42ConfluenceDataUpdaterMonitorImpl confluenceDataUpdaterMonitorImpl) {
        super(d42SettingsManager, d42DataManager, transactionTemplate, jobStatisticsManager);
        this.confluenceDataUpdaterMonitorImpl = confluenceDataUpdaterMonitorImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            boolean result;
            boolean forceRun = false;
            boolean fullRescan = false;
            if (request != null && request.getJobConfig() != null && request.getJobConfig().getParameters() != null) {
                forceRun = ObjectUtils.booleanValue(request.getJobConfig().getParameters().get(FORCE_START_KEY), (boolean)false);
                fullRescan = ObjectUtils.booleanValue(request.getJobConfig().getParameters().get(FULL_RESCAN_KEY), (boolean)false);
            }
            if (!(result = this.execute(forceRun, fullRescan))) {
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((String)"Failed to execute job");
                return jobRunnerResponse;
            }
            JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success();
            return jobRunnerResponse;
        }
        finally {
            if (request != null && request.getJobId() != null && request.getJobId().toString().equals("d42RunOnceJob")) {
                this.confluenceDataUpdaterMonitorImpl.unregisterTemporary();
            }
        }
    }
}

