/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import javax.servlet.http.HttpServletRequest;

public class RestrictSpaceAction
extends ConfluenceActionSupport {
    private PluginSettingsFactory pluginSettingsFactory;
    private SpaceManager spaceManager;
    private PermissionManager permissionManager;
    private XsrfTokenAccessor tokenAccessor;
    private String act;
    private String[] bufferSelected;
    private String[] selected;
    private String enable;
    public static final String D42_RESTRICTED_SPACES_PROPERTY_KEY = "d42_restrict_spaces";
    public static final String D42_RESTRICTED_SPACES_ENABLE_PROPERTY_KEY = "d42_restrict_spaces_enable";

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setBufferSelected(String[] bufferSelected) {
        this.bufferSelected = bufferSelected;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setTokenAccessor(XsrfTokenAccessor tokenAccessor) {
        this.tokenAccessor = tokenAccessor;
    }

    public String[] getSelected() {
        return this.selected;
    }

    public String getAct() {
        return this.act;
    }

    public void setAct(String act) {
        this.act = act.toLowerCase();
    }

    public String getEnable() {
        return this.enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    public String getAtl_token() {
        return this.tokenAccessor.getXsrfToken(ServletContextThreadLocal.getRequest(), ServletContextThreadLocal.getResponse(), false);
    }

    public String execute() throws Exception {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        try {
            HttpServletRequest request = ServletContextThreadLocal.getRequest();
            if (request != null) {
                this.act = request.getParameter("act");
                this.enable = request.getParameter("enable");
                String[] requestBufferSelected = request.getParameterValues("bufferSelected");
                if (requestBufferSelected != null) {
                    this.bufferSelected = requestBufferSelected;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.act != null && this.act.equals("save")) {
            pluginSettings.put(D42_RESTRICTED_SPACES_PROPERTY_KEY, (Object)this.arrayToStr(this.bufferSelected));
            pluginSettings.put(D42_RESTRICTED_SPACES_ENABLE_PROPERTY_KEY, (Object)this.checkEnable(this.enable));
        }
        this.selected = this.strToArray((String)pluginSettings.get(D42_RESTRICTED_SPACES_PROPERTY_KEY));
        this.enable = this.checkEnable((String)pluginSettings.get(D42_RESTRICTED_SPACES_ENABLE_PROPERTY_KEY));
        return "input";
    }

    private String checkEnable(String input) {
        String lowerInput;
        String result = "off";
        if (input != null && ((lowerInput = input.toLowerCase()).equals("on") || lowerInput.equals("checked") || lowerInput.equals("true"))) {
            result = "on";
        }
        return result;
    }

    private String[] strToArray(String input) {
        String[] result = new String[]{};
        if (input != null) {
            result = input.split(",");
        }
        return result;
    }

    private String arrayToStr(String[] input) {
        StringBuilder result = new StringBuilder();
        if (input != null) {
            for (String str : input) {
                if (this.spaceManager.getSpace(str) == null) continue;
                result.append(str).append(",");
            }
            if (result.length() > 0) {
                result = new StringBuilder(result.substring(0, result.length() - 1));
            }
        }
        return result.toString();
    }

    public boolean isPermitted() {
        return this.permissionManager.isSystemAdministrator(this.getAuthenticatedUser()) || this.permissionManager.isConfluenceAdministrator(this.getAuthenticatedUser());
    }
}

