/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.manager;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42FilterServletProcessorImpl;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.Map;

public class D42ConfluenceFilterServletProcessorImpl
extends D42FilterServletProcessorImpl {
    protected static final String VM_VIEW = "/com/device42/atlas/confluence/templates/action/admin/filter/filter-servlet-view.vm";
    public static final String TOKEN_SPACE_KEY = "key";
    protected final SpaceManager spaceManager;

    public D42ConfluenceFilterServletProcessorImpl(D42DataManager d42DataManager, I18nResolver i18n, SpaceManager spaceManager, D42SettingsManager settingsManager) {
        super(d42DataManager, i18n, settingsManager);
        this.spaceManager = spaceManager;
    }

    protected void addSecondLevelOptions(long firstLevelId, ErrorHolder errorHolder) throws D42Exception {
        errorHolder.addParameter("filters", (Object)this.d42DataManager.getFirstLevelFilters(firstLevelId));
    }

    protected long getFirstLevelFilter(Map<String, String> parameters, ErrorHolder errorHolder) {
        long firstLevelId;
        if (this.checkTemplate(parameters, errorHolder)) {
            return 0L;
        }
        String spaceKey = parameters.get(TOKEN_SPACE_KEY);
        Space space = null;
        if (spaceKey != null) {
            space = this.spaceManager.getSpace(spaceKey);
        }
        if (spaceKey == null || space == null) {
            errorHolder.addErrorMessage(this.i18n.getText("com.device42.atlas.confluence.space.section.error.empty.space"));
            return 0L;
        }
        errorHolder.addParameter(TOKEN_SPACE_KEY, (Object)space.getKey());
        if (parameters.containsKey("firstLevelId") && (firstLevelId = ObjectUtils.longValue((Object)parameters.get("firstLevelId"), (long)0L)) != space.getId()) {
            errorHolder.addErrorMessage(this.i18n.getText("com.device42.atlas.confluence.space.section.error.empty.space"));
            return 0L;
        }
        errorHolder.addParameter("firstLevelId", (Object)space.getId());
        return space.getId();
    }

    protected long getSecondLevelFilter(Map<String, String> parameters, ErrorHolder errorHolder, boolean isRequired) {
        if (parameters.get("secondLevelId") == null) {
            if (isRequired) {
                errorHolder.addError("secondLevelId", this.i18n.getText("com.device42.atlas.confluence.space.section.error.empty.filter"));
            }
        } else {
            return this.getSecondLevelTemplateFilterId(parameters);
        }
        return 0L;
    }

    protected String getViewKey() {
        return VM_VIEW;
    }
}

