
var d42ConfigurationItemsData = null;




/*function getStaticDataValue(key) {
	return AJS.$("#d42Messages").attr(key);
}*/

/*function getHttpErrorText(status) {
	switch(status) {
	case 412:
		return getStaticDataValue("xsrfError");
	case 501:
		return getStaticDataValue("badActionError");
	case 403:
	case 401:
		return getStaticDataValue("notAuthorizedError")
	}
	return getStaticDataValue("unknownError")
}*/

/*function cleanErrors() {
    AJS.$("div.error").empty().hide();
}*/

function prepareNestedError(value, indent) {
	if (indent == null)
		indent = 0;
	var errorBody = "";
	if (value.errorMessages) {
		AJS.$.each(value.errorMessages, function(index, errorMessage) {
			errorBody += "<div>" + errorMessage + "</div>";
		});
	}
	if (value.errors) {
		AJS.$.each(value.errors, function(key, value) {
			if (typeof value != "string") {
				value = prepareNestedError(value, indent + 10);
			}
			errorBody += "<div style='padding-left: " + indent + "px;'><span>" + key + ": </span><span>" + value + "</span></div>";	
		});
	}
	return errorBody;
}

/*function addErrors(errorMessages, errors) {
	cleanErrors();
	if(errorMessages) {
		var errorBody = "";
		AJS.$.each(errorMessages, function(index, errorMessage) {
			errorBody += "<p>" + errorMessage + "</p>";
		});
		AJS.messages.error({
			title : getStaticDataValue("errorHeader"),
			body : errorBody
		});
	}
	if (errors) {
		AJS.$.each(errors, function(key, value) {
			if (typeof value != "string") {
				value = prepareNestedError(value);
			}
			AJS.$("#d42EditForm div.error[d42Key='" + key + "']").append(value).show();
			AJS.$("#ciConfirmationDeleteDialog div.error[d42Key='" + key + "']").append(value).show();
			AJS.$("#d42EditParamDialog div.error[d42Key='" + key + "']").append(value).show();
			AJS.$("#paramConfirmationDeleteDialog div.error[d42Key='" + key + "']").append(value).show();
			AJS.$("#importSchemaFileUploadDialog div.error[d42Key='" + key + "']").append(value).show();
            AJS.$("#configStyleDialog div.error[d42Key='" + key + "']").append(value).show();
			AJS.$("#d42ExtractParamsDialog div.error[d42Key='" + key + "']").append(value).show();
			
		});
	}
}*/

/*function loadData(postFunction) {
	console.debug("Data collection from remote started")
	var servletUrl = getStaticDataValue("url");
	AJS.$.ajax({
		url : servletUrl + "?action=getSchemaAndData",
		type : 'GET',
		success : function(resp) {
			console.debug("Data collection successfull. Response: " + resp);
			d42ConfigurationItemsData = resp;
			if(postFunction)
				postFunction();
		},
		error : function(xhr, ajaxOptions, thrownError) {
			console.debug("Data collection failed.");
			addErrors([ "Error " + xhr.status + ": " + getHttpErrorText(xhr.status) ]);
		}

	});
}*/

function clearContent() {
	AJS.$("#ciconf-heading").html("");
	AJS.$("#ciconf-desc").html("");
	AJS.$("#ciconf-body").html("");
	AJS.$("#ciconf-actions").html("");
}

function setContent(header, description, actions, content) {
	AJS.$("#ciconf-heading").html(header);
	AJS.$("#ciconf-desc").html(description);
	AJS.$("#ciconf-actions").html(actions);
	AJS.$("#ciconf-body").html(content);
}

function renderGeneralInfo() {
	console.debug("Initialyzing general information");
	var generalHeader = getStaticDataValue("d42GeneralHeading");
	var generalDescription = getStaticDataValue("d42GeneralDescription");
	var content = AJS.$(AJS.$("#d42GeneralTableTemplate").html());
	
	AJS.$.each(d42ConfigurationItemsData.fullSchema.configurationItemTypes, function(key, configurationItem) {
		var configurationItemRow = AJS.$("<tr/>");
		configurationItemRow.append(AJS.$("<td><a href='#' class='viewItem' d42Key='" + configurationItem.key +"'>" + configurationItem.key + "</a></td>"));
		configurationItemRow.append(AJS.$("<td><a href='#' class='viewItem' d42Key='" + configurationItem.key +"'>" + configurationItem.name +"</a></td>"));
		configurationItemRow.append(AJS.$("<td>" + (configurationItem.collectable ? getStaticDataValue("d42True") : getStaticDataValue("d42False") )+"</td>"));
		configurationItemRow.append(AJS.$("<td>\
												<a href='#' title='"+getStaticDataValue("d42Edit")+"'>" +  "<span d42Key='"+ configurationItem.key + "' class='aui-icon aui-icon-small aui-iconfont-edit editItem'></span>" + "</a>\
												<a href='#' title='"+getStaticDataValue("d42Delete")+"'>" +  "<span d42Key='"+ configurationItem.key + "' class='aui-icon aui-icon-small aui-iconfont-remove deleteItem'></span>" + "</a>\
											</td>"));
		content.append(configurationItemRow);
	});
	setContent(generalHeader, generalDescription, "", content);
	d42SwitchNavigation("[d42general='true']");
	console.debug("Generic info content rendered");
}

function renderTopMenu() {
	if (d42ConfigurationItemsData) {
		AJS.$(".d42AutoRemovable").remove();
		var insertItemsAfter = AJS.$("ul.d42MainMenu li.d42InsertItemsAfter");
		AJS.$.each(d42ConfigurationItemsData.fullSchema.orderedConfigurationItemTypeKeys, function(index, key) {
			var menuItem = AJS.$("<li d42Key='"+ key +"' class='d42AutoRemovable'>");
			menuItem.append(AJS.$("<a class='nav-ci-link' d42Key='" + key + "' href='#'>" + d42ConfigurationItemsData.fullSchema.configurationItemTypes[key].pluralName + "</a>"));
			insertItemsAfter.after(menuItem);
			insertItemsAfter = menuItem;
		});
	}
}

function renderConfigurationItemView(key) {
	if (key != null) {
		var configurationItemType = d42ConfigurationItemsData.fullSchema.configurationItemTypes[key];
		if (configurationItemType != null) {
			var viewHeader = configurationItemType.name;
			var viewDescription = getStaticDataValue("d42ViewDescription");
			var viewString = AJS.$("#d42ViewTemplate").html().replace(/d42template_/g,"");
			var viewActions = AJS.$("<div>");
			var viewEdit = AJS.$("<a href='#' class='aui-button editItem' d42Key=" + key + "/>");
			viewEdit.append("<span class='aui-icon aui-icon-small aui-iconfont-edit' d42Key=" + key + ">"+ getStaticDataValue("d42Edit") +"</span>");
			var viewDelete = AJS.$("<a href='#' class='aui-button deleteItem' d42Key=" + key + "/>");
			viewDelete.append("<span class='aui-icon aui-icon-small aui-iconfont-delete' d42Key=" + key + ">"+ getStaticDataValue("d42Delete") +"</span>");
			viewActions.append(viewEdit).append(viewDelete);
			var view = AJS.$(viewString);
			AJS.$.each(configurationItemType, function(key, value) {
				view.find("span.textValue[d42Key='" + key + "']").append(value);
				view.find("span.checkboxValue[d42Key='" + key + "']").append(value ? getStaticDataValue("d42True") : getStaticDataValue("d42False"));
			});
			if (AJS.$.isEmptyObject(configurationItemType.parameterTypes)) {
				view.find("a[d42action='extractParameterTypes']").attr("d42CiKey", key).show();
			}
			if (configurationItemType.parameterTypes) {
				var insertParameterAfter = view.find(".d42ParametersHeader");
				AJS.$.each(configurationItemType.orderedParameterTypeKeys, function(index, key) {
					var parameterTypeRow = AJS.$("<tr>" + AJS.$("#paramViewRowTemplate tr").html() + "</tr>");
					var parameterType = configurationItemType.parameterTypes[key];
                    if (parameterType.valueType==='REFERENCE') {
                        if ((!d42ConfigurationItemsData.fullSchema.configurationItemTypes[parameterType.configurationItemKey])
							||(!d42ConfigurationItemsData.fullSchema.configurationItemTypes[parameterType.configurationItemKey].collectable)) {
                            parameterTypeRow.find("div.paramWarning").show();
                        	//if (AJS.version.split(".")[0]==="5") {
                                //AJS.InlineDialog() has been deprecated and will be removed in a future version.
                                AJS.InlineDialog(parameterTypeRow.find("div.paramWarning"), "myDialog",
                                    function (content, trigger, showPopup) {
                                        content.css({"padding": "20px"})
                                            .html('<p>Configuration type with the key <b>' + parameterType.configurationItemKey + '</b> must be exist and collectable!</p>');
                                        showPopup();
                                        return false;
                                    },
                                    {
                                        onHover: true,
                                        hideDelay: 500
                                    }
                                );
/*							} else {
                                parameterTypeRow.find("div.paramWarning").find("a").attr("data-aui-trigger","");
                                parameterTypeRow.find("div.paramWarning").find("a").attr("aria-controls",parameterType.key + "_warn");
                                parameterTypeRow.find("div.paramWarning").find("a").after(
                                    "<aui-inline-dialog id='"+parameterType.key + "_warn"+"' responds-to='hover'>" +
                                    "<p>Configuration type with the key <b>'"+parameterType.configurationItemKey+"'</b> must be exist and collectable!</p>" +
                                    "</aui-inline-dialog>"
                                );
							}*/
                        }
                    }
                    if (parameterType.paramEnabled===true) {
                    	parameterTypeRow.find("div.paramEnabled").show();
                    } else {
                    	parameterTypeRow.find("div.paramDisabled").show();
                    }

					AJS.$.each(parameterType, function(key, value){
						if (value != null && "" + value) {
                            parameterTypeRow.find("div[d42Key='" + key +"']").show();
							parameterTypeRow.find("span.textValue[d42Key='" + key + "']").append(value);
							parameterTypeRow.find("span.checkboxValue[d42Key='" + key + "']").append(value ? getStaticDataValue("d42True") : getStaticDataValue("d42False"));
							var selectViewControl = parameterTypeRow.find("span.selectValue[d42Key='" + key + "']");
							var selectId = selectViewControl.attr("selectId");
							if(selectId) {
								selectViewControl.append(AJS.$("#" + selectId + " option[value='" + value + "']").html());
							}
						}
					});
					parameterTypeRow.find(".editParam").attr("d42Key", key);
					parameterTypeRow.find(".editParam").attr("d42CiKey", configurationItemType.key);
					parameterTypeRow.find(".deleteParam").attr("d42Key", key);
					parameterTypeRow.find(".deleteParam").attr("d42CiKey", configurationItemType.key);
					insertParameterAfter.after(parameterTypeRow);
					insertParameterAfter = parameterTypeRow;
				});
			}
			view.find("a[d42action='addParameterType']").attr("d42CiKey", key);
			setContent(viewHeader, viewDescription, viewActions, view);
			d42SwitchNavigation("[d42Key='" + key +"']");
		} else {
			console.error("No configuration item found");
			renderGeneralInfo();
		}
	}
}

function registerCancel(cancelLink, key) {
	if (key)
		cancelLink.click(function(e){
			renderConfigurationItemView(key);
			return false;
		});
	else
		cancelLink.click(function(e){
			renderGeneralInfo();
			return false;
		});
}

function d42SwitchNavigation(selector) {
	AJS.$("ul.d42MainMenu li").removeClass("aui-nav-selected");
	AJS.$("ul.d42MainMenu li" + selector).addClass("aui-nav-selected");
}

function registerSave(saveLink, key) {
	if (key)
		saveLink.attr("d42Key", key);
	saveLink.click(function(e){
		console.debug("Item save started");
		var servletUrl = getStaticDataValue("url");
		var xsrfKey = getStaticDataValue("xsrfKey");
		var xsrfValue = getStaticDataValue("xsrfValue");
		var d42Key = saveLink.attr("d42Key");
		var data = {};
		data[xsrfKey] = xsrfValue;
		AJS.$("#d42EditForm input[type='text']").each(function() {
			textInput = AJS.$(this);
			data[textInput.attr("name")]=textInput.val();
		});
		AJS.$("#d42EditForm input[type='checkbox']").each(function() {
			checkbox = AJS.$(this);
			data[checkbox.attr("name")]=checkbox.prop("checked");
		});
		AJS.$("#d42EditForm textarea").each(function() {
			textarea=AJS.$(this);
			data[textarea.attr("name")]=textarea.val();
		});
		if (d42Key) {
			data["key"] = d42Key;
		} else {
			data["newConfigurationItem"] = true;
		}
		console.debug("data: " + data);
		AJS.$.ajax({
			url : servletUrl + "?action=saveItem",
			type : 'POST',
			data : data,
			success : function(resp) {
				if (resp.result == "error") {
					addErrors(resp.errorMessages, resp.errors);
				}
				else {
					console.debug("Item save successfull. Response: " + resp);
					AJS.messages.success({
						title : getStaticDataValue("saveCiHeader"),
						body : "<p>"
								+ getStaticDataValue("saveCiDescription")
								+ "</p>"
					});
					d42ConfigurationItemsData = resp;
					renderTopMenu();
					renderConfigurationItemView(resp.savedKey);
				}
			},
			error : function(xhr, ajaxOptions, thrownError) {
				console.log("Item save failed.");
				addErrors([ "Error " + xhr.status + ": " + getHttpErrorText(xhr.status) ]);
			}
		});
		return false;
	});
	
}


function renderConfigurationItemEdit(key) {
	
	var editHeader = "";
	var editDescription = "";
	var editFormString = AJS.$("#d42FormTemplate").html().replace(/d42template_/g,"");
	var editForm = AJS.$(editFormString);
	if (key != null) {
		var configurationItemType = d42ConfigurationItemsData.fullSchema.configurationItemTypes[key];
		if (configurationItemType != null) {
			editHeader = configurationItemType.name;
			editDescription = getStaticDataValue("d42EditDescription");
			AJS.$.each(configurationItemType, function(key, value) {
				editForm.find("span[d42Key='" + key + "']").empty().append(value);
				editForm.find("input[type='text'][name='" + key + "']").val(value);
				editForm.find("input[type='checkbox'][name='" + key + "']").prop("checked",value);
				editForm.find("textarea[name='" + key + "']").val(value);
			});
			editForm.find(".hideWithKey").hide();
		}
	} else {
		editForm.find(".hideWithNoKey").hide();
		editHeader = getStaticDataValue("d42NewHeading");
		editDescription = getStaticDataValue("d42NewDescription");
	}
	setContent(editHeader, editDescription, "", editForm);
	
	if (key != null) {
		d42SwitchNavigation("[d42Key='" + key +"']");
		registerCancel(editForm.find("a[d42action='cancel']"), key);
		registerSave(editForm.find("a[d42action='save']"), key);
	}
	else {
		d42SwitchNavigation("[d42new='true']");
		registerSave(editForm.find("a[d42action='save']"));
	}
}
	
function showDeleteCiDialog(key) {
	var configurationItem = d42ConfigurationItemsData.fullSchema.configurationItemTypes[key];
	if (configurationItem) {
		cleanErrors();
		var dialogBody = AJS.$("#ciConfirmationDeleteDialog");
		dialogBody.find("#deleteCIConfirmationCheckbox").prop("checked",false);
		dialogBody.find("#d42deleteCIKey").val(key);
		dialogBody.find("#d42deleteCIKeyView").empty().append(key);
		dialogBody.find("#d42deleteCIName").empty().append(d42ConfigurationItemsData.fullSchema.configurationItemTypes[key].name);
		AJS.dialog2("#ciConfirmationDeleteDialog").show();
	}
}

function deleteCiByDialog() {
	console.debug("Item delete started");
	var key = AJS.$("#d42deleteCIKey").val();
	var agreeDelete = AJS.$("#deleteCIConfirmationCheckbox").prop("checked");
	var servletUrl = getStaticDataValue("url");
	var xsrfKey = getStaticDataValue("xsrfKey");
	var xsrfValue = getStaticDataValue("xsrfValue");
	var data = {};
	data[xsrfKey] = xsrfValue;
	data["key"] = key;
	data["agreeDelete"] = agreeDelete;
	AJS.$.ajax({
		url : servletUrl + "?action=deleteItem",
		type : 'POST',
		data : data,
		success : function(resp) {
			if (resp.result == "error") {
				addErrors(resp.errorMessages, resp.errors);
			}
			else {
				console.debug("Item delete successfull. Response: " + resp);
				AJS.dialog2("#ciConfirmationDeleteDialog").hide();
				AJS.messages.success({
					title : getStaticDataValue("deleteCiHeader"),
					body : "<p>"
							+ getStaticDataValue("deleteCiDescription")
							+ "</p>"
				});
				
				d42ConfigurationItemsData = resp;
				renderTopMenu();
				renderGeneralInfo();
			}
		},
		error : function(xhr, ajaxOptions, thrownError) {
			console.debug("Item delete failed.");
			AJS.dialog2("#ciConfirmationDeleteDialog").hide();
			addErrors([ "Error " + xhr.status + ": " + getHttpErrorText(xhr.status)  ]);
		}
	});
	return false;
}

function showEditParameterDialog(ciKey, paramKey) {
	cleanErrors();
	var editDialog = AJS.$("#d42EditParamDialog");
	var configurationItemType = d42ConfigurationItemsData.fullSchema.configurationItemTypes[ciKey];
	if (configurationItemType) {
		editDialog.find("span[d42Key='ciKey']").html(configurationItemType.name);
		editDialog.find("#d42ParamCIKey").val(ciKey);
		if (paramKey) {
			editDialog.find(".hideWhenKey").hide();
			editDialog.find(".hideWhenNoKey").show();
			editDialog.find("#d42SaveParamButton").attr("d42Key",paramKey)
			if (configurationItemType.parameterTypes && configurationItemType.parameterTypes[paramKey]) {
				var parameterType = configurationItemType.parameterTypes[paramKey];
				AJS.$.each(parameterType, function(key, value) {
					editDialog.find("span[d42Key='" + key + "']").empty().append(value);
					editDialog.find("input[type='text'][name='" + key + "']").val(value);
					editDialog.find("input[type='checkbox'][name='" + key + "']").prop("checked",value);
					editDialog.find("select[name='" + key + "']").val(value);
				});
			} else {
				console.log("No parameter with key " + paramKey + " for configuration item type " + ciKey + " for showEditParameterDialog");
				return;
			}
		} else {
			editDialog.find(".hideWhenNoKey").hide();
			editDialog.find(".hideWhenKey").show();
			editDialog.find("input[type='checkbox']").prop("checked",true);
			editDialog.find("#d42ParamValueType").val("SIMPLE");
			editDialog.find("#d42ParamSimpleType").val("STRING");
			editDialog.find("input[type='text']").val("");
			editDialog.find("#d42SaveParamButton").attr("d42Key","");
		}
		refreshParameterAdditionalProperties();
		AJS.dialog2("#d42EditParamDialog").show();
	} else {
		console.log("No configuration item type with key " + ciKey + " for showEditParameterDialog");
	}
}

function refreshParameterAdditionalProperties() {
	var editDialog = AJS.$("#d42EditParamDialog");
	var parameterValueType = AJS.$("#d42ParamValueType").val();
	editDialog.find(".additionalParameter").hide();
	editDialog.find(".param-value-"+ parameterValueType + "").show();
}

function saveParameter() {
	console.debug("Param save started");
	var servletUrl = getStaticDataValue("url");
	var xsrfKey = getStaticDataValue("xsrfKey");
	var xsrfValue = getStaticDataValue("xsrfValue");
	var d42Key = AJS.$("#d42SaveParamButton").attr("d42Key");
	var data = {};
	data[xsrfKey] = xsrfValue;
	data["ciKey"] = AJS.$("#d42EditParamDialog input[name='ciKey']").val();
	AJS.$("#d42EditParamDialog input[type='text']").each(function() {
		textInput = AJS.$(this);
		data[textInput.attr("name")]=textInput.val();
	});
	AJS.$("#d42EditParamDialog input[type='checkbox']").each(function() {
		checkbox = AJS.$(this);
		data[checkbox.attr("name")]=checkbox.prop("checked");
	});
	AJS.$("#d42EditParamDialog select").each(function() {
		select=AJS.$(this);
		data[select.attr("name")]=select.val();
	});
	if (d42Key) {
		data["key"] = d42Key;
	} else {
		data["newParameter"] = true;
	}
	console.debug("data: " + data);
	AJS.$.ajax({
		url : servletUrl + "?action=saveParamType",
		type : 'POST',
		data : data,
		success : function(resp) {
			if (resp.result == "error") {
				addErrors(resp.errorMessages, resp.errors);
			}
			else {
				console.debug("Param save successfull. Response: " + resp);
				AJS.dialog2("#d42EditParamDialog").hide();
				AJS.messages.success({
					title : getStaticDataValue("saveParamHeader"),
					body : "<p>"
							+ getStaticDataValue("saveParamDescription")
							+ "</p>"
				});
				d42ConfigurationItemsData = resp;
				renderTopMenu();
				renderConfigurationItemView(resp.savedKey);
			}
		},
		error : function(xhr, ajaxOptions, thrownError) {
			console.log("Item save failed.");
			addErrors([ "Error " + xhr.status + ": " + getHttpErrorText(xhr.status)  ]);
		}
	});
	return false;
}


function showExtractParametersDialog(ciKey) {
	cleanErrors();
	var extractDialog = AJS.$("#d42ExtractParamsDialog");
	var configurationItemType = d42ConfigurationItemsData.fullSchema.configurationItemTypes[ciKey];
	if (configurationItemType) {
		extractDialog.find("#d42ExtractParamCIKey").val(ciKey);
		extractDialog.find("#d42ExtractParamCIKeyView").empty().append(ciKey);
		extractDialog.find("#d42ExtractParamCIName").empty().append(configurationItemType.name);
		extractDialog.find("#d42ExtractParamDoql").html(configurationItemType.query);
		AJS.dialog2("#d42ExtractParamsDialog").show();
	}else {
		console.log("No configuration item type with key " + ciKey + " for showExtractParametersDialog");
	}
}
function extractParameters(){
	console.debug("Param extract started");
	var ciKey = AJS.$("#d42ExtractParamCIKey").val();
	var servletUrl = getStaticDataValue("url");
	var xsrfKey = getStaticDataValue("xsrfKey");
	var xsrfValue = getStaticDataValue("xsrfValue");
	var data = {};
	data[xsrfKey] = xsrfValue;
	data["ciKey"] = ciKey;
	AJS.$.ajax({
		url : servletUrl + "?action=extractParamTypes",
		type : 'POST',
		data : data,
		success : function(resp) {
			if (resp.result == "error") {
				addErrors(resp.errorMessages, resp.errors);
			}
			else {
				console.debug("Param extract successfull. Response: " + resp);
				AJS.dialog2("#d42ExtractParamsDialog").hide();
				AJS.messages.success({
					title : getStaticDataValue("extractParamHeader"),
					body : "<p>"
							+ getStaticDataValue("extractParamDescription")
							+ "</p>"
				});
				
				d42ConfigurationItemsData = resp;
				renderTopMenu();
				renderConfigurationItemView(resp.savedKey);
			}
		},
		error : function(xhr, ajaxOptions, thrownError) {
			console.debug("Param delete failed.");
			AJS.dialog2("#paramConfirmationDeleteDialog").hide();
			addErrors([ "Error " + xhr.status + ": " + getHttpErrorText(xhr.status) ]);
		}
	});
	return false;
}

function showDeleteParamDialog(ciKey, paramKey) {
	var configurationItemType = d42ConfigurationItemsData.fullSchema.configurationItemTypes[ciKey];
	if (configurationItemType && configurationItemType.parameterTypes && configurationItemType.parameterTypes[paramKey]) {
		var parameterType = configurationItemType.parameterTypes[paramKey];
		
		cleanErrors();
		var dialogBody = AJS.$("#paramConfirmationDeleteDialog");
		dialogBody.find("#deleteParamConfirmationCheckbox").prop("checked",false);
		dialogBody.find("#d42deleteParamCIKey").val(ciKey);
		dialogBody.find("#d42deleteParamKey").val(paramKey);
		dialogBody.find("#d42deleteParamCIKeyView").empty().append(ciKey);
		dialogBody.find("#d42deleteParamCIName").empty().append(configurationItemType.name);
		dialogBody.find("#d42deleteParamKeyView").empty().append(paramKey);
		dialogBody.find("#d42deleteParamName").empty().append(parameterType.name);
		AJS.dialog2("#paramConfirmationDeleteDialog").show();
	} else {
		console.error("No CI or parameter found")
	}
}

function deleteParamByDialog() {
	console.debug("Param delete started");
	var ciKey = AJS.$("#d42deleteParamCIKey").val();
	var key = AJS.$("#d42deleteParamKey").val();
	var agreeDelete = AJS.$("#deleteParamConfirmationCheckbox").prop("checked");
	var servletUrl = getStaticDataValue("url");
	var xsrfKey = getStaticDataValue("xsrfKey");
	var xsrfValue = getStaticDataValue("xsrfValue");
	var data = {};
	data[xsrfKey] = xsrfValue;
	data["key"] = key;
	data["ciKey"] = ciKey;
	data["agreeDelete"] = agreeDelete;
	AJS.$.ajax({
		url : servletUrl + "?action=deleteParamType",
		type : 'POST',
		data : data,
		success : function(resp) {
			if (resp.result == "error") {
				addErrors(resp.errorMessages, resp.errors);
			}
			else {
				console.debug("Param delete successfull. Response: " + resp);
				AJS.dialog2("#paramConfirmationDeleteDialog").hide();
				AJS.messages.success({
					title : getStaticDataValue("deleteParamHeader"),
					body : "<p>"
							+ getStaticDataValue("deleteParamDescription")
							+ "</p>"
				});
				
				d42ConfigurationItemsData = resp;
				renderTopMenu();
				renderConfigurationItemView(resp.savedKey);
			}
		},
		error : function(xhr, ajaxOptions, thrownError) {
			console.debug("Param delete failed. ");
			AJS.dialog2("#paramConfirmationDeleteDialog").hide();
			addErrors([ "Error " + xhr.status + ": " + getHttpErrorText(xhr.status)  ]);
		}
	});
	return false;
}

function showImportDialog(){
	cleanErrors();
	var dialogBody = AJS.$("#importSchemaFileUploadDialog");
	dialogBody.find(".checkbox").prop("checked",false);
	dialogBody.find("#d42ImportSchemaFileBlock").show();
	dialogBody.find("#d42ImportSchemaForm").get(0).reset();
	AJS.dialog2("#importSchemaFileUploadDialog").show();
}

function showStyleDialog(){
    cleanErrors();
    var dialogBody =  AJS.$("#configStyleDialog");
    dialogBody.find("#textSize").attr("value",dialogBody.find("#textSizeBuf").attr("value"));
    dialogBody.find("#accordionSwitch").attr("checked",dialogBody.find("#accordionSwitchBuf").attr("checked"));
    AJS.dialog2("#configStyleDialog").show();
}

function toggleFileUploadVision() {
	var loadDefault = AJS.$("#d42LoadDefault").prop("checked");
	if (loadDefault) {
		AJS.$("#d42ImportSchemaFileBlock").hide();
	} else {
		AJS.$("#d42ImportSchemaFileBlock").show();
	}
}

function processSubmitSchema(fullSchema, loadDefault) {
	if (!loadDefault) {
		try {
			JSON.parse(fullSchema);
		} catch (exp) {
			addErrors(null, {"fullSchema": getStaticDataValue("d42importErrorNotJson")});
			return;
		}
	}
	var agreeImport = AJS.$("#d42ImportAgree").prop("checked");
	var cleanImport = AJS.$("#d42ImportClean").prop("checked");
	var servletUrl = getStaticDataValue("url");
	var xsrfKey = getStaticDataValue("xsrfKey");
	var xsrfValue = getStaticDataValue("xsrfValue");
	var data = {};
	data[xsrfKey] = xsrfValue;
	data["cleanImport"] = cleanImport;
	data["agreeImport"] = agreeImport;
	data["loadDefault"] = loadDefault;
	data["fullSchema"] = fullSchema;
	AJS.$.ajax({
		url : servletUrl + "?action=importSchema",
		type : 'POST',
		data : data,
		success : function(resp) {
			if (resp.result == "error") {
				addErrors(resp.errorMessages, resp.errors);
			} else {
				console.debug("Import successfull. Response: " + resp);
				AJS.dialog2("#importSchemaFileUploadDialog").hide();
				AJS.messages.success({
					title : getStaticDataValue("importSuccessHeader"),
					body : "<p>"
							+ getStaticDataValue("importSuccessDescription")
							+ "</p>"
				});
				
				d42ConfigurationItemsData = resp;
				renderTopMenu();
				renderGeneralInfo();
				renderConfigurationItemView(resp.savedKey);
			}
		},
		error : function(xhr, ajaxOptions, thrownError) {
			console.debug("Param delete failed.");
			AJS.dialog2("#paramConfirmationDeleteDialog").hide();
			addErrors([ "Error " + xhr.status + ": " + getHttpErrorText(xhr.status)  ]);
		}
	});
	return false;
}

function processSubmitConfigStyle() {

    var accordionSwitch = AJS.$("#accordionSwitch").prop("checked");
    var textSize = AJS.$("#textSize").val();

    var servletUrl = getStaticDataValue("url");
    var xsrfKey = getStaticDataValue("xsrfKey");
    var xsrfValue = getStaticDataValue("xsrfValue");
    var data = {};
    data[xsrfKey] = xsrfValue;
    data["accordionSwitch"]=accordionSwitch;
    data["textSize"]=textSize;

    AJS.$.ajax({
        url : servletUrl + "?action=saveConfigStyle",
        type : 'POST',
        data : data,
        success : function(resp) {
            if (resp.result == "error") {
                addErrors(resp.errorMessages, resp.errors);
            } else {
                var dialogBody =  AJS.$("#configStyleDialog");
                dialogBody.find("#textSizeBuf").attr("value",dialogBody.find("#textSize").attr("value"));
                dialogBody.find("#accordionSwitchBuf").attr("checked",dialogBody.find("#accordionSwitch").attr("checked"));
                console.debug("Styles were saved successfully. Response: " + resp);
                AJS.dialog2("#configStyleDialog").hide();
                AJS.messages.success({
                    title : getStaticDataValue("saveStyleConfigSuccessHeader"),
                    body : "<p>"
                    + getStaticDataValue("saveStyleConfigSuccessDesc")
                    + "</p>"
                });

            }
        },
        error : function(xhr, ajaxOptions, thrownError) {
            console.debug("Save styles failed.");
            AJS.dialog2("#configStyleDialog").hide();
            addErrors([ "Error " + xhr.status + ": " + getHttpErrorText(xhr.status)  ]);
        }
    });


}

function submitImport() {
	var loadDefault = AJS.$("#d42LoadDefault").prop("checked");
	if (loadDefault) {
		processSubmitSchema(null, loadDefault);
		return;
	}
	var files = AJS.$("#d42ImportSchemaFile").get(0).files;
	if (files.length <= 0) {
		addErrors(null, {"fullSchema": getStaticDataValue("d42importErrorNoFile")});
		return;
	}
	var schemaFile = files[0];
	//200kb maximum schema
	if (schemaFile.size > 200000) {
		addErrors(null, {"fullSchema": getStaticDataValue("d42importErrorTooLarge")});
		return;
	}
	
	var reader = new FileReader();

    reader.onload = function(e) {
    	var schema = e.target.result;
    	processSubmitSchema(schema, loadDefault);
    }
    reader.readAsText(schemaFile);
}

AJS.toInit(function() {
	console.debug("Сonfiguration page inited");
	
	d42ConfigurationItemsData=loadData();

	if (d42ConfigurationItemsData) {
        renderGeneralInfo();
	}

	
	//register navigation lings: general
	AJS.$(".nav-general-link").click(function(e) {
		renderGeneralInfo();
		return false;
	});
	//register navigation links: ci link
	AJS.$(".d42MainMenu").on("click", ".nav-ci-link", function(e){
		renderConfigurationItemView(AJS.$(e.target).attr("d42Key"));
		return false;
	});
	//register navigation links: create new link
	AJS.$(".nav-addnew-link").click(function(e){
		renderConfigurationItemEdit();
		return false;
	});
	
	//register view links on general page
	
	AJS.$("#ciconf-body").on("click", ".viewItem", function(e){
		renderConfigurationItemView(AJS.$(e.target).attr("d42Key"));
		return false;
	});
	
	//register actions on edit item
	AJS.$("#ciconf-actions").on("click", ".editItem", function(e){
		renderConfigurationItemEdit(AJS.$(e.target).attr("d42Key"));
		return false;
	});
	AJS.$("#ciconf-body").on("click", ".editItem", function(e){
		renderConfigurationItemEdit(AJS.$(e.target).attr("d42Key"));
		return false;
	});
	
	//register actions on delete item
	AJS.$("#ciconf-actions").on("click", ".deleteItem", function(e){
		return showDeleteCiDialog(AJS.$(e.target).attr("d42Key"));
	});
	AJS.$("#ciconf-body").on("click", ".deleteItem", function(e){
		return showDeleteCiDialog(AJS.$(e.target).attr("d42Key"));
	});
	
	
	//register delete item dialog events
	AJS.$("#d42CancelCIButton").click(function(e) {
		e.preventDefault();
		AJS.dialog2("#ciConfirmationDeleteDialog").hide();
		return false;
	});
	AJS.$("#d42DeleteCIButton").click(function(e) {
		e.preventDefault();
		deleteCiByDialog();
		return false;
	});
	
	//register create / edit parameter dialog events
	AJS.$("#ciconf-body").on("click", "[d42action='addParameterType']", function(e){
		e.preventDefault();
		showEditParameterDialog(AJS.$(e.target).attr("d42CiKey"));
		return false;
	});
	
	AJS.$("#d42CancelSaveParamButton").click(function(e) {
		e.preventDefault();
		AJS.dialog2("#d42EditParamDialog").hide();
		return false;
	});
	
	AJS.$("#d42ParamValueType").change(function(e){
		refreshParameterAdditionalProperties();
	});
	
	AJS.$("#d42SaveParamButton").click(function(e) {
		e.preventDefault();
		saveParameter();
		return false;
	});
	

	AJS.$("#ciconf-body").on("click", ".editParam", function(e){
		e.preventDefault();
		var controlLink = AJS.$(e.target);
		showEditParameterDialog(controlLink.attr("d42CiKey"), controlLink.attr("d42Key"));
		return false;
	});
	
	//register extract parameters dialog events
	
	AJS.$("#ciconf-body").on("click", "[d42action='extractParameterTypes']", function(e){
		e.preventDefault();
		showExtractParametersDialog(AJS.$(e.target).attr("d42CiKey"));
		return false;
	});
	
	AJS.$("#d42CancelExtractParamButton").click(function(e) {
		e.preventDefault();
		AJS.dialog2("#d42ExtractParamsDialog").hide();
		return false;
	});
	
	AJS.$("#d42ExtractParamButton").click(function(e) {
		e.preventDefault();
		extractParameters();
		return false;
	});
	
	
	//register delete
	AJS.$("#ciconf-body").on("click", ".deleteParam", function(e){
		e.preventDefault();
		var controlLink = AJS.$(e.target);
		showDeleteParamDialog(controlLink.attr("d42CiKey"), controlLink.attr("d42Key"));
		return false;
	});
	
	AJS.$("#d42CancelDeleteParamButton").click(function(e) {
		e.preventDefault();
		AJS.dialog2("#paramConfirmationDeleteDialog").hide();
		return false;
	});
	
	AJS.$("#d42DeleteParamButton").click(function(e) {
		e.preventDefault();
		deleteParamByDialog();
		return false;
	});
	
	//register import
	AJS.$("#d42Import").click(function(e) {
		e.preventDefault();
		showImportDialog();
		return false;
	});

    AJS.$("#changeStyle").click(function(e) {
        e.preventDefault();
        showStyleDialog();
        return false;
    });
	
	AJS.$("#d42LoadDefault").click(function(e) {
		toggleFileUploadVision();
	});
	
	AJS.$("#d42CancelImportButton").click(function(e) {
		e.preventDefault();
		AJS.dialog2("#importSchemaFileUploadDialog").hide();
		return false;
	});
	
	AJS.$("#d42SumbitImportButton").click(function(e) {
		e.preventDefault();
		submitImport();
		return false;
	});

    AJS.$("#d42CancelStyleButton").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#configStyleDialog").hide();
        return false;
    });

    AJS.$("#d42SumbitStyleButton").click(function(e) {
        e.preventDefault();
        processSubmitConfigStyle();
        return false;
    });
	
	console.debug("configuration page finished");
	
});