/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.ao.ActiveObjectsException;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class MultiQuery
extends Query {
    private static final long serialVersionUID = 3712512925979747380L;
    private IteratorTicker globalIteratorTicker = new IteratorTicker();
    private MultiQueryMap<Class<? extends RawEntity<?>>, String> aliases = new MultiQueryMap(this.globalIteratorTicker);
    private MultiQueryMap<Class<? extends RawEntity<?>>, String> joins = new MultiQueryMap(this.globalIteratorTicker);

    public Query alias(Class<? extends RawEntity<?>> table, String alias) {
        if (this.aliases.containsValue(alias)) {
            throw new ActiveObjectsException("There is already a table aliased '" + alias + "' for this query!");
        }
        this.aliases.put(table, alias);
        return this;
    }

    public String getAlias(Class<? extends RawEntity<?>> table) {
        return this.aliases.get(table);
    }

    public Query join(Class<? extends RawEntity<?>> join, String on) {
        this.joins.put(join, on);
        return this;
    }

    public Query join(Class<? extends RawEntity<?>> join) {
        this.joins.put(join, null);
        return this;
    }

    public Map<Class<? extends RawEntity<?>>, String> getJoins() {
        return Collections.unmodifiableMap(this.joins);
    }

    public void setJoins(Map<Class<? extends RawEntity<?>>, String> joins) {
        this.joins.clear();
        this.joins.putAll(joins);
    }

    public MultiQuery(Query.QueryType type, String fields) {
        super(type, fields);
    }

    public static MultiQuery select() {
        return MultiQuery.select("''''primary_key_field''''");
    }

    public static MultiQuery select(String fields) {
        return new MultiQuery(Query.QueryType.SELECT, fields);
    }

    private static class MultiQueryMap<K, V>
    implements Map<K, V> {
        private Map<K, List<Integer>> data = new HashMap<K, List<Integer>>();
        private int counter = 0;
        private Map<Integer, V> values = new LinkedHashMap<Integer, V>();
        private Map<Integer, K> keys = new LinkedHashMap<Integer, K>();
        private IteratorTicker iteratorTicker;

        public MultiQueryMap(IteratorTicker iteratorTicker) {
            this.iteratorTicker = iteratorTicker;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public boolean isEmpty() {
            return this.values.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.data.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.values.containsValue(value);
        }

        @Override
        public V get(Object key) {
            if (this.iteratorTicker.isActive()) {
                ArrayList<Integer> idList = new ArrayList<Integer>(this.values.keySet());
                int idPosition = this.iteratorTicker.get();
                if ((idPosition += idList.size() - this.iteratorTicker.getSize()) >= 0 && idPosition < idList.size()) {
                    return this.values.get(idList.get(idPosition));
                }
                return null;
            }
            List<Integer> idsList = this.data.get(key);
            V value = null;
            if (idsList != null && idsList.size() > 1) {
                int id = idsList.get(0);
                if (++id >= idsList.size()) {
                    id = 1;
                }
                idsList.set(0, id);
                value = this.values.get(idsList.get(id));
            }
            return value;
        }

        @Override
        public V put(K key, V value) {
            List<Integer> idsList = this.data.get(key);
            V prevValue = null;
            if (idsList == null) {
                idsList = new ArrayList<Integer>();
                idsList.add(0);
                this.data.put(key, idsList);
            }
            if (idsList.size() > 1) {
                prevValue = this.values.get(idsList.get(idsList.size() - 1));
            }
            this.values.put(++this.counter, value);
            this.keys.put(this.counter, (Integer)key);
            idsList.add(this.counter);
            return prevValue;
        }

        @Override
        public V remove(Object key) {
            List<Integer> idsList = this.data.get(key);
            V prevValue = null;
            if (idsList != null) {
                int idVal = idsList.get(idsList.size() - 1);
                prevValue = this.values.remove(idVal);
                this.keys.remove(idVal);
                idsList.remove(idsList.size() - 1);
                if (idsList.size() <= 1) {
                    this.data.remove(idsList);
                }
            }
            return prevValue;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.counter = 0;
            this.data.clear();
            this.values.clear();
            this.keys.clear();
        }

        @Override
        public MultiQuerySet<K> keySet() {
            MultiQuerySet<K> keySet = new MultiQuerySet<K>(this.iteratorTicker);
            keySet.addAll(this.keys.values());
            return keySet;
        }

        @Override
        public Collection<V> values() {
            return this.values.values();
        }

        @Override
        public MultiQuerySet<Map.Entry<K, V>> entrySet() {
            MultiQuerySet<Map.Entry<AbstractMap.SimpleEntry<K, V>, V>> entrySet = new MultiQuerySet<Map.Entry<AbstractMap.SimpleEntry<K, V>, V>>(this.iteratorTicker);
            for (Integer id : this.keys.keySet()) {
                K key = this.keys.get(id);
                V value = this.values.get(id);
                AbstractMap.SimpleEntry<K, V> entry = new AbstractMap.SimpleEntry<K, V>(key, value);
                entrySet.add((Map.Entry<AbstractMap.SimpleEntry<K, V>, V>)entry);
            }
            return entrySet;
        }
    }

    private static class IteratorTicker {
        private int size = 0;
        private int idPosition = -1;
        private boolean active = false;

        private IteratorTicker() {
        }

        public void init(int size) {
            this.active = false;
            this.idPosition = -1;
            this.size = size;
        }

        public void start() {
            this.active = true;
            this.idPosition = -1;
        }

        public void tick() {
            if (this.active) {
                ++this.idPosition;
                if (this.idPosition >= this.size) {
                    this.active = false;
                }
            }
        }

        public int get() {
            if (this.active && this.idPosition < this.size) {
                return this.idPosition;
            }
            return -1;
        }

        public void reset() {
            this.active = false;
        }

        public boolean isActive() {
            return this.active;
        }

        public int getSize() {
            return this.size;
        }
    }

    private static class MultiQuerySet<K>
    implements Set<K> {
        private IteratorTicker iteratorTicker;
        List<K> storage = new ArrayList<K>();

        public MultiQuerySet(IteratorTicker iteratorTicker) {
            this.iteratorTicker = iteratorTicker;
        }

        @Override
        public int size() {
            return this.storage.size();
        }

        @Override
        public boolean isEmpty() {
            return this.storage.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.storage.contains(o);
        }

        @Override
        public Iterator<K> iterator() {
            this.iteratorTicker.init(this.storage.size());
            this.iteratorTicker.start();
            return new MultiSetIterator<K>(this.storage, this.iteratorTicker);
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] myArray = null;
            if (a != null && a.length > this.storage.size()) {
                myArray = a;
            }
            if (myArray == null) {
                myArray = new Object[this.storage.size()];
            }
            for (int i = 0; i < this.storage.size(); ++i) {
                myArray[i] = this.storage.get(i);
            }
            return myArray;
        }

        @Override
        public boolean add(K e) {
            this.storage.add(e);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            if (this.storage.indexOf(o) == -1) {
                return false;
            }
            this.storage.remove(this.storage.indexOf(o));
            return true;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.storage.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            for (K obj : c) {
                this.add(obj);
            }
            return true;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ArrayList<K> removals = new ArrayList<K>();
            for (K obj : this.storage) {
                if (c.contains(obj)) continue;
                removals.add(obj);
            }
            return this.removeAll(removals);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = false;
            for (Object o : c) {
                result = result || this.remove(o);
            }
            return result;
        }

        @Override
        public void clear() {
            this.storage.clear();
        }

        private static class MultiSetIterator<K>
        implements Iterator<K> {
            List<K> storage;
            int id = 0;
            private IteratorTicker iteratorTicker;

            public MultiSetIterator(List<K> storage, IteratorTicker iteratorTicker) {
                this.storage = storage;
                this.iteratorTicker = iteratorTicker;
            }

            @Override
            public boolean hasNext() {
                if (this.id >= this.storage.size()) {
                    this.iteratorTicker.reset();
                }
                return this.id < this.storage.size();
            }

            @Override
            public K next() {
                this.iteratorTicker.tick();
                return this.storage.get(this.id++);
            }

            @Override
            public void remove() {
                this.iteratorTicker.tick();
                if (this.hasNext()) {
                    this.storage.remove(this.id);
                }
            }
        }
    }
}

