/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.service;

import com.device42.atlas.common.model.serialization.JsonParameters;
import com.device42.atlas.common.service.RestItem;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;

public class RestList
implements Iterable<RestItem> {
    private static String TOKEN_OPT_ITEMS = "optItems";
    private static String TOKEN_TOTAL = "total";
    private static String TOKEN_OFFSET = "offset";
    @XmlElement
    private List<RestItem> optItems;
    @XmlElement
    private int total;
    @XmlElement
    private int offset;
    @XmlElement
    private int limit;

    public RestList() {
        this.optItems = new ArrayList<RestItem>();
    }

    public RestList(List<RestItem> optItems) {
        this.optItems = optItems;
    }

    public void addOption(RestItem optItem) {
        this.optItems.add(optItem);
    }

    public JsonObject toJson() {
        JsonParameters jsonParameters = new JsonParameters();
        if (this.optItems == null) {
            jsonParameters.addParameter(TOKEN_OPT_ITEMS, null);
        } else {
            ArrayList<JsonObject> jsonOptItems = new ArrayList<JsonObject>();
            for (RestItem item : this.optItems) {
                jsonOptItems.add(item.toJson());
            }
            jsonParameters.addParameter(TOKEN_OPT_ITEMS, jsonOptItems);
            jsonParameters.addParameter(TOKEN_TOTAL, this.total);
            jsonParameters.addParameter(TOKEN_OFFSET, this.offset);
        }
        return jsonParameters.getJsonObject();
    }

    @Override
    public Iterator<RestItem> iterator() {
        return this.optItems.iterator();
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

