/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core;

import com.device42.atlas.common.model.core.ConfigurationItem;
import com.device42.atlas.common.model.core.Parameter;
import com.device42.atlas.common.model.core.schema.ParameterType;

public class ConfigurationItemParameter
extends Parameter {
    private ConfigurationItem configurationItem;
    private String value;

    public ConfigurationItemParameter(ParameterType type) {
        super(type);
    }

    @Override
    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.configurationItem != null) {
            return this.configurationItem.getDisplayName();
        }
        return null;
    }

    public void setConfigurationItem(ConfigurationItem configurationItem) {
        this.configurationItem = configurationItem;
    }

    public ConfigurationItem getConfigurationItem() {
        return this.configurationItem;
    }

    @Override
    public boolean checkParameterFilterValue(String parameterFilterValue) {
        if (this.configurationItem != null) {
            if (Long.toString(this.configurationItem.getStorageId()).contains(parameterFilterValue)) {
                return true;
            }
            for (Parameter parameter : this.configurationItem) {
                if (!parameter.checkParameterFilterValue(parameterFilterValue)) continue;
                return true;
            }
        }
        return false;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

