/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job.upgrade.v36;

import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.job.D42PluginUpgradeTask;
import com.device42.atlas.common.job.upgrade.AbstractUpgradeExecutor;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.MultiReferenceParameterType;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.util.D42Exception;
import java.util.HashSet;

public class V35_36UpgradeExecutor
extends AbstractUpgradeExecutor {
    private final Logger.Log log = Logger.getInstance(V35_36UpgradeExecutor.class);

    public V35_36UpgradeExecutor(D42PluginUpgradeTask upgradeTask) {
        super(upgradeTask);
    }

    @Override
    public void execute() {
        D42DataManager dataManager = this.upgradeTask.getDataManager();
        this.log.info((Object)"Upgrading to version 36");
        ConfigurationItemType dev = dataManager.getConfigurationItemTypeByKey("D");
        ConfigurationItemType.DOQLQuery devQuery = null;
        try {
            devQuery = new ConfigurationItemType.DOQLQuery("SELECT view_device_v1.device_pk, view_device_v1.name, view_device_v1.last_changed, view_device_v1.asset_no, view_device_v1.serial_no, view_device_v1.uuid, view_device_v1.service_level, view_device_v1.type, view_device_v1.tags, view_customer_v1.name, view_hardware_v1.hardware_pk, view_hardware_v1.name, view_virtual_host.name, view_rack_v1.rack_pk, view_rack_v1.name, view_room_v1.room_pk, view_room_v1.name, view_building_v1.building_pk, view_building_v1.name, array_agg(view_ipaddress_v1.ipaddress_pk) FROM view_device_v1 LEFT JOIN view_customer_v1 ON view_device_v1.customer_fk = view_customer_v1.customer_pk LEFT JOIN view_hardware_v1 ON view_device_v1.hardware_fk = view_hardware_v1.hardware_pk LEFT JOIN view_device_v1 view_virtual_host ON view_device_v1.virtual_host_device_fk = view_virtual_host.device_pk  LEFT JOIN view_room_v1 ON view_device_v1.calculated_room_fk = view_room_v1.room_pk LEFT JOIN view_building_v1 ON view_device_v1.calculated_building_fk = view_building_v1.building_pk LEFT JOIN view_rack_v1 ON view_device_v1.calculated_rack_fk = view_rack_v1.rack_pk LEFT JOIN view_ipaddress_v1 ON view_ipaddress_v1.device_fk = view_device_v1.device_pk GROUP BY view_device_v1.device_pk, view_device_v1.name, view_device_v1.last_changed, view_device_v1.asset_no, view_device_v1.serial_no, view_device_v1.uuid, view_device_v1.service_level, view_device_v1.type, view_device_v1.tags, view_customer_v1.name, view_hardware_v1.hardware_pk, view_hardware_v1.name, view_virtual_host.name, view_rack_v1.rack_pk, view_rack_v1.name, view_room_v1.room_pk, view_room_v1.name, view_building_v1.building_pk, view_building_v1.name ORDER BY view_device_v1.device_pk");
        }
        catch (D42Exception e) {
            e.printStackTrace();
        }
        dev.setQuery(devQuery);
        ParameterType oldIpParameterType = dev.getParameterTypeByKey("view_device_v1_ipaddress_pk");
        MultiReferenceParameterType parameterType = new MultiReferenceParameterType();
        parameterType.setKey("view_device_v1_ipaddresses_pk");
        parameterType.setDefaultFilterViewEnabled(true);
        parameterType.setName("IP Addresses");
        parameterType.setDescription("IP Addresses for Device");
        parameterType.setEnabled(true);
        parameterType.setSearchEnabled(true);
        parameterType.setViewWeight(1800);
        parameterType.setDefaultFilterViewEnabled(true);
        parameterType.setAdditionalTypeData("{\"configurationItemKey\":\"IP\",\"idsIndex\":19}");
        HashSet<ParameterType> parameterTypes = new HashSet<ParameterType>(dev.getParameterTypes());
        parameterTypes.remove(oldIpParameterType);
        parameterTypes.add(parameterType);
        dev.clearParameterTypes();
        dev.setParameterTypes(parameterTypes);
        try {
            if (oldIpParameterType != null) {
                dataManager.removeParameterType(dev.getKey(), oldIpParameterType.getKey());
            }
            dataManager.saveConfigurationItemType(dev);
        }
        catch (D42Exception e) {
            e.printStackTrace();
        }
        this.log.info((Object)"Upgrade to version 36 completed");
    }
}

