/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job.upgrade.v25;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.device42.atlas.common.job.D42PluginUpgradeTask;
import com.device42.atlas.common.job.upgrade.AbstractUpgradeExecutor;
import com.device42.atlas.common.model.D42ConnectionInfo;
import com.device42.atlas.common.util.CryptUtils;
import com.device42.atlas.common.util.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class V24_25UpgradeExecutor
extends AbstractUpgradeExecutor {
    Logger.Log log = Logger.getInstance(V24_25UpgradeExecutor.class);
    private static final String V2_4_DEVICE42_BASE_URL = "BASE_URL";
    private static final String V2_4_DEVICE42_USERNAME = "USERNAME";
    private static final String V2_4_DEVICE42_PASSWORD = "PASSWORD";
    private static final String V2_4_CRON_PREFIX = "CRON.";
    private static final String V2_4_DEVICE42_CRON_SETTINGS_KEY = "DEVICE42_CRON_SETTINGS_KEY";
    private static final String V2_4_CRON_DEFAULT_NAME = "default";
    private static final String V2_4_DEVICE42_SETTINGS_KEY = "DEVICE42_SETTINGS";

    private void upgradeConnection() {
        D42ConnectionInfo connectionInfo = this.upgradeTask.getSettingsManager().getConnectionInfo();
        if (connectionInfo == null || !connectionInfo.isConfigured()) {
            PluginSettings pluginSettings = this.upgradeTask.getPluginSettingsFactory().createSettingsForKey(V2_4_DEVICE42_SETTINGS_KEY);
            connectionInfo = new D42ConnectionInfo(null);
            connectionInfo.setBaseUrl(ObjectUtils.stringValue(pluginSettings.get(V2_4_DEVICE42_BASE_URL)));
            connectionInfo.setUsername(ObjectUtils.stringValue(pluginSettings.get(V2_4_DEVICE42_USERNAME)));
            String password = ObjectUtils.stringValue(pluginSettings.get(V2_4_DEVICE42_PASSWORD));
            if (StringUtils.isNotBlank((String)password)) {
                try {
                    password = CryptUtils.defaultDecrypt(password);
                    connectionInfo.setPassword(password);
                }
                catch (Exception e) {
                    this.log.error((Object)"Password decryption failed, skipping the connection settings");
                    connectionInfo.setPassword(null);
                }
            }
            if (connectionInfo.isConfigured()) {
                this.upgradeTask.getSettingsManager().setConnectionInfo(connectionInfo);
            }
        }
    }

    private void upgradeCronSettings() {
        PluginSettings pluginSettings;
        String oldCron;
        String cron = this.upgradeTask.getSettingsManager().getCron();
        if (StringUtils.isBlank((String)cron) && StringUtils.isNotBlank((String)(oldCron = ObjectUtils.stringValue((pluginSettings = this.upgradeTask.getPluginSettingsFactory().createSettingsForKey(V2_4_DEVICE42_CRON_SETTINGS_KEY)).get(V2_4_CRON_PREFIX.concat(V2_4_CRON_DEFAULT_NAME)))))) {
            this.upgradeTask.getSettingsManager().setCron(oldCron);
        }
    }

    public V24_25UpgradeExecutor(D42PluginUpgradeTask upgradeTask) {
        super(upgradeTask);
    }

    @Override
    public void execute() {
        this.upgradeConnection();
        this.upgradeCronSettings();
    }
}

