/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job;

import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.ObjectUtils;

public class ConfigurationItemCollectionStatistics
implements Parameterizable {
    public static String CI_PREFIX = "CI_";
    public static String COLLECTED_COUNT = "collected";
    public static String TOTAL_COUNT = "total";
    public static String COLLECTION_STATUS = "collectionStatus";
    private final ConfigurationItemType type;
    long collected;
    long total;
    ConfigurationItemCollectionStatus collectionStatus;

    public ConfigurationItemCollectionStatistics(ConfigurationItemType type, long collected, long total, ConfigurationItemCollectionStatus collectionStatus) {
        this.type = type;
        this.collected = collected;
        this.total = total;
        this.collectionStatus = collectionStatus;
    }

    public ConfigurationItemCollectionStatistics(ConfigurationItemType type, ParameterDonor input) {
        this.type = type;
        this.loadFromDonor(input);
    }

    long getCollected() {
        return this.collected;
    }

    long getTotal() {
        return this.total;
    }

    public ConfigurationItemCollectionStatus getCollectionStatus() {
        return this.collectionStatus;
    }

    public ConfigurationItemType getType() {
        return this.type;
    }

    private String getParameterKey(String keyPart) {
        return CI_PREFIX + this.type.getKey() + keyPart;
    }

    @Override
    public void saveToAcceptor(ParameterAcceptor output) {
        output.addParameter(this.getParameterKey(COLLECTED_COUNT), this.collected);
        output.addParameter(this.getParameterKey(TOTAL_COUNT), this.total);
        output.addParameter(this.getParameterKey(COLLECTION_STATUS), (Object)this.collectionStatus);
    }

    @Override
    public void loadFromDonor(ParameterDonor input) {
        this.collected = ObjectUtils.longValue(input.get(this.getParameterKey(COLLECTED_COUNT)));
        this.total = ObjectUtils.longValue(input.get(this.getParameterKey(TOTAL_COUNT)));
        this.collectionStatus = ObjectUtils.enumValue(input.get(this.getParameterKey(COLLECTION_STATUS)), ConfigurationItemCollectionStatus.class, null);
    }

    @Override
    public void clear(ParameterAcceptor output) {
        output.removeParameter(this.getParameterKey(COLLECTED_COUNT));
        output.removeParameter(this.getParameterKey(TOTAL_COUNT));
        output.removeParameter(this.getParameterKey(COLLECTION_STATUS));
    }

    public static enum ConfigurationItemCollectionStatus {
        NOT_STARTED("com.device42.atlas.page.settings.status.ci.notstarted"),
        COLLECTING("com.device42.atlas.page.settings.status.ci.scanning"),
        DONE("com.device42.atlas.page.settings.status.ci.done"),
        ERROR("com.device42.atlas.page.settings.status.ci.error"),
        SKIPPED("com.device42.atlas.page.setting.status.ci.skipped");

        private final String i18n;

        private ConfigurationItemCollectionStatus(String i18n) {
            this.i18n = i18n;
        }

        public String getI18n() {
            return this.i18n;
        }
    }
}

