function loadData() {
    console.debug("Data collection from remote started");
    var schema=null;
    var servletUrl = AJS.contextPath()+"/plugins/servlet/d42/configurationadmin";
    AJS.$.ajax({
        url : servletUrl + "?action=getSchemaAndData",
        type : 'GET',
        async: false,
        success : function(resp) {
            console.debug("Data collection successfull. Response: " + resp);
            schema=resp;
        },
        error : function(xhr, ajaxOptions, thrownError) {
            console.debug("Data collection failed.");
            addErrors([ "Error " + xhr.status + ": " + getHttpErrorText(xhr.status) ]);
        }

    });

    return schema;

}

function addErrors(errorMessages, errors) {
    cleanErrors();
    if(errorMessages) {
        var errorBody = "";
        AJS.$.each(errorMessages, function(index, errorMessage) {
            errorBody += "<p>" + errorMessage + "</p>";
        });
        AJS.messages.error({
            title : getStaticDataValue("errorHeader"),
            body : errorBody
        });
    }
    if (errors) {
        AJS.$.each(errors, function(key, value) {
            if (typeof value != "string") {
                value = prepareNestedError(value);
            }
            AJS.$("#d42EditForm div.error[d42Key='" + key + "']").append(value).show();
            AJS.$("#ciConfirmationDeleteDialog div.error[d42Key='" + key + "']").append(value).show();
            AJS.$("#d42EditParamDialog div.error[d42Key='" + key + "']").append(value).show();
            AJS.$("#paramConfirmationDeleteDialog div.error[d42Key='" + key + "']").append(value).show();
            AJS.$("#importSchemaFileUploadDialog div.error[d42Key='" + key + "']").append(value).show();
            AJS.$("#configStyleDialog div.error[d42Key='" + key + "']").append(value).show();
            AJS.$("#d42ExtractParamsDialog div.error[d42Key='" + key + "']").append(value).show();

        });
    }
}

function cleanErrors() {
    AJS.$("div.error").empty().hide();
}

function getHttpErrorText(status) {
    switch(status) {
        case 412:
            return getStaticDataValue("xsrfError");
        case 501:
            return getStaticDataValue("badActionError");
        case 403:
        case 401:
            return getStaticDataValue("notAuthorizedError")
    }
    return getStaticDataValue("unknownError")
}

function getStaticDataValue(key) {
    return AJS.$("#d42Messages").attr(key);
}

function isServiceDesk() {

    var flag=false;

    AJS.$(".aui-nav a").each(function(index,key){

        if (AJS.$(key).attr("data-link-id")) {
            if (AJS.$(key).attr("data-link-id").includes("servicedesk")) {
                flag=true;
            }
        }

    });

    return flag;

}

function isServiceDeskPortal() {

    return (AJS.$(window).attr("location").pathname.includes("portal")&&
        (AJS.$(window).attr("location").pathname.includes("servicedesk")));

}


function serviceDeskOptimize() {

    AJS.$("#cf-choise-item").find("input").each(function () {

        AJS.$(this).focus(function (a) {

            a.preventDefault();
            a.stopPropagation();

        });

    });

    AJS.$("#cf-choise-sub-item").find("div.select2-drop-multi").each(function () {

        AJS.$(this).mousedown(function (a) {

            a.preventDefault();
            a.stopPropagation();

        });

    });

}

function addSmartSearchHandlers() {

    AJS.$(".showSearch").live("click",function (e) {

        var fid=AJS.$(this).parent().find("select.d42-data-field-type-select").attr("first-id");
        var sid=AJS.$(this).parent().find("select.d42-data-field-type-select").attr("second-id");

        showSmartSearch(AJS.$(this).parent().find("select.d42-data-field-type-select option:selected").val(),fid,sid);

    });


    AJS.$(".d42-apply").live("click",function (e) {
        e.preventDefault();

        var fid=AJS.$(this).closest("section").attr("fid");
        var sid=AJS.$(this).closest("section").attr("sid");
        if (sid || fid) {
            applyFilter(fid,sid);
            AJS.dialog2("#search_"+sid).hide();
            return false;
        } else {
            return true;
        }
    });


    AJS.$(".d42-cancel").live("click",function (e) {
        e.preventDefault();
        var sid=AJS.$(this).closest("section").attr("sid");
        if (sid) {
            AJS.dialog2("#search_"+sid).hide();
            return false;
        } else {
            return true;
        }
    });

}

function accordionStyle() {
    var acc = AJS.$(".accordion");

    AJS.$.each(acc, function(index, key) {

        AJS.$(acc.first()).css("border-top-left-radius","3px");
        AJS.$(acc.first()).css("border-top-right-radius","3px");

        AJS.$(acc.last()).css("border-bottom-left-radius","3px");
        AJS.$(acc.last()).css("border-bottom-right-radius","3px");

        if (!AJS.$(key).hasClass("parsed")) {

            AJS.$(key).click(function(e) {
                this.classList.toggle("active-accordion-item");

                if (AJS.$(this).hasClass("active-accordion-item")) {

                    AJS.$(this).find("span").remove();
                    AJS.$(this).append('<span class="aui-icon aui-icon-small aui-iconfont-chevron-double-up aui-iconfont-arrows-up"/>')

                } else {

                    AJS.$(this).find("span").remove();
                    AJS.$(this).append('<span class="aui-icon aui-icon-small aui-iconfont-chevron-double-down aui-iconfont-arrows-down"/>')

                }

                var panel = this.nextElementSibling;
                if (panel.style.maxHeight){
                    panel.style.maxHeight = null;
                } else {
                    panel.style.maxHeight = panel.scrollHeight + "px";
                }
                e.stopPropagation();
            });

            AJS.$(key).addClass("parsed");

        }

    });
}



