function setD42ControlDisability(disabled) {
	AJS.$('.d42control').attr('disabled', disabled);
	AJS.$('.d42controldisabled').attr('disabled', true);
}
function disableD42Controls() {
	setD42ControlDisability(true);
}
function enableD42Controls() {
	setD42ControlDisability(false);
}

function addErrors(errorMessages) {
	var errorBody = '';
	AJS.$.each(errorMessages, function(index, errorMessage) {
		errorBody += '<p>' + errorMessage + '</p>';
	});
	AJS.messages.error({
		title : AJS.$('#d42messages').attr('errorHeader'),
		body : errorBody
	});
}

function getD42FirstLevelKey(data) {
	if (AJS.$('#d42messages').attr('applicationType') == 'jira'
			&& !AJS.$('#d42messages').attr('isTemplate')) {
		data['projectKey'] = AJS.$('#d42project-key').val();
	}
	if (AJS.$('#d42messages').attr('applicationType') == 'conf'
			&& !AJS.$('#d42messages').attr('isTemplate')) {
		data['key'] = AJS.$('#d42space-key').val();

	}
}

function loadD42FilterData(secondLevelId, refreshFromTemplate) {
	var servletUrl = AJS.$('#d42messages').attr('url');
	var xsrfKey = AJS.$('#d42messages').attr('xsrfTokenKey');
	var xsrfValue = AJS.$('#d42messages').attr('xsrfTokenValue');
	// var secondLevelId = AJS.$('#d42second-level').val();
	var isTemplate = AJS.$('#d42messages').attr('isTemplate')
			|| refreshFromTemplate;
	var data = {
		firstLevelId : (refreshFromTemplate ? 0 : AJS.$('#d42first-level')
				.val()),
		secondLevelId : secondLevelId,
		isTemplate : isTemplate
	};
	if (!refreshFromTemplate) {
		if (secondLevelId == -1) {
			AJS.$('#d42newFilterNameSection').show();
		} else {
			AJS.$('#d42newFilterNameSection').hide();
		}
	}
	data[xsrfKey] = xsrfValue;
	getD42FirstLevelKey(data);

	AJS.$.ajax({
		url : servletUrl + '?action=getFieldFilter',
		type : 'GET',
		data : data,
		success : function(resp) {
			if (resp.result == 'error' && resp.errorMessages) {
				addErrors(resp.errorMessages);
				return;
			}
			AJS.$.each(resp.ciFilters, function(ciIndex, ciFilter) {
				AJS.$('.d42CISwitchedOn[configurationItemType='
										+ ciIndex + ']').prop('checked',
								ciFilter.switchedOn);
				AJS.$.each(ciFilter.parameterFilters, function(parameterIndex,
						parameterFilter) {
					AJS.$('.d42ParamSwitchedOn[configurationItemType='
									+ ciIndex + '][parameterType='
									+ parameterIndex + ']').prop('checked',
							parameterFilter.switchedOn);
					AJS.$('.d42ParamValue[configurationItemType='
											+ ciIndex + '][parameterType='
											+ parameterIndex + ']').val(
									parameterFilter.filterValue);
				});
			});
			enableD42Controls();
			d42SetSaveButtonDisabled(!refreshFromTemplate);
		}
	});

}

function collectFilterValues() {
	var ciFilters = {};
	AJS.$('.d42CISwitchedOn').each(
			function(ciIndex, ciObject) {
				var ciFilter = {};
				var ciCheckboxDom = AJS.$(ciObject);
				var ciKey = ciCheckboxDom.attr('configurationItemType');
				var ciSwitchedOn = ciCheckboxDom.prop('checked');
				ciFilter['switchedOn'] = ciSwitchedOn;
				var paramFilters = {};
				AJS.$('.d42ParamSwitchedOn[configurationItemType=' + ciKey+ ']').each(
						function(paramIndex, paramObject) {
							var paramFilter = {};
							var paramCheckboxDom = AJS.$(paramObject);
							var paramKey = paramCheckboxDom
									.attr('parameterType');
							var paramSwitchedOn = paramCheckboxDom
									.prop('checked');
							paramFilter['switchedOn'] = paramSwitchedOn;
							paramFilter['filterValue'] = AJS.$(
									'.d42ParamValue[configurationItemType='
											+ ciKey + '][parameterType='
											+ paramKey + ']').val();
							paramFilters[paramKey] = paramFilter;
						});
				ciFilter['parameterFilters'] = paramFilters;
				ciFilters[ciKey] = ciFilter;
			});
	return ciFilters;
}

function saveChanges() {
	var servletUrl = AJS.$('#d42messages').attr('url');
	var xsrfKey = AJS.$('#d42messages').attr('xsrfTokenKey');
	var xsrfValue = AJS.$('#d42messages').attr('xsrfTokenValue');
	var secondLevelId = AJS.$('#d42second-level').val()
	var isTemplate = AJS.$('#d42messages').attr('isTemplate');
	var data = {
		firstLevelId : AJS.$('#d42first-level').val(),
		secondLevelId : secondLevelId,
		isTemplate : isTemplate
	};
	data[xsrfKey] = xsrfValue;
	data['ciFilters'] = JSON.stringify(collectFilterValues());
	if (secondLevelId == -1) {
		if (!AJS.$('#d42newFilterName').val()) {
			// No name for new filter = we should require the name entered
			addErrors([ AJS.$('#d42messages').attr("errorName") ]);
			enableD42Controls();
			return;
		}
		data['name'] = AJS.$('#d42newFilterName').val();
	}
	getD42FirstLevelKey(data);
	AJS.$.ajax({
		url : servletUrl + '?action=saveConfig&' + xsrfKey + '=' + xsrfValue,
		type : 'POST',
		data : data,
		success : function(resp) {
			if (resp.result == 'error' && resp.errorMessages) {
				addErrors(resp.errorMessages);
				enableD42Controls();
			} else {
				AJS.messages.success({
					title : AJS.$('#d42messages').attr('saveHeader'),
					body : '<p>'
							+ AJS.$('#d42messages').attr('saveDescription')
							+ '</p>'
				});
				if (secondLevelId == -1) {
					AJS.$('#d42second-level option:last').before(
							AJS.$('<option>', {
								value : resp.secondLevelId
							}).text(resp.name));
					AJS.$('#d42newFilterName').val('');
					AJS.$('#d42second-level').val(resp.secondLevelId).trigger(
							"change");
				}
				enableD42Controls();
				d42SetSaveButtonDisabled(true);
			}
		},
		error : function(xhr, ajaxOptions, thrownError) {
			addErrors([ "Error " + xhr.status + ": " + thrownError ]);
			enableD42Controls();
		}
	});
}

function resetChanges() {
	var servletUrl = AJS.$('#d42messages').attr('url');
	var xsrfKey = AJS.$('#d42messages').attr('xsrfTokenKey');
	var xsrfValue = AJS.$('#d42messages').attr('xsrfTokenValue');
	var secondLevelId = AJS.$('#d42second-level').val();
	var isTemplate = AJS.$('#d42messages').attr('isTemplate');
	var data = {
		firstLevelId : AJS.$('#d42first-level').val(),
		secondLevelId : secondLevelId,
		isTemplate : isTemplate
	};
	if (secondLevelId == -1) {
		AJS.$('#d42second-level').val(0).trigger("change");
		AJS.$('#d42newFilterName').val('');
		loadD42FilterData(0, false);
		return;
	}
	data[xsrfKey] = xsrfValue;
	getD42FirstLevelKey(data);
	AJS.$.ajax({
				url : servletUrl + '?action=resetConfig',
				type : 'POST',
				data : data,
				success : function(resp) {
					if (resp.result == 'error' && resp.errorMessages) {
						addErrors(resp.errorMessages);
						enableD42Controls();
					} else {
						AJS.messages.warning({
							title : AJS.$('#d42messages').attr('resetHeader'),
							body : '<p>'
									+ AJS.$('#d42messages').attr(
											'resetDescription') + '</p>'
						});
						if ((AJS.$('#d42messages').attr('applicationType') == 'conf' || isTemplate)
								&& secondLevelId != 0) {
							AJS.$(
									'#d42second-level option[value="'
											+ secondLevelId + '"]').remove();
							AJS.$('#d42second-level').val(0).trigger("change");
							secondLevelId = 0;
						}
						loadD42FilterData(secondLevelId, false);
					}
				},
				error : function(xhr, ajaxOptions, thrownError) {
					addErrors([ "Error " + xhr.status + ": " + thrownError ]);
					enableD42Controls();
				}
			});
}

function d42SetSaveButtonDisabled(isDisabled) {
	AJS.$('#filters-save-button').attr('disabled', isDisabled);
}

function d42SelectAllCI(isSelected) {
	AJS.$('.d42CISwitchedOn').prop('checked', isSelected);
}

var d42IsSave = true;
var d42IsControlChange = false;

AJS.toInit(function() {
	//AJS.$('.d42templateId').auiSelect2();
		
	// adding load filter dialog.
	var loadTemplateDialog = AJS.InlineDialog(
			AJS.$("#d42-load-filter-trigger"), "d42-load-filter", function(
					content, trigger, showPopup) {
				content.css({
					padding : "20px"
				}).html(AJS.$("#d42-load-filter").html().split("-dialogPrep").join(""));
				showPopup();
				//For new version only the part below is needed on control init.
				AJS.$('.d42templateId').auiSelect2();
				AJS.$('.d42TemplateApply').click(function(e) {
					
					loadD42FilterData(AJS.$('#d42templateId').val(), true);
					loadTemplateDialog.hide();
					// AJS.$('#d42-load-filter').removeAttr('open');
				});
				AJS.$('.d42TemplateCancel').click(function(e) {
					loadTemplateDialog.hide();
					// AJS.$('#d42-load-filter').removeAttr('open');
				});
				return false;
			}, {
				persistent : true,
				useLiveEvents : true
			});

	

	AJS.$('#d42second-level').auiSelect2();
	// Change the values on the change of custom field id
	AJS.$('#d42second-level').change(function() {
		d42IsControlChange = true;
		AJS.$('#d42FilterSubmissionForm').submit();
	});

	// Separate function to avoid navigation change message.
	AJS.$('#d42FilterSubmissionForm').submit(function(e) {
		e.preventDefault();
		disableD42Controls();
		// If we need to refresh the controls - we need to reset the change
		// information to avoid navigation change message
//		AJS.$('#d42selectAll, #d42deselectAll').remove();
		if (d42IsControlChange) {
			d42IsControlChange = false;
			loadD42FilterData(AJS.$('#d42second-level').val(), false);
		} else {
			if (d42IsSave)
				saveChanges();
			else
				resetChanges();
		}

	});

	// Save changes
	AJS.$('#filters-save-button').click(function(e) {
		d42IsSave = true;
	});
	
	// Reset changes
	AJS.$('#filters-reset-button').click(function(e) {
		d42IsSave = false;
	});
	
	// Select all CI
	AJS.$('#d42selectAll').change(function(e) {
		AJS.$('#d42deselectAll').prop('checked', false);
		if (AJS.$(this).is(':checked')) {
			d42SelectAllCI(true);
			d42SetSaveButtonDisabled(false);
		}
	});
	
	// Deselect all CI
	AJS.$('#d42deselectAll').change(function(e) {
		AJS.$('#d42selectAll').prop('checked', false);
		if (AJS.$(this).is(':checked')) {
			d42SelectAllCI(false);
			d42SetSaveButtonDisabled(false);
		}
	});
		
	AJS.$('.d42control').click(function(e) {
		AJS.$('#d42selectAll').prop('checked', false);
		AJS.$('#d42deselectAll').prop('checked', false);
	});
		
	AJS.$('.d42CISwitchedOn, .d42ParamSwitchedOn, .d42ParamValue').change(
			function(e) {
				d42SetSaveButtonDisabled(false);
			});
});