// Legacy for confluence plugin v 1.0.1
// Get device id by name
function d42GetDeviceByName(name) {
	var options = d42OptionsAjaxCall("d42Options/getDeviceIdByName", {
		"name": name
	});
	if (options && options.length > 0 && options[0].id)
		return options[0].id;
	return "";
}

// Legacy for confluence plugin v 1.0.1
// Load value from previous version of plugin if it exists
function d42LoadSimpleLegacy(d42ValueObject) {
	var form = d42ValueObject.closest("form");
	var result = "";
	var objectId = form.find("#macro-param-objectId").val();
	if (objectId) {
		result = "D" + objectId;
	} else {
		var objectName = form.find("#macro-param-objectName").val();
		if (objectName) 
			result = "D" + d42GetDeviceByName(objectName);
	}
	form.find("#macro-param-objectType").val("");
	form.find("#macro-param-objectId").val("");
	form.find("#macro-param-objectName").val("");
	return result;
}
// Legacy for confluence plugin v 1.0.1
// Hide legacy values
function d42HideSimpleLegacy(d42ValueObject) {
	var form = d42ValueObject.closest("form");
	form.find("#macro-param-div-objectType").hide();
	form.find("#macro-param-div-objectId").hide();
	form.find("#macro-param-div-objectName").hide();
}

function d42LoadTableLegacy(d42TypeObject) {
	var form = d42TypeObject.closest("form");
	var result = "";
	var type = form.find("#macro-param-objectType");
	switch (type.val()) {
	case "Device":
		result = "D";
		break;
	case "Rack":
		result = "R";
		break;
	case "PDU":
		result = "U";
		break;
	case "Part":
		result = "P";
		break;
	}
	return result;
}

function d42HideTableLegacy(d42TypeObject) {
	var form = d42TypeObject.closest("form");
	form.find("#macro-param-div-objectType").hide();
	form.find("#macro-param-div-filterParam1").hide();
	form.find("#macro-param-div-filterParamValue1").hide();
	form.find("#macro-param-div-filterParam2").hide();
	form.find("#macro-param-div-filterParamValue2").hide();
}

function getSpaceId() {
	var spaceId = "0";
	AJS.$.ajax({
		url : AJS.contextPath() + "/rest/api/space/" + AJS.params.spaceKey,
		type : "get",
		dataType : "json",
		async : false,
		success : function(data) {
			spaceId = data.id;
		}
	});
	return spaceId;
}

function d42RenderSimpleMacro() {
	var d42ValueObject = AJS.$("#macro-param-d42Value");
	if (d42ValueObject && d42ValueObject.is(":visible")) {
		d42HideSimpleLegacy(d42ValueObject);
		var spaceId = getSpaceId();
		var prevValue;
		if(!d42ValueObject.val()) {
			prevValue = d42LoadSimpleLegacy(d42ValueObject);
		} else {
			prevValue = d42ValueObject.val();
		}
		d42RenderEdit(spaceId, "0", "#macro-param-d42Value", prevValue);
	}
}

function d42RefillTableTypes(firstLevelId, secondLevelId) {
	var options = d42OptionsAjaxCall("d42Options/types", {
		"firstLevelId" : firstLevelId,
		"secondLevelId" : secondLevelId,
		"spaceKey" : AJS.params.spaceKey
	});
	var typesSelect = AJS.$("select.d42-type-select");
	d42FillSelect(options, typesSelect, true);
	//select the first value to avoid empty selection
	typesSelect.find("option:first").prop('selected', true);
	typesSelect.change();
	return options;	
}



function d42RenderTableEdit(firstLevelId, secondLevelId, typeValue) {
	var filters = d42OptionsAjaxCall("d42Options/filters", {
		"firstLevelId" : firstLevelId
	});
// for confluence restrict spaces
    if (filters==null) {

        AJS.$("#macro-param-div-d42SecondLevelId").hide();
        AJS.$("#macro-param-div-d42Type").hide();
        AJS.$("#macro-param-div-d42SecondLevelId").before("<div class=\"aui-message error\">\n" +
            "    <p class=\"title\">\n" +
            "        <span class=\"aui-icon icon-error\"></span>\n" +
            "        <strong>Access denied!</strong>\n" +
            "    </p>\n" +
            "    <p>You don't have access to this space. Please, ask your system administrator.</p>\n" +
            "</div>");

		return;

    }
//----------------------------------
	var filterInput = AJS.$("#macro-param-d42SecondLevelId")
	var typesInput = AJS.$("#macro-param-d42Type");
	filterInput.hide();
	typesInput.hide();
	
	var selectFilter = AJS.$(
			"<select>",
			{
				"class" : "d42-filter-select trigger-select2 js-select2-picker",
				name : "filter" + soy.$$escapeHtml(firstLevelId),
				id : "filter_" + soy.$$escapeHtml(firstLevelId),
				"first-id" : soy.$$escapeHtml(firstLevelId)
			});
	var selectType = AJS.$(
			"<select>",
			{
				"class" : "d42-type-select trigger-select2 js-select2-picker",
				name : "type_" + soy.$$escapeHtml(firstLevelId),
				id : "type_" + soy.$$escapeHtml(firstLevelId),
				"first-id" : soy.$$escapeHtml(firstLevelId)
			});
	d42FillSelect(filters, selectFilter, false);
	filterInput.after(selectFilter);
	typesInput.after(selectType);
	selectFilter.select2();
	selectType.select2();
	var selectOptions = selectFilter.find("option[value='" + soy.$$escapeHtml(secondLevelId) + "']");
	if (selectOptions.length > 0) {
		selectOptions.prop('selected', true);
	} else
		selectFilter.find("option:first").prop('selected', true);
	selectFilter.change();
	if(typeValue) {
		selectOptions = selectType.find("option[value='" + soy.$$escapeHtml(typeValue) + "']");
		selectOptions.prop('selected', true);
		selectOptions.change();
	}
}

function d42RenderTableMacro() {
	var d42TypeObject = AJS.$("#macro-param-d42Type");
	if (d42TypeObject && d42TypeObject.is(":visible")) {
		d42HideTableLegacy(d42TypeObject);
		var d42SecondLevelIdObject = AJS.$("#macro-param-d42SecondLevelId");
		var spaceId = getSpaceId();
		var typeValue;
		if (!d42TypeObject.val()) {
			typeValue = d42LoadTableLegacy(d42TypeObject);
		} else {
			typeValue = d42TypeObject.val();
		}
		var secondLevelId = "0";
		if (d42SecondLevelIdObject.val())
			secondLevelId = d42SecondLevelIdObject.val();
		d42RenderTableEdit(spaceId, secondLevelId, typeValue);
	}
}

function d42RenderMacro() {
	d42RenderSimpleMacro();
	d42RenderTableMacro();
}

AJS.$(document).ready(function(event) {

	AJS.$("select.d42-data-field-type-select").live("change", function(event) {
		var firstLevelId = AJS.$(this).attr("first-id");
		var secondLevelId = AJS.$(this).attr("second-id");
		d42ResetDataSelection(firstLevelId, secondLevelId);
        d42ApplySelect2(firstLevelId,secondLevelId);
	});

	AJS.$("input.d42-data-field-select").live(
			"change",
			function(event) {
				d42StoreData(AJS.$(this).attr("first-id"), AJS.$(this)
						.attr("second-id"), "#macro-param-d42Value");
			});

	AJS.$("select.d42-filter-select").live("change", function(event) {
		var firstLevelId = AJS.$(this).attr("first-id");
		var secondLevelId = AJS.$(this).find(":selected").attr("value");
		AJS.$("#macro-param-d42SecondLevelId").val(secondLevelId);
		d42RefillTableTypes(firstLevelId, secondLevelId);
	});
	AJS.$("select.d42-type-select").live("change", function(event) {
		AJS.$("#macro-param-d42Type").val(AJS.$(this).find(":selected").attr("value"));
	});

});
AJS.$(document).on("DOMNodeInserted", d42RenderMacro);