/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.service;

import com.device42.atlas.common.model.serialization.JsonParameters;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RestItem {
    @XmlElement
    private long id;
    @XmlElement
    private String key;
    @XmlElement
    private String name;
    @XmlElement
    private Map<String, String> parameters;

    public RestItem() {
    }

    public RestItem(long id, String name) {
        this(id, null, name);
    }

    public RestItem(String key, String name) {
        this(0L, key, name);
    }

    public RestItem(long id, String key, String name) {
        this.id = id;
        this.name = name;
        this.key = key;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String toString() {
        return "RestItem [id=" + this.id + ", name=" + this.name + "]";
    }

    public void addParameter(String key, Object value) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (value != null) {
            this.parameters.put(key, value.toString());
        } else {
            this.removeParameter(key);
        }
    }

    public void removeParameter(String key) {
        if (this.parameters != null) {
            this.parameters.remove(key);
        }
    }

    public String getParameter(String key) {
        if (this.parameters != null) {
            return this.parameters.get(key);
        }
        return null;
    }

    public JsonObject toJson() {
        JsonParameters jsonParameters = new JsonParameters();
        jsonParameters.addParameter("id", this.id);
        jsonParameters.addParameter("name", this.name);
        jsonParameters.addParameter("key", this.key);
        jsonParameters.addParameter("parameters", this.parameters);
        return jsonParameters.getJsonObject();
    }
}

