/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.serialization;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.util.CryptUtils;
import com.device42.atlas.common.util.ObjectUtils;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;

public class PluginSettingsDonor
implements ParameterDonor {
    Logger.Log log = Logger.getInstance(PluginSettingsDonor.class);
    private final PluginSettings pluginSettings;
    private Set<String> cryptedKeys = new HashSet<String>();

    public PluginSettingsDonor(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    @Override
    public Object get(String key) {
        if (this.pluginSettings != null) {
            if (this.cryptedKeys.contains(key)) {
                String value = ObjectUtils.stringValue(this.pluginSettings.get(key));
                if (value != null) {
                    try {
                        return CryptUtils.defaultDecrypt(value);
                    }
                    catch (GeneralSecurityException e) {
                        this.log.error((Object)("Could not decrypt the " + key + ". Returning empty one"), (Throwable)e);
                        return null;
                    }
                }
            } else {
                return this.pluginSettings.get(key);
            }
        }
        return null;
    }

    @Override
    public boolean contains(String key) {
        if (this.pluginSettings != null) {
            return this.pluginSettings.get(key) != null;
        }
        return false;
    }

    @Override
    public Set<String> keys() {
        throw new UnsupportedOperationException();
    }

    public void addCryptedKey(String key) {
        this.cryptedKeys.add(key);
    }

    @Override
    public ParameterDonor extractNestedObject(String key) {
        return this;
    }
}

