/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core.schema;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class Schema
implements Iterable<ConfigurationItemType>,
Parameterizable {
    public static final String CONFIGURATION_ITEM_TYPES_TOKEN = "configurationItemTypes";
    public static final String ORDERED_CONFIGURATION_ITEM_TYPES_KEYS_TOKEN = "orderedConfigurationItemTypeKeys";
    private static final Logger.Log log = Logger.getInstance(Schema.class);
    private List<ConfigurationItemType> configurationItemTypes = new ArrayList<ConfigurationItemType>();
    private Map<String, ConfigurationItemType> keyConfigurationItemTypes = new LinkedHashMap<String, ConfigurationItemType>();
    private Map<String, ConfigurationItemType> nameConfigurationItemTypes = new LinkedHashMap<String, ConfigurationItemType>();
    List<String> failedKeys = new ArrayList<String>();

    public Schema(@Nonnull List<ConfigurationItemType> configurationItemTypes) {
        log.debug((Object)"Creating configuration item type schema from list");
        for (ConfigurationItemType configurationItemType : configurationItemTypes) {
            this.addConfigurationItemType(configurationItemType);
        }
    }

    public Schema(@Nonnull ParameterDonor input) {
        this.loadFromDonor(input);
    }

    private void addConfigurationItemType(ConfigurationItemType configurationItemType) {
        this.keyConfigurationItemTypes.put(configurationItemType.getKey(), configurationItemType);
        this.nameConfigurationItemTypes.put(configurationItemType.getName(), configurationItemType);
        this.configurationItemTypes.add(configurationItemType);
        log.debug((Object)("CI key: " + configurationItemType.getKey()));
        log.debug((Object)("CI name: " + configurationItemType.getName()));
    }

    @Override
    public Iterator<ConfigurationItemType> iterator() {
        return this.configurationItemTypes.iterator();
    }

    public ConfigurationItemType getByKey(String key) {
        return this.keyConfigurationItemTypes.get(key);
    }

    public ConfigurationItemType getByName(String name) {
        return this.nameConfigurationItemTypes.get(name);
    }

    public List<ConfigurationItemType> getSortedConfigurationItemTypes() {
        ArrayList<ConfigurationItemType> sortedList = new ArrayList<ConfigurationItemType>(this.configurationItemTypes);
        Collections.sort(sortedList, new Comparator<ConfigurationItemType>(){

            @Override
            public int compare(ConfigurationItemType type1, ConfigurationItemType type2) {
                if (type1 == null) {
                    return 1;
                }
                if (type2 == null) {
                    return 2;
                }
                return Integer.compare(type1.getCollectionWeight(), type2.getCollectionWeight());
            }
        });
        return sortedList;
    }

    @Override
    public void saveToAcceptor(ParameterAcceptor output) {
        ParameterAcceptor configurationItemTypesAcceptor = output.generateChildAcceptorObject(CONFIGURATION_ITEM_TYPES_TOKEN);
        ArrayList<String> orderedKeys = new ArrayList<String>();
        for (ConfigurationItemType configurationItemType : this.getSortedConfigurationItemTypes()) {
            ParameterAcceptor configurationItemTypeAcceptor = configurationItemTypesAcceptor.generateChildAcceptorObject(configurationItemType.getKey());
            configurationItemType.saveToAcceptor(configurationItemTypeAcceptor);
            orderedKeys.add(configurationItemType.getKey());
        }
        output.addParameter(ORDERED_CONFIGURATION_ITEM_TYPES_KEYS_TOKEN, orderedKeys);
    }

    private void clear() {
        this.configurationItemTypes.clear();
        this.keyConfigurationItemTypes.clear();
        this.nameConfigurationItemTypes.clear();
        this.failedKeys.clear();
    }

    public boolean isEmpty() {
        return this.configurationItemTypes.isEmpty();
    }

    @Override
    public void loadFromDonor(ParameterDonor input) {
        this.clear();
        ParameterDonor configurationItemTypesDonor = input.extractNestedObject(CONFIGURATION_ITEM_TYPES_TOKEN);
        if (configurationItemTypesDonor != null) {
            for (String configurationItemTypeKey : configurationItemTypesDonor.keys()) {
                ParameterDonor configurationItemTypeDonor = configurationItemTypesDonor.extractNestedObject(configurationItemTypeKey);
                if (configurationItemTypeDonor != null) {
                    ConfigurationItemType configurationItemType = new ConfigurationItemType(configurationItemTypeDonor);
                    this.addConfigurationItemType(configurationItemType);
                    continue;
                }
                this.failedKeys.add(configurationItemTypeKey);
            }
        }
    }

    public void validate(I18nResolver i18n, ErrorHolder errorHolder) {
        if (this.configurationItemTypes.size() <= 0) {
            errorHolder.addError(CONFIGURATION_ITEM_TYPES_TOKEN, i18n.getText("com.device42.atlas.page.configuration.schema.emtpy.error"));
        } else {
            ErrorHolder configurationItemTypesErrorHolder = errorHolder.getNestedErrorHolder(CONFIGURATION_ITEM_TYPES_TOKEN);
            if (this.failedKeys.size() > 0) {
                configurationItemTypesErrorHolder.addErrorMessage(i18n.getText("com.device42.atlas.page.configuration.schema.extract.error", new Serializable[]{ObjectUtils.stringJoin(", ", this.failedKeys)}));
            }
            for (ConfigurationItemType configurationItemType : this.configurationItemTypes) {
                ErrorHolder configurationItemTypeErrorHolder = configurationItemTypesErrorHolder.getNestedErrorHolder(configurationItemType.getKey());
                configurationItemType.validate(i18n, configurationItemTypeErrorHolder, null);
            }
        }
    }

    @Override
    public void clear(ParameterAcceptor output) {
        output.removeParameter(CONFIGURATION_ITEM_TYPES_TOKEN);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{configurationItemTypes=[");
        boolean firstItem = true;
        for (ConfigurationItemType configurationItemType : this.configurationItemTypes) {
            if (firstItem) {
                firstItem = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(configurationItemType);
        }
        stringBuilder.append("], failedKeys=[").append(ObjectUtils.stringJoin(", ", this.failedKeys)).append("]}");
        return stringBuilder.toString();
    }
}

