/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core.schema;

import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.util.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class MultiReferenceParameterType
extends ParameterType {
    public String TOKEN_CONFIGURATION_ITEM_KEY = "configurationItemKey";
    public String TOKEN_IDS_INDEX = "idsIndex";
    private String configurationItemKey;
    private int idsIndex;
    private String idsIndexRaw;

    public MultiReferenceParameterType() {
        super(ParameterType.ParameterValueType.MULTIREFERENCE);
    }

    @Override
    protected void addAdditionalParameters(ParameterAcceptor output) {
        output.addParameter(this.TOKEN_CONFIGURATION_ITEM_KEY, this.configurationItemKey);
        output.addParameter(this.TOKEN_IDS_INDEX, this.idsIndex);
    }

    @Override
    protected void extractAdditionalParameters(ParameterDonor input) {
        this.configurationItemKey = ObjectUtils.stringValue(input.get(this.TOKEN_CONFIGURATION_ITEM_KEY));
        this.idsIndex = ObjectUtils.intValue(input.get(this.TOKEN_IDS_INDEX));
        this.idsIndexRaw = ObjectUtils.stringValue(input.get(this.TOKEN_IDS_INDEX));
    }

    @Override
    protected void cleanAdditionalParameters(ParameterAcceptor output) {
        output.removeParameter(this.TOKEN_CONFIGURATION_ITEM_KEY);
        output.removeParameter(this.TOKEN_IDS_INDEX);
    }

    @Override
    public void validateAdditionalData(I18nResolver i18n, ErrorHolder errorHolder) {
        if (StringUtils.isBlank((String)this.configurationItemKey)) {
            errorHolder.addError(this.TOKEN_CONFIGURATION_ITEM_KEY, i18n.getText("com.device42.atlas.page.configuration.parameter.references.confitemkey.error.blank"));
        } else if (this.idsIndex < 0) {
            errorHolder.addError(this.TOKEN_IDS_INDEX, i18n.getText("com.device42.atlas.page.configuration.parameter.simple.collectionindex.error.negative"));
        } else if (StringUtils.isBlank((String)this.idsIndexRaw)) {
            errorHolder.addError(this.TOKEN_IDS_INDEX, i18n.getText("com.device42.atlas.page.configuration.parameter.multireference.remoteindex.error.blank"));
        }
    }

    public String getConfigurationItemKey() {
        return this.configurationItemKey;
    }

    public void setConfigurationItemKey(String configurationItemKey) {
        this.configurationItemKey = configurationItemKey;
    }

    public int getIdsIndex() {
        return this.idsIndex;
    }
}

