/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core;

import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.model.core.Parameter;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.ObjectUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ParameterFilter
implements Parameterizable {
    private static final char PARSE_TOKEN_AND = ',';
    private static final char PARSE_TOKEN_AND_ALTERNATIVE = '&';
    private static final char PARSE_TOKEN_OR = '|';
    private static final char PARSE_TOKEN_PAR_START = '(';
    private static final char PARSE_TOKEN_PAR_STOP = ')';
    public static final String TOKEN_TYPE = "type";
    public static final String TOKEN_SWITCHED_ON = "switchedOn";
    public static final String TOKEN_FILTER_VALUE = "filterValue";
    public static final String CLAUSE = "clause";
    private static final Logger.Log log = Logger.getInstance(ParameterFilter.class);
    private int parameterFilterId;
    private ParameterType type;
    private boolean switchedOn;
    private String filterValue;

    public ParameterFilter(ParameterType type) {
        this(type, type.isDefaultFilterViewEnabled(), null);
    }

    public ParameterFilter(ParameterType type, boolean switchedOn, String filterValue) {
        this.type = type;
        this.switchedOn = switchedOn;
        this.filterValue = filterValue;
    }

    private ParameterFilterExecutor parseFilterValue() {
        StringReader stringReader = new StringReader(this.filterValue);
        ParameterFilterExecutor filterExecutor = this.parseFilterValue(stringReader, new ParameterFilterExecutor(), 0);
        log.debug((Object)("Parsed filter " + filterExecutor.toString()));
        return filterExecutor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParameterFilterExecutor parseFilterValue(StringReader stringReader, ParameterFilterExecutor resultExecutor, int level) {
        StringBuilder tokenBuilder = new StringBuilder();
        try {
            block8: while (true) {
                int readResult;
                if ((readResult = stringReader.read()) == -1) {
                    String token = tokenBuilder.toString();
                    if (!StringUtils.isNotBlank((String)token)) return resultExecutor;
                    resultExecutor.addValue(token.trim());
                    return resultExecutor;
                }
                char tokenChar = (char)readResult;
                switch (tokenChar) {
                    case '&': 
                    case ',': {
                        ParameterFilterExecutor andExecutor;
                        String token = tokenBuilder.toString().trim();
                        tokenBuilder.setLength(0);
                        if (resultExecutor.getExecutorType() == ParameterFilterExecutor.ExecutorType.OR) {
                            ParameterFilterExecutor subExecutor;
                            andExecutor = null;
                            if (!token.isEmpty()) {
                                andExecutor = new ParameterFilterExecutor(token);
                                andExecutor.setExecutorType(ParameterFilterExecutor.ExecutorType.AND);
                                token = "";
                            }
                            if (andExecutor == null && (subExecutor = resultExecutor.popExecutor()) != null) {
                                andExecutor = new ParameterFilterExecutor(subExecutor, ParameterFilterExecutor.ExecutorType.AND);
                            }
                            if (andExecutor == null) {
                                andExecutor = new ParameterFilterExecutor();
                            }
                            andExecutor = this.parseFilterValue(stringReader, andExecutor, level + 1);
                            resultExecutor.addExecutor(andExecutor);
                            if (resultExecutor.isSub()) {
                                return resultExecutor;
                            }
                        }
                        if (resultExecutor.getExecutorType() == ParameterFilterExecutor.ExecutorType.SIMPLE) {
                            resultExecutor.setExecutorType(ParameterFilterExecutor.ExecutorType.AND);
                        }
                        if (token.isEmpty()) continue block8;
                        resultExecutor.addValue(token);
                        continue block8;
                    }
                    case '|': {
                        ParameterFilterExecutor andExecutor;
                        String token = tokenBuilder.toString().trim();
                        tokenBuilder.setLength(0);
                        if (resultExecutor.getExecutorType() == ParameterFilterExecutor.ExecutorType.AND) {
                            andExecutor = resultExecutor;
                            resultExecutor = new ParameterFilterExecutor(andExecutor, ParameterFilterExecutor.ExecutorType.OR);
                            resultExecutor.setSub(andExecutor.isSub());
                            andExecutor.setSub(false);
                            if (!token.isEmpty()) {
                                andExecutor.addValue(token);
                                token = "";
                            }
                        }
                        if (resultExecutor.getExecutorType() == ParameterFilterExecutor.ExecutorType.SIMPLE) {
                            resultExecutor.setExecutorType(ParameterFilterExecutor.ExecutorType.OR);
                        }
                        if (token.isEmpty()) continue block8;
                        resultExecutor.addValue(token);
                        continue block8;
                    }
                    case '(': {
                        String token = tokenBuilder.toString().trim();
                        tokenBuilder.setLength(0);
                        ParameterFilterExecutor subExecutor = new ParameterFilterExecutor();
                        if (!token.isEmpty()) {
                            resultExecutor.addValue(token);
                        }
                        subExecutor.setSub(true);
                        subExecutor = this.parseFilterValue(stringReader, subExecutor, level + 1);
                        resultExecutor.addExecutor(subExecutor);
                        continue block8;
                    }
                    case ')': {
                        String token = tokenBuilder.toString().trim();
                        tokenBuilder.setLength(0);
                        if (!token.isEmpty()) {
                            resultExecutor.addValue(token);
                        }
                        if (level <= 0) continue block8;
                        return resultExecutor;
                    }
                }
                tokenBuilder.append(tokenChar);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultExecutor;
    }

    public ParameterType getType() {
        return this.type;
    }

    public boolean isSwitchedOn() {
        return this.switchedOn;
    }

    public void setSwitchedOn(boolean switchedOn) {
        this.switchedOn = switchedOn;
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    @Override
    public void saveToAcceptor(ParameterAcceptor output) {
        ParameterAcceptor serializedType = output.generateChildAcceptorObject(TOKEN_TYPE);
        this.type.saveToAcceptor(serializedType);
        output.addParameter(TOKEN_SWITCHED_ON, this.switchedOn);
        output.addParameter(TOKEN_FILTER_VALUE, this.filterValue);
    }

    @Override
    public void loadFromDonor(ParameterDonor input) {
        this.setSwitchedOn(ObjectUtils.booleanValue(input.get(TOKEN_SWITCHED_ON), this.type.isDefaultFilterViewEnabled()));
        this.setFilterValue(ObjectUtils.stringValue(input.get(TOKEN_FILTER_VALUE)));
    }

    @Override
    public void clear(ParameterAcceptor output) {
        output.removeParameter(TOKEN_TYPE);
        output.removeParameter(TOKEN_SWITCHED_ON);
        output.removeParameter(TOKEN_FILTER_VALUE);
    }

    public boolean isPrimitive() {
        return StringUtils.isBlank((String)this.filterValue);
    }

    public int getParameterFilterId() {
        return this.parameterFilterId;
    }

    public void setParameterFilterId(int parameterFilterId) {
        this.parameterFilterId = parameterFilterId;
    }

    public boolean checkParameter(Parameter parameter) {
        if (this.isPrimitive()) {
            return true;
        }
        if (parameter == null) {
            return false;
        }
        ParameterFilterExecutor filterExecutor = this.parseFilterValue();
        return filterExecutor.execute(parameter);
    }

    public List<String> getCondition() {
        ParameterFilterExecutor parameterFilterExecutor = this.parseFilterValue();
        ParameterFilterExecutor.ExecutorType executorType = parameterFilterExecutor.getExecutorType();
        ArrayList<String> list = new ArrayList<String>();
        switch (executorType) {
            case AND: {
                list.add("AND");
                break;
            }
            case OR: {
                list.add("OR");
                break;
            }
            default: {
                list.add("AND");
            }
        }
        ParameterFilterExecutor buf = parameterFilterExecutor.popExecutor();
        while (buf != null) {
            list.add(buf.toString());
            buf = parameterFilterExecutor.popExecutor();
        }
        if (list.size() == 1) {
            return new ArrayList<String>();
        }
        return list;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{type=").append(this.type.getKey()).append(", switchedOn=").append(this.switchedOn).append(", filterValue=").append(this.filterValue);
        result.append("}");
        return result.toString();
    }

    private static class ParameterFilterExecutor {
        private ExecutorType executorType = ExecutorType.SIMPLE;
        private List<ParameterFilterExecutor> executorFilters = null;
        private String value = null;
        private boolean sub = false;

        public ParameterFilterExecutor() {
        }

        public ParameterFilterExecutor(String value) {
            this.value = value;
        }

        public ParameterFilterExecutor(ParameterFilterExecutor child, ExecutorType executorType) {
            this.executorFilters = new ArrayList<ParameterFilterExecutor>();
            this.executorFilters.add(child);
            this.setExecutorType(executorType);
        }

        private void recomplexExecutor() {
            if (this.executorFilters == null) {
                this.executorFilters = new ArrayList<ParameterFilterExecutor>();
                if (this.value != null) {
                    this.executorFilters.add(new ParameterFilterExecutor(this.value));
                }
            }
        }

        public void setExecutorType(ExecutorType executorType) throws IllegalStateException {
            if (this.executorType != ExecutorType.SIMPLE && executorType == ExecutorType.SIMPLE) {
                throw new IllegalStateException("Cannot simplify filter executor");
            }
            if (this.executorType == ExecutorType.SIMPLE && executorType != ExecutorType.SIMPLE) {
                this.recomplexExecutor();
            }
            this.executorType = executorType;
        }

        public ExecutorType getExecutorType() {
            return this.executorType;
        }

        public void addValue(String value) {
            if (this.value == null && this.executorType == ExecutorType.SIMPLE) {
                this.value = value;
            } else {
                this.recomplexExecutor();
                this.executorFilters.add(new ParameterFilterExecutor(value));
                if (this.executorType == ExecutorType.SIMPLE) {
                    this.executorType = ExecutorType.AND;
                }
            }
        }

        public void addExecutor(ParameterFilterExecutor childExecutor) {
            this.recomplexExecutor();
            this.executorFilters.add(childExecutor);
            if (this.executorType == ExecutorType.SIMPLE) {
                this.executorType = ExecutorType.AND;
            }
        }

        public ParameterFilterExecutor popExecutor() {
            if (this.executorType != ExecutorType.SIMPLE && this.executorFilters != null && !this.executorFilters.isEmpty()) {
                return this.executorFilters.remove(this.executorFilters.size() - 1);
            }
            return null;
        }

        public boolean execute(Parameter parameter) {
            switch (this.executorType) {
                case AND: {
                    for (ParameterFilterExecutor childExecutor : this.executorFilters) {
                        if (childExecutor.execute(parameter)) continue;
                        return false;
                    }
                    return true;
                }
                case OR: {
                    for (ParameterFilterExecutor childExecutor : this.executorFilters) {
                        if (!childExecutor.execute(parameter)) continue;
                        return true;
                    }
                    return false;
                }
            }
            return parameter.checkParameterFilterValue(this.value);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            String separator = "";
            switch (this.executorType) {
                case AND: 
                case OR: {
                    separator = this.executorType == ExecutorType.AND ? " AND " : " OR ";
                    result.append("(");
                    ArrayList<String> subResults = new ArrayList<String>();
                    for (ParameterFilterExecutor subExecutor : this.executorFilters) {
                        subResults.add(subExecutor.toString());
                    }
                    result.append(ObjectUtils.stringJoin(separator, subResults));
                    result.append(")");
                    return result.toString();
                }
            }
            return this.value;
        }

        public boolean isSub() {
            return this.sub;
        }

        public void setSub(boolean sub) {
            this.sub = sub;
        }

        private static enum ExecutorType {
            AND,
            OR,
            SIMPLE;

        }
    }
}

