/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core;

import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.model.core.ConfigurationItemFilter;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class Filter
implements Iterable<ConfigurationItemFilter>,
Parameterizable {
    private static Logger.Log log = Logger.getInstance(Filter.class);
    public static final String DEVICE42_FIRST_LEVEL_ID = "firstLevelId";
    public static final String DEVICE42_SECOND_LEVEL_ID = "secondLevelId";
    public static final String DEVICE42_NAME = "name";
    public static final String DEVICE42_DEFAULT_NAME = "default";
    public static final String DEVICE42_CI_FILTERS = "ciFilters";
    private int filterId = 0;
    private String name;
    private long firstLevelId = 0L;
    private long secondLevelId = 0L;
    private Map<String, ConfigurationItemFilter> ciFilters = new LinkedHashMap<String, ConfigurationItemFilter>();
    private final D42DataManager dataManager;

    public static Filter createDefaultFilter(D42DataManager dataManager) {
        Filter filter = new Filter(dataManager, 0L, 0L, null);
        filter.fillDefaults();
        return filter;
    }

    public Filter(D42DataManager dataManager, long firstLevelId, long secondLevelId) {
        this(dataManager, firstLevelId, secondLevelId, DEVICE42_DEFAULT_NAME);
    }

    public Filter(D42DataManager dataManager, long firstLevelId, long secondLevelId, String name) {
        this.dataManager = dataManager;
        this.firstLevelId = firstLevelId;
        this.secondLevelId = secondLevelId;
        this.setName(name);
    }

    public Filter(D42DataManager dataManager, ParameterDonor parameters) {
        this.dataManager = dataManager;
        if (parameters != null) {
            this.loadFromDonor(parameters);
        }
    }

    public long getFirstLevelId() {
        return this.firstLevelId;
    }

    public void setFirstLevelId(long firstLevelId) {
        this.firstLevelId = firstLevelId;
    }

    public long getSecondLevelId() {
        return this.secondLevelId;
    }

    public void setSecondLevelId(long secondLevelId) {
        this.secondLevelId = secondLevelId;
    }

    public ConfigurationItemFilter getConfigurationItemFilter(@Nonnull ConfigurationItemType configurationItemType) {
        return this.ciFilters.get(configurationItemType.getKey());
    }

    public void setConfigurationItemFilter(@Nonnull ConfigurationItemFilter configurationItemFilter) {
        if (configurationItemFilter != null) {
            this.ciFilters.put(configurationItemFilter.getType().getKey(), configurationItemFilter);
        }
    }

    private List<ConfigurationItemFilter> getSortedConfigurationItemFilters() {
        ArrayList<ConfigurationItemFilter> sortedList = new ArrayList<ConfigurationItemFilter>(this.ciFilters.values());
        Collections.sort(sortedList, new Comparator<ConfigurationItemFilter>(){

            @Override
            public int compare(ConfigurationItemFilter type1, ConfigurationItemFilter type2) {
                if (type1 == null || type1.getType() == null) {
                    return 1;
                }
                if (type2 == null || type2.getType() == null) {
                    return 2;
                }
                return Integer.compare(type1.getType().getCollectionWeight(), type2.getType().getCollectionWeight());
            }
        });
        return sortedList;
    }

    @Override
    public Iterator<ConfigurationItemFilter> iterator() {
        return this.getSortedConfigurationItemFilters().iterator();
    }

    @Override
    public void saveToAcceptor(ParameterAcceptor output) {
        output.addParameter(DEVICE42_FIRST_LEVEL_ID, this.getFirstLevelId());
        output.addParameter(DEVICE42_SECOND_LEVEL_ID, this.getSecondLevelId());
        output.addParameter(DEVICE42_NAME, this.getName());
        ParameterAcceptor serializedFilters = output.generateChildAcceptorObject(DEVICE42_CI_FILTERS);
        for (ConfigurationItemFilter ciFilter : this) {
            ParameterAcceptor serializedFilter = serializedFilters.generateChildAcceptorObject(ciFilter.getType().getKey());
            ciFilter.saveToAcceptor(serializedFilter);
            log.debug((Object)("ciFilter: " + ciFilter));
        }
    }

    @Override
    public void loadFromDonor(ParameterDonor input) {
        this.setFirstLevelId(ObjectUtils.longValue(input.get(DEVICE42_FIRST_LEVEL_ID)));
        this.setFirstLevelId(ObjectUtils.longValue(input.get(DEVICE42_SECOND_LEVEL_ID)));
        this.setName(ObjectUtils.stringValue(input.get(DEVICE42_NAME)));
        ParameterDonor ciFiltersDonor = input.extractNestedObject(DEVICE42_CI_FILTERS);
        if (ciFiltersDonor != null) {
            for (String key : ciFiltersDonor.keys()) {
                ConfigurationItemType ciType = this.dataManager.getConfigurationItemTypeByKey(key);
                ParameterDonor ciFilterDonor = ciFiltersDonor.extractNestedObject(key);
                ConfigurationItemFilter ciFilter = new ConfigurationItemFilter(ciType);
                ciFilter.loadFromDonor(ciFilterDonor);
                this.ciFilters.put(ciType.getKey(), ciFilter);
            }
        } else {
            this.fillDefaults();
        }
    }

    @Override
    public void clear(ParameterAcceptor output) {
        output.removeParameter(DEVICE42_FIRST_LEVEL_ID);
        output.removeParameter(DEVICE42_SECOND_LEVEL_ID);
        output.removeParameter(DEVICE42_CI_FILTERS);
        output.removeParameter(DEVICE42_NAME);
    }

    public boolean isFilterValid() {
        for (ConfigurationItemFilter ciFilter : this) {
            if (!ciFilter.isSwitchedOn()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimitive() {
        for (ConfigurationItemFilter ciFilter : this) {
            if (ciFilter.isPrimitive()) continue;
            return false;
        }
        return true;
    }

    public int getFilterId() {
        return this.filterId;
    }

    public void setFilterId(int filterId) {
        this.filterId = filterId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.isNotBlank((String)name) ? name : DEVICE42_DEFAULT_NAME;
    }

    public void fillDefaults() {
        for (ConfigurationItemType configurationItemType : this.dataManager.getCollectableSchema()) {
            if (!configurationItemType.isFilterVisible()) continue;
            if (this.ciFilters.containsKey(configurationItemType.getKey())) {
                this.ciFilters.get(configurationItemType.getKey()).fillDefaults();
                continue;
            }
            ConfigurationItemFilter configurationItemFilter = ConfigurationItemFilter.createDefaultConfigurationItemFilter(configurationItemType);
            this.setConfigurationItemFilter(configurationItemFilter);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{firstLevelId = ").append(this.firstLevelId).append(", secondLevelId = ").append(this.secondLevelId).append(", name = ").append(this.name);
        result.append(", ciFilters = {");
        if (this.ciFilters != null) {
            boolean firstValue = true;
            for (ConfigurationItemFilter ciFilter : this.ciFilters.values()) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    result.append(", ");
                }
                result.append(ciFilter.getType().getKey()).append("=").append(ciFilter);
            }
        }
        result.append("}}");
        return result.toString();
    }
}

