/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core;

import com.device42.atlas.common.model.core.ParameterFilter;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ConfigurationItemFilter
implements Iterable<ParameterFilter>,
Parameterizable {
    public static final String TYPE_TOKEN = "type";
    public static final String SWITCHED_ON_TOKEN = "switchedOn";
    public static final String PARAMETER_FILTERS_TOKEN = "parameterFilters";
    private int configurationItemFilterId;
    private ConfigurationItemType type;
    private boolean switchedOn;
    private Map<String, ParameterFilter> parameterFilters;

    public static ConfigurationItemFilter createDefaultConfigurationItemFilter(ConfigurationItemType configurationItemType) {
        ConfigurationItemFilter configurationItemFilter = new ConfigurationItemFilter(configurationItemType);
        configurationItemFilter.setSwitchedOn(configurationItemType.isDefaultFilterEnabled());
        configurationItemFilter.fillDefaults();
        return configurationItemFilter;
    }

    public ConfigurationItemFilter(@Nonnull ConfigurationItemType type) {
        this(type, type.isDefaultFilterEnabled());
    }

    public ConfigurationItemFilter(ConfigurationItemType type, boolean switchedOn) {
        this.type = type;
        this.switchedOn = switchedOn;
        this.parameterFilters = new LinkedHashMap<String, ParameterFilter>();
    }

    public ConfigurationItemType getType() {
        return this.type;
    }

    public void setType(ConfigurationItemType type) {
        this.type = type;
    }

    public boolean isSwitchedOn() {
        return this.switchedOn;
    }

    public void setSwitchedOn(boolean switchedOn) {
        this.switchedOn = switchedOn;
    }

    public ParameterFilter getParameterFilter(@Nonnull ParameterType parameterType) {
        return this.parameterFilters.get(parameterType.getKey());
    }

    public void setParameterFilter(ParameterFilter parameterFilter) {
        if (parameterFilter != null) {
            this.parameterFilters.put(parameterFilter.getType().getKey(), parameterFilter);
        }
    }

    public boolean isPrimitive() {
        for (ParameterFilter paramFilter : this.parameterFilters.values()) {
            if (paramFilter.isPrimitive()) continue;
            return false;
        }
        return true;
    }

    public List<ParameterFilter> getSortedParameterFilters() {
        ArrayList<ParameterFilter> sortedList = new ArrayList<ParameterFilter>(this.parameterFilters.values());
        Collections.sort(sortedList, new Comparator<ParameterFilter>(){

            @Override
            public int compare(ParameterFilter type1, ParameterFilter type2) {
                if (type1 == null || type1.getType() == null) {
                    return 1;
                }
                if (type2 == null || type2.getType() == null) {
                    return 2;
                }
                return Integer.compare(type1.getType().getViewWeight(), type2.getType().getViewWeight());
            }
        });
        return sortedList;
    }

    @Override
    public Iterator<ParameterFilter> iterator() {
        return this.getSortedParameterFilters().iterator();
    }

    @Override
    public void saveToAcceptor(ParameterAcceptor output) {
        ParameterAcceptor serializedType = output.generateChildAcceptorObject(TYPE_TOKEN);
        this.type.saveToAcceptor(serializedType);
        serializedType.addParameters(this.type);
        output.addParameter(SWITCHED_ON_TOKEN, this.isSwitchedOn());
        ParameterAcceptor serializedParameterFilters = output.generateChildAcceptorObject(PARAMETER_FILTERS_TOKEN);
        for (ParameterFilter parameterFilter : this) {
            ParameterAcceptor serializedParameterFilter = serializedParameterFilters.generateChildAcceptorObject(parameterFilter.getType().getKey());
            parameterFilter.saveToAcceptor(serializedParameterFilter);
        }
    }

    @Override
    public void loadFromDonor(ParameterDonor input) {
        this.switchedOn = ObjectUtils.booleanValue(input.get(SWITCHED_ON_TOKEN), this.type.isDefaultFilterEnabled());
        ParameterDonor parameterFiltersDonor = input.extractNestedObject(PARAMETER_FILTERS_TOKEN);
        if (parameterFiltersDonor != null) {
            for (String key : parameterFiltersDonor.keys()) {
                ParameterType parameterType = this.type.getParameterTypeByKey(key);
                ParameterDonor parameterFilterDonor = parameterFiltersDonor.extractNestedObject(key);
                ParameterFilter parameterFilter = new ParameterFilter(parameterType);
                parameterFilter.loadFromDonor(parameterFilterDonor);
                this.parameterFilters.put(parameterType.getKey(), parameterFilter);
            }
        } else {
            this.fillDefaults();
        }
    }

    @Override
    public void clear(ParameterAcceptor output) {
        output.removeParameter(TYPE_TOKEN);
        output.removeParameter(SWITCHED_ON_TOKEN);
        output.removeParameter(PARAMETER_FILTERS_TOKEN);
    }

    public int getConfigurationItemFilterId() {
        return this.configurationItemFilterId;
    }

    public void setConfigurationItemFilterId(int configurationItemFilterId) {
        this.configurationItemFilterId = configurationItemFilterId;
    }

    public void fillDefaults() {
        for (ParameterType parameterType : this.type.getParameterTypes()) {
            if (this.parameterFilters.containsKey(parameterType.getKey()) || !parameterType.isEnabled()) continue;
            ParameterFilter parameterFilter = new ParameterFilter(parameterType);
            parameterFilter.setSwitchedOn(parameterType.isDefaultFilterViewEnabled());
            this.setParameterFilter(parameterFilter);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{type = ").append(this.type.getKey()).append(", configurationItemFilterId = ").append(this.configurationItemFilterId).append(", switchedOn = ").append(this.switchedOn);
        result.append(", parameterFilters = {");
        if (this.parameterFilters != null) {
            boolean firstValue = true;
            for (ParameterFilter parameterFilter : this.parameterFilters.values()) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    result.append(", ");
                }
                result.append(parameterFilter.getType().getKey()).append("=").append(parameterFilter);
            }
        }
        result.append("}}");
        return result.toString();
    }
}

