/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42SupportManager;
import com.device42.atlas.common.model.ao.ConfigurationItemAO;
import com.device42.atlas.common.model.ao.ConfigurationItemFilterAO;
import com.device42.atlas.common.model.ao.ConfigurationItemTypeAO;
import com.device42.atlas.common.model.ao.D42SupportAO;
import com.device42.atlas.common.model.ao.FilterAO;
import com.device42.atlas.common.model.ao.FilteredConfigurationItemAO;
import com.device42.atlas.common.model.ao.ParameterAO;
import com.device42.atlas.common.model.ao.ParameterFilterAO;
import com.device42.atlas.common.model.ao.ParameterTypeAO;
import com.device42.atlas.common.model.core.ConfigurationItem;
import com.device42.atlas.common.model.core.ConfigurationItemFilter;
import com.device42.atlas.common.model.core.ConfigurationItemParameter;
import com.device42.atlas.common.model.core.ConfigurationItemState;
import com.device42.atlas.common.model.core.Filter;
import com.device42.atlas.common.model.core.MultiConfigurationItemParameter;
import com.device42.atlas.common.model.core.MultiParameter;
import com.device42.atlas.common.model.core.Parameter;
import com.device42.atlas.common.model.core.ParameterFilter;
import com.device42.atlas.common.model.core.SimpleParameter;
import com.device42.atlas.common.model.core.schema.ConfigurationItemDisplayName;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.MultiReferenceParameterType;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.core.schema.ReferenceParameterType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.model.serialization.MapDonor;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.D42Version;
import com.device42.atlas.common.util.JsonUtil;
import com.device42.atlas.common.util.MultiQuery;
import com.device42.atlas.common.util.PartialCIList;
import com.device42.atlas.common.util.ValuesHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class D42DataManagerImpl
implements D42DataManager {
    private final ActiveObjects ao;
    private final D42SupportManager d42SupportManager;
    private static Logger.Log log = Logger.getInstance(D42DataManagerImpl.class);

    public D42DataManagerImpl(ActiveObjects ao, D42SupportManager d42SupportManager) {
        this.ao = ao;
        this.d42SupportManager = d42SupportManager;
    }

    private Parameter convert(ParameterAO dbParameter, boolean restoreCiParameters) throws D42Exception {
        String parameterKey;
        String configurationItemTypeKey = dbParameter.getConfItem().getTypeKey();
        ParameterTypeAO dbParameterType = this.getParameterTypeAO(configurationItemTypeKey, parameterKey = dbParameter.getTypeKey(), false);
        if (dbParameterType != null) {
            ParameterType parameterType = this.convert(dbParameterType);
            if (!parameterType.isEnabled()) {
                return null;
            }
            if (parameterType instanceof ReferenceParameterType && restoreCiParameters) {
                ConfigurationItemParameter parameter = new ConfigurationItemParameter(parameterType);
                ConfigurationItemAO dbParameterConfigurationItem = dbParameter.getParameterConfItem();
                if (dbParameterConfigurationItem == null) {
                    long parameterConfigurationItemStorageId = dbParameter.getParameterConfItemStorageId();
                    String parameterConfigurationItemTypeKey = ((ReferenceParameterType)parameterType).getConfigurationItemKey();
                    ConfigurationItemType parameterConfigurationItemType = this.getConfigurationItemTypeByKey(parameterConfigurationItemTypeKey);
                    dbParameterConfigurationItem = this.findByStorageId(parameterConfigurationItemStorageId, parameterConfigurationItemType);
                    dbParameter.setParameterConfItem(dbParameterConfigurationItem);
                    dbParameter.save();
                }
                if (dbParameterConfigurationItem != null) {
                    parameter.setConfigurationItem(this.convert(dbParameterConfigurationItem, false));
                    return parameter;
                }
                return null;
            }
            if (parameterType instanceof MultiReferenceParameterType && restoreCiParameters) {
                MultiReferenceParameterType multiReferenceParameterType = (MultiReferenceParameterType)parameterType;
                MultiConfigurationItemParameter multiCIParameter = new MultiConfigurationItemParameter(multiReferenceParameterType);
                List<Integer> childrenParameterIds = ValuesHelper.getIdsListFromString(dbParameter.getValue());
                for (Integer childrenParameterId : childrenParameterIds) {
                    ConfigurationItem ci = this.getByStorageId(childrenParameterId.intValue(), this.getConfigurationItemTypeByKey(multiReferenceParameterType.getConfigurationItemKey()));
                    ReferenceParameterType referenceParameterType = new ReferenceParameterType();
                    referenceParameterType.setIdIndex(childrenParameterId);
                    referenceParameterType.setConfigurationItemKey(ci.getType().getKey());
                    ConfigurationItemParameter childrenParameter = new ConfigurationItemParameter(referenceParameterType);
                    childrenParameter.setConfigurationItem(ci);
                    childrenParameter.setValue(childrenParameterId.toString());
                    multiCIParameter.addParameter(childrenParameter);
                }
                return multiCIParameter;
            }
            SimpleParameter parameter = new SimpleParameter(parameterType);
            parameter.setValue(dbParameter.getValue());
            return parameter;
        }
        return null;
    }

    private ConfigurationItemAO getDbConfigurationItemAO(ParameterAO dbParameter, String parameterConfigurationItemTypeKey) {
        ConfigurationItemAO dbParameterConfigurationItem = dbParameter.getParameterConfItem();
        if (dbParameterConfigurationItem == null) {
            long parameterConfigurationItemStorageId = dbParameter.getParameterConfItemStorageId();
            ConfigurationItemType parameterConfigurationItemType = this.getConfigurationItemTypeByKey(parameterConfigurationItemTypeKey);
            dbParameterConfigurationItem = this.findByStorageId(parameterConfigurationItemStorageId, parameterConfigurationItemType);
            dbParameter.setParameterConfItem(dbParameterConfigurationItem);
            dbParameter.save();
        }
        return dbParameterConfigurationItem;
    }

    private ConfigurationItem convert(ConfigurationItemAO dbCi, boolean restoreCiParameters) throws D42Exception {
        ConfigurationItemType configurationItemType;
        ConfigurationItem configurationItem = null;
        if (dbCi != null && (configurationItemType = this.getConfigurationItemTypeByKey(dbCi.getTypeKey())) != null) {
            configurationItem = new ConfigurationItem(configurationItemType);
            configurationItem.setActivityState(dbCi.getActivityState());
            configurationItem.setId(dbCi.getID());
            configurationItem.setStorageId(dbCi.getStorageId());
            if (dbCi.getParameters() != null) {
                for (ParameterAO dbParameter : dbCi.getParameters()) {
                    configurationItem.addParameter(this.convert(dbParameter, restoreCiParameters));
                }
            }
        }
        return configurationItem;
    }

    @Override
    public ConfigurationItem getByStorageId(long storageId, ConfigurationItemType type) throws D42Exception {
        ConfigurationItemAO dbCi = this.findByStorageId(storageId, type);
        return this.convert(dbCi, true);
    }

    private Query getDbActiveByTypeQuery(ConfigurationItemType type, String term) {
        String queryWhere = "TYPE_KEY = ? AND ACTIVITY_STATE = ?";
        Query query = Query.select();
        if (StringUtils.isNotBlank((CharSequence)term)) {
            queryWhere = queryWhere + " AND CACHED_DISPLAY_NAME LIKE ?";
            query.where(queryWhere, new Object[]{type.getKey(), ConfigurationItemState.ACTIVE, "%" + term.toLowerCase() + "%"});
        } else {
            query.where(queryWhere, new Object[]{type.getKey(), ConfigurationItemState.ACTIVE});
        }
        return query;
    }

    private ConfigurationItemAO[] getDbActiveByType(ConfigurationItemType type, String term, int offset, int limit) {
        Query query = this.getDbActiveByTypeQuery(type, term);
        query.order("CACHED_DISPLAY_NAME ASC");
        query.limit(limit).offset(offset);
        return (ConfigurationItemAO[])this.ao.find(ConfigurationItemAO.class, query);
    }

    @Override
    public int getDbActiveByTypeCount(ConfigurationItemType type, String term) {
        Query query = this.getDbActiveByTypeQuery(type, term);
        return this.ao.count(ConfigurationItemAO.class, query);
    }

    private Query getDbActiveByFilteredTypeQuery(ConfigurationItemType type, ConfigurationItemFilter ciFilter, String term) {
        Query query = Query.select().alias(ConfigurationItemAO.class, "D42CI").alias(FilteredConfigurationItemAO.class, "D42FCI").join(FilteredConfigurationItemAO.class, this.join("D42FCI", "CONF_ITEM_ID", "D42CI", "ID"));
        String queryWhere = "TYPE_KEY = ? AND ACTIVITY_STATE = ? AND CONF_ITEM_FILTER_ID = ?";
        if (StringUtils.isNotBlank((CharSequence)term)) {
            queryWhere = queryWhere + " AND CACHED_DISPLAY_NAME LIKE ?";
            query.where(queryWhere, new Object[]{type.getKey(), ConfigurationItemState.ACTIVE, ciFilter.getConfigurationItemFilterId(), "%" + term.toLowerCase() + "%"});
        } else {
            query.where(queryWhere, new Object[]{type.getKey(), ConfigurationItemState.ACTIVE, ciFilter.getConfigurationItemFilterId()});
        }
        return query;
    }

    private int getDbActiveByFilteredTypeCount(ConfigurationItemType type, ConfigurationItemFilter ciFilter, String term) {
        Query query = this.getDbActiveByFilteredTypeQuery(type, ciFilter, term);
        return this.ao.count(ConfigurationItemAO.class, query);
    }

    private ConfigurationItemAO[] getDbActiveByFilteredType(ConfigurationItemType type, ConfigurationItemFilter ciFilter, String term, int offset, int limit) {
        Query query = this.getDbActiveByFilteredTypeQuery(type, ciFilter, term);
        query.order("CACHED_DISPLAY_NAME ASC");
        query.limit(limit);
        query.offset(offset);
        return (ConfigurationItemAO[])this.ao.find(ConfigurationItemAO.class, query);
    }

    @Override
    public PartialCIList getActiveByType(ConfigurationItemType type, ConfigurationItemFilter ciFilter, String term, int offset, int limit) throws D42Exception {
        Object[] dbCis = null;
        int total = 0;
        if (ciFilter != null && !ciFilter.isPrimitive() && ciFilter.getConfigurationItemFilterId() != 0) {
            total = this.getDbActiveByFilteredTypeCount(type, ciFilter, term);
            dbCis = this.getDbActiveByFilteredType(type, ciFilter, term, offset, limit);
        }
        if (total == 0) {
            dbCis = this.getDbActiveByType(type, term, offset, limit);
            if (ciFilter != null && !ciFilter.isPrimitive() && ciFilter.getConfigurationItemFilterId() != 0) {
                for (ParameterFilter parameterFilter : ciFilter.getSortedParameterFilters()) {
                    if (parameterFilter.getFilterValue().isEmpty() || !parameterFilter.isSwitchedOn()) continue;
                    Object[] objectArray = dbCis;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        ConfigurationItemAO dbCi = objectArray[i];
                        for (ParameterAO dbParameter : dbCi.getParameters()) {
                            if (dbParameter.getValue().isEmpty() || !parameterFilter.getType().getKey().equalsIgnoreCase(dbParameter.getTypeKey()) || dbParameter.getLowercaseValue().contains(parameterFilter.getFilterValue().toLowerCase())) continue;
                            dbCis = (ConfigurationItemAO[])ArrayUtils.removeElement((Object[])dbCis, (Object)dbCi);
                        }
                    }
                }
                total = dbCis.length;
            }
        }
        PartialCIList result = new PartialCIList();
        for (ConfigurationItemAO configurationItemAO : dbCis) {
            result.add(this.convert(configurationItemAO, true));
        }
        result.setTotal(total);
        result.setLimit(limit);
        result.setOffset(offset);
        return result;
    }

    @Override
    public PartialCIList getSearchResult(ConfigurationItemFilter searchFilter, int offset, int limit) throws D42Exception {
        PartialCIList result = new PartialCIList();
        int total = this.getCountConfigurationItemsBySearchFilter(searchFilter);
        if (searchFilter != null) {
            ConfigurationItemAO[] dbCis;
            for (ConfigurationItemAO dbCi : dbCis = this.getDbConfigurationItemsBySearchFilter(searchFilter, offset, limit)) {
                result.add(this.convert(dbCi, true));
            }
        }
        result.setTotal(total);
        result.setLimit(limit);
        result.setOffset(offset);
        return result;
    }

    @Override
    public void checkManualUpdates() throws D42Exception {
        if (this.d42SupportManager.getCurrentSupportedVersion() < D42Version.SERVICE_REWRITE_VERSION.getLong() && this.d42SupportManager.getCurrentD42Version() >= D42Version.SERVICE_REWRITE_VERSION.getLong()) {
            this.d42SupportManager.runUpdateManual("service_rewrite_manual_upgrade", this);
        }
    }

    private ConfigurationItemAO findByStorageId(long storageId, @Nonnull ConfigurationItemType type) {
        return this.findByStorageIdAndCITypeKey(storageId, type.getKey());
    }

    private ConfigurationItemAO findByStorageIdAndCITypeKey(long storageId, @Nonnull String typeKey) {
        if (storageId == 0L) {
            return null;
        }
        Query query = Query.select().where("STORAGE_ID = ? AND TYPE_KEY = ?", new Object[]{storageId, typeKey});
        return this.flattenArray((ConfigurationItemAO[])this.ao.find(ConfigurationItemAO.class, query));
    }

    private ConfigurationItemAO[] findByParameter(String value, ParameterType parameterType, ConfigurationItemType type) {
        Query query = Query.select().alias(ConfigurationItemAO.class, "D42CI").alias(ParameterAO.class, "D42PAR").join(ParameterAO.class, this.join("D42CI", "ID", "D42PAR", "CONF_ITEM_ID")).where("D42CI.TYPE_KEY = ? AND D42PAR.TYPE_KEY = ? AND VALUE = ?", new Object[]{type.getKey(), parameterType.getKey(), value});
        return (ConfigurationItemAO[])this.ao.find(ConfigurationItemAO.class, query);
    }

    @Override
    public ConfigurationItem getOneByParameter(String value, ParameterType parameterType, ConfigurationItemType configurationItemType) throws D42Exception {
        ConfigurationItemAO[] dbCis = this.findByParameter(value, parameterType, configurationItemType);
        if (dbCis != null && dbCis.length > 0) {
            return this.convert(dbCis[0], true);
        }
        return null;
    }

    private <T> T flattenArray(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[0];
    }

    private void deleteParameter(ParameterAO dbParameter) {
        if (dbParameter != null) {
            this.ao.delete(new RawEntity[]{dbParameter});
        }
    }

    private void clearParameters(ConfigurationItemAO dbCi) {
        ParameterAO[] dbParameters = dbCi.getParameters();
        if (dbParameters != null) {
            for (ParameterAO dbParameter : dbParameters) {
                this.deleteParameter(dbParameter);
            }
        }
    }

    private ParameterAO storeParameter(ConfigurationItemAO dbCi, ParameterType type, String value) {
        return (ParameterAO)this.ao.create(ParameterAO.class, new DBParam[]{new DBParam("CONF_ITEM_ID", (Object)dbCi.getID()), new DBParam("TYPE_KEY", (Object)type.getKey()), new DBParam("VALUE", (Object)value), new DBParam("LOWERCASE_VALUE", (Object)StringUtils.lowerCase((String)value))});
    }

    private void addParameter(ConfigurationItemAO dbCi, Parameter parameter) {
        log.debug((Object)("dbCI: " + dbCi));
        log.debug((Object)("parameter: " + parameter));
        if (parameter instanceof MultiParameter) {
            for (Parameter singleParameter : (MultiParameter)parameter) {
                this.addParameter(dbCi, singleParameter);
            }
            return;
        }
        if (parameter instanceof MultiConfigurationItemParameter) {
            MultiConfigurationItemParameter multiCIParameter = (MultiConfigurationItemParameter)parameter;
            List<Integer> idsList = ValuesHelper.getIdsListFromString(multiCIParameter.getValue());
            for (Integer childrenParameterId : idsList) {
                ParameterAO dbMultiParameter = this.storeParameter(dbCi, parameter.getType(), idsList.toString().replaceAll(" ", ""));
                ConfigurationItemAO storedDbCi = this.findByStorageIdAndCITypeKey(childrenParameterId.intValue(), ((MultiReferenceParameterType)multiCIParameter.getType()).getConfigurationItemKey());
                dbMultiParameter.setParameterConfItemStorageId(childrenParameterId.intValue());
                if (storedDbCi == null) continue;
                dbMultiParameter.setParameterConfItem(storedDbCi);
                dbMultiParameter.save();
            }
            return;
        }
        ParameterAO dbParameter = this.storeParameter(dbCi, parameter.getType(), parameter.getValue());
        this.saveCIParameter(parameter, dbParameter);
    }

    private void saveCIParameter(Parameter parameter, ParameterAO dbParameter) {
        ConfigurationItemParameter ciParameter;
        if (parameter instanceof ConfigurationItemParameter && (ciParameter = (ConfigurationItemParameter)parameter).getConfigurationItem() != null) {
            if (ciParameter.getConfigurationItem().getType().isCollectable()) {
                long ciStorageId = ciParameter.getConfigurationItem().getStorageId();
                ConfigurationItemAO storedDbCi = this.findByStorageId(ciStorageId, ciParameter.getConfigurationItem().getType());
                dbParameter.setParameterConfItemStorageId(ciStorageId);
                if (storedDbCi != null) {
                    dbParameter.setParameterConfItem(storedDbCi);
                }
            } else {
                ConfigurationItemAO createdDbCi = this.createOrUpdateCI(ciParameter.getConfigurationItem());
                dbParameter.setParameterConfItem(createdDbCi);
            }
            dbParameter.save();
        }
    }

    private ConfigurationItemAO createOrUpdateCI(@Nonnull ConfigurationItem configurationItem) {
        ConfigurationItemAO dbCi = null;
        if (configurationItem.getType().isCollectable() && configurationItem.getStorageId() != 0L) {
            dbCi = this.findByStorageId(configurationItem.getStorageId(), configurationItem.getType());
        }
        if (dbCi == null) {
            dbCi = (ConfigurationItemAO)this.ao.create(ConfigurationItemAO.class, new DBParam[0]);
        }
        dbCi.setActivityState(ConfigurationItemState.ACTIVE);
        dbCi.setStorageId(configurationItem.getStorageId());
        dbCi.setTypeKey(configurationItem.getType().getKey());
        if (configurationItem.getDisplayName() != null) {
            dbCi.setCachedDisplayName(configurationItem.getDisplayName().toLowerCase());
        }
        dbCi.save();
        this.clearParameters(dbCi);
        for (Parameter parameter : configurationItem) {
            this.addParameter(dbCi, parameter);
        }
        return dbCi;
    }

    @Override
    public void deactivateCIs(ConfigurationItemType type) {
        ConfigurationItemAO[] dbCis;
        Query query = Query.select().where("TYPE_KEY = ? AND ACTIVITY_STATE = ?", new Object[]{type.getKey(), ConfigurationItemState.ACTIVE});
        for (ConfigurationItemAO dbCi : dbCis = (ConfigurationItemAO[])this.ao.find(ConfigurationItemAO.class, query)) {
            dbCi.setActivityState(ConfigurationItemState.DISABLED);
            dbCi.save();
        }
    }

    @Override
    public void createOrUpdateCIs(@Nonnull List<ConfigurationItem> configurationItems, boolean deactivateCIs) {
        if (deactivateCIs && !configurationItems.isEmpty()) {
            this.deactivateCIs(configurationItems.get(0).getType());
        }
        for (ConfigurationItem configurationItem : configurationItems) {
            this.createOrUpdateCI(configurationItem);
        }
    }

    @Override
    public void deleteAoData(boolean deleteSchema) {
        this.ao.deleteWithSQL(FilteredConfigurationItemAO.class, "1=1", new Object[0]);
        this.ao.deleteWithSQL(ParameterFilterAO.class, "1=1", new Object[0]);
        this.ao.deleteWithSQL(ConfigurationItemFilterAO.class, "1=1", new Object[0]);
        this.ao.deleteWithSQL(ParameterAO.class, "1=1", new Object[0]);
        this.ao.deleteWithSQL(ConfigurationItemAO.class, "1=1", new Object[0]);
        this.ao.deleteWithSQL(FilterAO.class, "1=1", new Object[0]);
        this.ao.deleteWithSQL(D42SupportAO.class, "1=1", new Object[0]);
        if (deleteSchema) {
            this.ao.deleteWithSQL(ParameterTypeAO.class, "1=1", new Object[0]);
            this.ao.deleteWithSQL(ConfigurationItemTypeAO.class, "1=1", new Object[0]);
        }
    }

    private void clearFilterParameters(FilterAO dbFilter) {
        if (dbFilter != null && dbFilter.getConfItemFilters() != null) {
            for (ConfigurationItemFilterAO dbConfigurationItemFilter : dbFilter.getConfItemFilters()) {
                this.clearFilteredValues(dbConfigurationItemFilter.getID());
                if (dbConfigurationItemFilter == null || dbConfigurationItemFilter.getParameterFilters() == null) continue;
                this.ao.delete((RawEntity[])dbConfigurationItemFilter.getParameterFilters());
            }
            this.ao.delete((RawEntity[])dbFilter.getConfItemFilters());
        }
    }

    @Override
    public void removeFilter(long firstLevelId, long secondLevelId) {
        FilterAO dbFilter = this.getDbFilter(firstLevelId, secondLevelId);
        if (dbFilter != null) {
            this.clearFilterParameters(dbFilter);
            this.ao.delete(new RawEntity[]{dbFilter});
        }
    }

    @Override
    public void setFilter(Filter filter, int limit) throws D42Exception {
        FilterAO dbFilter = this.getDbFilter(filter.getFirstLevelId(), filter.getSecondLevelId());
        this.clearFilterParameters(dbFilter);
        if (dbFilter == null) {
            dbFilter = (FilterAO)this.ao.create(FilterAO.class, new DBParam[]{new DBParam("FIRST_LEVEL_ID", (Object)filter.getFirstLevelId()), new DBParam("SECOND_LEVEL_ID", (Object)filter.getSecondLevelId()), new DBParam("NAME", (Object)filter.getName())});
        }
        for (ConfigurationItemFilter configurationItemFilter : filter) {
            ConfigurationItemFilterAO dbConfigurationItemFilterAO = (ConfigurationItemFilterAO)this.ao.create(ConfigurationItemFilterAO.class, new DBParam[]{new DBParam("TYPE_KEY", (Object)configurationItemFilter.getType().getKey()), new DBParam("SWITCHED_ON", (Object)configurationItemFilter.isSwitchedOn()), new DBParam("FILTER_ID", (Object)dbFilter)});
            for (ParameterFilter parameterFilter : configurationItemFilter) {
                ParameterFilterAO dbParameterFilter = (ParameterFilterAO)this.ao.create(ParameterFilterAO.class, new DBParam[]{new DBParam("TYPE_KEY", (Object)parameterFilter.getType().getKey()), new DBParam("SWITCHED_ON", (Object)parameterFilter.isSwitchedOn()), new DBParam("VALUE", (Object)parameterFilter.getFilterValue()), new DBParam("CONF_ITEM_FILTER_ID", (Object)dbConfigurationItemFilterAO)});
                parameterFilter.setParameterFilterId(dbParameterFilter.getID());
            }
            configurationItemFilter.setConfigurationItemFilterId(dbConfigurationItemFilterAO.getID());
        }
        filter.setFilterId(dbFilter.getID());
        this.applyFilter(filter, limit);
    }

    private ParameterFilter convert(@Nonnull ParameterFilterAO dbParameterFilter) throws D42Exception {
        ParameterType parameterType;
        String typeKey;
        if (dbParameterFilter.getConfItemFilter() == null) {
            return null;
        }
        String configurationItemTypeKey = dbParameterFilter.getConfItemFilter().getTypeKey();
        ParameterTypeAO dbParameterType = this.getParameterTypeAO(configurationItemTypeKey, typeKey = dbParameterFilter.getTypeKey(), false);
        if (dbParameterType != null && (parameterType = this.convert(dbParameterType)) != null) {
            ParameterFilter parameterFilter = new ParameterFilter(parameterType);
            parameterFilter.setSwitchedOn(dbParameterFilter.isSwitchedOn());
            parameterFilter.setFilterValue(dbParameterFilter.getValue());
            parameterFilter.setParameterFilterId(dbParameterFilter.getID());
            return parameterFilter;
        }
        return null;
    }

    private ConfigurationItemFilter convert(@Nonnull ConfigurationItemFilterAO dbConfigurationItemFilter) throws D42Exception {
        ConfigurationItemType configurationItemType = this.getConfigurationItemTypeByKey(dbConfigurationItemFilter.getTypeKey());
        ConfigurationItemFilter configurationItemFilter = null;
        if (configurationItemType != null) {
            configurationItemFilter = new ConfigurationItemFilter(configurationItemType);
            configurationItemFilter.setSwitchedOn(dbConfigurationItemFilter.isSwitchedOn());
            for (ParameterFilterAO dbParameterFilter : dbConfigurationItemFilter.getParameterFilters()) {
                ParameterFilter parameterFilter = this.convert(dbParameterFilter);
                if (parameterFilter == null) continue;
                configurationItemFilter.setParameterFilter(parameterFilter);
            }
            configurationItemFilter.setConfigurationItemFilterId(dbConfigurationItemFilter.getID());
        }
        return configurationItemFilter;
    }

    private Filter convert(FilterAO dbFilter, boolean addCIFilters) throws D42Exception {
        if (dbFilter == null) {
            return Filter.createDefaultFilter(this);
        }
        Filter filter = new Filter(this, dbFilter.getFirstLevelId(), dbFilter.getSecondLevelId(), dbFilter.getName());
        if (addCIFilters) {
            for (ConfigurationItemFilterAO dbConfigurationItemFilter : dbFilter.getConfItemFilters()) {
                ConfigurationItemFilter ciFilter = this.convert(dbConfigurationItemFilter);
                if (ciFilter == null) continue;
                filter.setConfigurationItemFilter(ciFilter);
            }
        }
        filter.setFilterId(dbFilter.getID());
        if (addCIFilters) {
            filter.fillDefaults();
        }
        return filter;
    }

    private FilterAO[] getDbFilters(long firstLevelId) {
        return (FilterAO[])this.ao.find(FilterAO.class, Query.select().where("FIRST_LEVEL_ID = ?", new Object[]{firstLevelId}).order("SECOND_LEVEL_ID ASC"));
    }

    private FilterAO getDbFilter(long firstLevelId, long secondLevelId) {
        FilterAO[] dbFilter = (FilterAO[])this.ao.find(FilterAO.class, Query.select().where("FIRST_LEVEL_ID = ? AND SECOND_LEVEL_ID = ?", new Object[]{firstLevelId, secondLevelId}));
        return this.flattenArray(dbFilter);
    }

    @Override
    public List<Filter> getNonPrimitiveFilters() throws D42Exception {
        FilterAO[] dbFilters = (FilterAO[])this.ao.find(FilterAO.class);
        ArrayList<Filter> result = new ArrayList<Filter>();
        if (dbFilters != null) {
            for (FilterAO dbFilter : dbFilters) {
                Filter filter = this.convert(dbFilter, true);
                if (filter == null || filter.isPrimitive()) continue;
                result.add(filter);
            }
        }
        return result;
    }

    @Override
    public Filter getFilter(long firstLevelId, long secondLevelId) throws D42Exception {
        FilterAO dbFilter = this.getDbFilter(firstLevelId, secondLevelId);
        if (dbFilter == null && firstLevelId != 0L) {
            dbFilter = this.getDbFilter(0L, 0L);
        }
        Filter filter = this.convert(dbFilter, true);
        return filter;
    }

    private void clearFilteredValues(int configurationItemFilterId) {
        this.ao.deleteWithSQL(FilteredConfigurationItemAO.class, "CONF_ITEM_FILTER_ID = ?", new Object[]{configurationItemFilterId});
    }

    private void clearFilteredValues(ConfigurationItemFilter ciFilter) {
        this.clearFilteredValues(ciFilter.getConfigurationItemFilterId());
    }

    private FilteredConfigurationItemAO addFilteredValue(ConfigurationItem configurationItem, ConfigurationItemFilter ciFilter) {
        return (FilteredConfigurationItemAO)this.ao.create(FilteredConfigurationItemAO.class, new DBParam[]{new DBParam("CONF_ITEM_ID", (Object)configurationItem.getId()), new DBParam("CONF_ITEM_FILTER_ID", (Object)ciFilter.getConfigurationItemFilterId())});
    }

    private void addFilteredValues(PartialCIList configurationItems, ConfigurationItemFilter ciFilter) {
        for (ConfigurationItem configurationItem : configurationItems) {
            if (!configurationItem.checkConfigurationItemFilter(ciFilter)) continue;
            this.addFilteredValue(configurationItem, ciFilter);
        }
    }

    private void applyFilter(ConfigurationItemFilter ciFilter, int limit) throws D42Exception {
        if (ciFilter.isPrimitive()) {
            return;
        }
        if (ciFilter.getConfigurationItemFilterId() == 0) {
            throw new D42Exception("Filter was not saved before the application");
        }
        this.clearFilteredValues(ciFilter);
        if (ciFilter.isPrimitive()) {
            return;
        }
        PartialCIList configurationItems = this.getActiveByType(ciFilter.getType(), ciFilter, null, 0, limit);
        this.addFilteredValues(configurationItems, ciFilter);
        int total = configurationItems.getTotal();
        for (int currentOffset = limit; total > currentOffset; currentOffset += limit) {
            configurationItems = this.getActiveByType(ciFilter.getType(), ciFilter, null, currentOffset, limit);
            this.addFilteredValues(configurationItems, ciFilter);
        }
    }

    @Override
    public void applyFilter(Filter filter, int limit) throws D42Exception {
        if (filter.getFirstLevelId() == 0L && filter.getSecondLevelId() != 0L) {
            return;
        }
        for (ConfigurationItemFilter ciFilter : filter) {
            log.debug((Object)("Applying the CI filter. Filter id: " + filter.getFilterId() + ", CIFilter id: " + ciFilter.getConfigurationItemFilterId() + ", first level: " + filter.getFirstLevelId() + ", second level:" + filter.getSecondLevelId()));
            this.applyFilter(ciFilter, limit);
        }
    }

    @Override
    public List<Filter> getFirstLevelFilters(long firstLevelId) throws D42Exception {
        FilterAO[] dbFilters = this.getDbFilters(firstLevelId);
        ArrayList<Filter> result = new ArrayList<Filter>();
        boolean defaultFirstLevelFound = false;
        if (dbFilters != null && dbFilters.length > 0) {
            for (FilterAO dbFilter : dbFilters) {
                if (dbFilter.getSecondLevelId() == 0L) {
                    defaultFirstLevelFound = true;
                }
                result.add(this.convert(dbFilter, false));
            }
        }
        if (!defaultFirstLevelFound) {
            Filter defaultFilter = new Filter(this, firstLevelId, 0L, null);
            result.add(0, defaultFilter);
        }
        return result;
    }

    @Override
    public List<Filter> getFilterTemplates() throws D42Exception {
        return this.getFirstLevelFilters(0L);
    }

    private String join(String table1, String column1, String table2, String column2) {
        return table1 + "." + column1 + " = " + table2 + "." + column2;
    }

    private Schema gatherSchemaByQuery(Query query) {
        ConfigurationItemTypeAO[] configurationItemTypes = (ConfigurationItemTypeAO[])this.ao.find(ConfigurationItemTypeAO.class, query);
        ArrayList<ConfigurationItemType> result = new ArrayList<ConfigurationItemType>();
        if (configurationItemTypes != null) {
            for (ConfigurationItemTypeAO dbConfigurationItemType : configurationItemTypes) {
                ConfigurationItemType configurationItemType = this.convert(dbConfigurationItemType);
                result.add(configurationItemType);
            }
        }
        return new Schema(result);
    }

    @Override
    public Schema getSchema() {
        return this.gatherSchemaByQuery(Query.select());
    }

    @Override
    public Schema getCollectableSchema() {
        Query query = Query.select().where("COLLECTABLE = ?", new Object[]{true}).order("COLLECTION_WEIGHT ASC");
        return this.gatherSchemaByQuery(query);
    }

    @Override
    public ConfigurationItemType getConfigurationItemTypeByKey(String key) {
        ConfigurationItemTypeAO dbConfItemType = this.getConfigurationItemTypeAOByKey(key);
        return dbConfItemType != null ? this.convert(dbConfItemType) : null;
    }

    private ConfigurationItemTypeAO getConfigurationItemTypeAOByQuery(Query query) {
        ConfigurationItemTypeAO[] configItemTypes = (ConfigurationItemTypeAO[])this.ao.find(ConfigurationItemTypeAO.class, query);
        if (configItemTypes != null && configItemTypes.length > 0) {
            return configItemTypes[0];
        }
        return null;
    }

    private ConfigurationItemTypeAO getConfigurationItemTypeAOByKey(String key) {
        Query query = Query.select().where("KEY = ?", new Object[]{key});
        return this.getConfigurationItemTypeAOByQuery(query);
    }

    private ConfigurationItemType convert(ConfigurationItemTypeAO configurationItemTypeAO) {
        ConfigurationItemType configurationItemType = new ConfigurationItemType();
        configurationItemType.setKey(configurationItemTypeAO.getKey());
        configurationItemType.setName(configurationItemTypeAO.getName());
        configurationItemType.setPluralName(configurationItemTypeAO.getPluralName());
        configurationItemType.setLinkComponent(configurationItemTypeAO.getLinkComponent());
        configurationItemType.setDescription(configurationItemTypeAO.getDescription());
        ConfigurationItemType.DOQLQuery query = null;
        try {
            query = new ConfigurationItemType.DOQLQuery(configurationItemTypeAO.getQuery());
        }
        catch (D42Exception e) {
            log.error((Object)"Error creating DOQL", (Throwable)e);
        }
        configurationItemType.setQuery(query);
        configurationItemType.setIdIndex(configurationItemTypeAO.getIdIndex());
        configurationItemType.setLastUpdatedIndex(configurationItemTypeAO.getLastUpdatedIndex());
        configurationItemType.setCollectionWeight(configurationItemTypeAO.getCollectionWeight());
        configurationItemType.setDisplayName(new ConfigurationItemDisplayName(configurationItemTypeAO.getDisplayNameFormat()));
        configurationItemType.setFilterVisible(configurationItemTypeAO.getFilterVisible());
        configurationItemType.setCollectable(configurationItemTypeAO.getCollectable());
        configurationItemType.setDefaultFilterEnabled(configurationItemTypeAO.getDefaultFilterEnabled());
        ParameterTypeAO[] parameterTypesAO = configurationItemTypeAO.getParameterTypes();
        ArrayList<ParameterType> parameterTypes = new ArrayList<ParameterType>();
        for (ParameterTypeAO parameterType : parameterTypesAO) {
            parameterTypes.add(this.convert(parameterType));
        }
        configurationItemType.setParameterTypes(parameterTypes);
        return configurationItemType;
    }

    private ParameterType convert(ParameterTypeAO parameterTypeAO) {
        ParameterType.ParameterValueType parameterValueType = parameterTypeAO.getParameterValueType();
        ParameterType parameterType = ParameterType.createParameter(parameterValueType);
        parameterType.setKey(parameterTypeAO.getKey());
        parameterType.setName(parameterTypeAO.getName());
        parameterType.setDescription(parameterTypeAO.getDescription());
        parameterType.setViewWeight(parameterTypeAO.getViewWeight());
        parameterType.setSearchEnabled(parameterTypeAO.getSearchEnabled());
        parameterType.setDefaultFilterViewEnabled(parameterTypeAO.getDefaultFilterEnabled());
        parameterType.setAdditionalTypeData(parameterTypeAO.getAdditionalTypeData());
        parameterType.setEnabled(parameterTypeAO.getEnabled());
        return parameterType;
    }

    @Override
    public ConfigurationItemType getConfigurationItemTypeByName(String name) {
        Query query = Query.select().where("NAME = ?", new Object[]{name});
        ConfigurationItemTypeAO dbConfItemType = this.getConfigurationItemTypeAOByQuery(query);
        return dbConfItemType != null ? this.convert(dbConfItemType) : null;
    }

    ConfigurationItemTypeAO createOrUpdateConfigurationItemType(String configurationItemTypeKey) {
        ConfigurationItemTypeAO dbConfItemType = this.getConfigurationItemTypeAOByKey(configurationItemTypeKey);
        if (dbConfItemType == null) {
            dbConfItemType = (ConfigurationItemTypeAO)this.ao.create(ConfigurationItemTypeAO.class, new DBParam[0]);
            dbConfItemType.setKey(configurationItemTypeKey);
        }
        return dbConfItemType;
    }

    @Override
    public void saveConfigurationItemType(ConfigurationItemType configurationItemType) throws D42Exception {
        ConfigurationItemTypeAO dbConfItemType = this.createOrUpdateConfigurationItemType(configurationItemType.getKey());
        dbConfItemType.setName(configurationItemType.getName());
        dbConfItemType.setPluralName(configurationItemType.getPluralName());
        dbConfItemType.setDescription(configurationItemType.getDescription());
        dbConfItemType.setLinkComponent(configurationItemType.getLinkComponent());
        dbConfItemType.setRequiredColumnIndexes(configurationItemType.getRequiredColumnIndexesAsString());
        dbConfItemType.setQuery(configurationItemType.getQuery().toString());
        dbConfItemType.setIdIndex(configurationItemType.getIdIndex());
        dbConfItemType.setLastUpdatedIndex(configurationItemType.getLastUpdatedIndex());
        dbConfItemType.setCollectionWeight(configurationItemType.getCollectionWeight());
        dbConfItemType.setCollectable(configurationItemType.isCollectable());
        dbConfItemType.setFilterVisible(configurationItemType.isFilterVisible());
        dbConfItemType.setDefaultFilterEnabled(configurationItemType.isDefaultFilterEnabled());
        if (configurationItemType.getDisplayName() != null) {
            dbConfItemType.setDisplayNameFormat(configurationItemType.getDisplayName().getFormat());
        } else {
            dbConfItemType.setDisplayNameFormat(null);
        }
        dbConfItemType.save();
        for (ParameterType parameterType : configurationItemType.getParameterTypes()) {
            this.updateParameterType(configurationItemType.getKey(), parameterType);
        }
    }

    @Override
    public void checkReferenceParameters() throws D42Exception {
        for (ConfigurationItemType cit : this.getSchema()) {
            for (ParameterType parameterType : cit.getParameterTypes()) {
                if (!(parameterType instanceof ReferenceParameterType)) continue;
                ConfigurationItemType configurationItemType = this.getSchema().getByKey(((ReferenceParameterType)parameterType).getConfigurationItemKey());
                if (configurationItemType != null && configurationItemType.isCollectable()) {
                    parameterType.setEnabled(true);
                } else {
                    parameterType.setEnabled(false);
                }
                this.updateParameterType(cit.getKey(), parameterType);
            }
        }
    }

    @Override
    public void deleteConfigurationItemTypeByKey(String key) {
        Query query = Query.select().where("KEY = ?", new Object[]{key});
        ConfigurationItemTypeAO[] dbConfItemTypes = (ConfigurationItemTypeAO[])this.ao.find(ConfigurationItemTypeAO.class, query);
        if (dbConfItemTypes != null && dbConfItemTypes.length > 0) {
            ConfigurationItemTypeAO dbConfItemToDelete = dbConfItemTypes[0];
            if (dbConfItemToDelete.getParameterTypes() != null) {
                for (ParameterTypeAO dbParameterType : dbConfItemToDelete.getParameterTypes()) {
                    this.ao.delete(new RawEntity[]{dbParameterType});
                }
            }
            this.ao.delete(new RawEntity[]{dbConfItemToDelete});
        }
    }

    private ParameterTypeAO getParameterTypeAO(String configurationItemTypeKey, String parameterKey, boolean createIfNotExist) throws D42Exception {
        Query query = Query.select().alias(ParameterTypeAO.class, "D42PTYPE").alias(ConfigurationItemTypeAO.class, "D42CIT").join(ConfigurationItemTypeAO.class, this.join("D42PTYPE", "CONF_ITEM_TYPE_ID", "D42CIT", "ID")).where("D42CIT.KEY = ? AND D42PTYPE.KEY = ?", new Object[]{configurationItemTypeKey, parameterKey});
        ParameterTypeAO[] dbParameterType = (ParameterTypeAO[])this.ao.find(ParameterTypeAO.class, query);
        if (dbParameterType != null && dbParameterType.length > 0) {
            return dbParameterType[0];
        }
        if (!createIfNotExist) {
            return null;
        }
        ConfigurationItemTypeAO dbConfigurationItemType = this.getConfigurationItemTypeAOByKey(configurationItemTypeKey);
        if (dbConfigurationItemType == null) {
            throw new D42Exception("No key provided");
        }
        return (ParameterTypeAO)this.ao.create(ParameterTypeAO.class, new DBParam[]{new DBParam("KEY", (Object)parameterKey), new DBParam("CONF_ITEM_TYPE_ID", (Object)dbConfigurationItemType)});
    }

    private Long resolveReference(String value) {
        Pattern pattern = Pattern.compile("^\\{ref:(\\d+)}$");
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            return Long.valueOf(matcher.group(1));
        }
        return null;
    }

    private Query getQueryConfigurationItemsBySearchFilter(ConfigurationItemFilter configurationItemFilter) {
        Query query = MultiQuery.select().from(ConfigurationItemAO.class).alias(ConfigurationItemAO.class, "D42CI");
        int parameterNumber = 0;
        StringBuilder whereQuery = new StringBuilder();
        ArrayList<Object> whereParam = new ArrayList<Object>();
        for (ParameterFilter parameterFilter : configurationItemFilter) {
            String parameterKey = parameterFilter.getType().getKey();
            String value = parameterFilter.getFilterValue();
            query.alias(ParameterAO.class, "D42PAR" + ++parameterNumber);
            query.join(ParameterAO.class, this.join("D42CI", "ID", "D42PAR" + parameterNumber, "CONF_ITEM_ID"));
            if (parameterNumber == 1) {
                whereQuery.append("D42CI.TYPE_KEY = ? AND D42PAR").append(parameterNumber).append(".").append("TYPE_KEY").append(" = ?");
                whereParam.add(configurationItemFilter.getType().getKey());
                whereParam.add(parameterKey);
            } else {
                whereQuery.append(" AND ").append("D42PAR").append(parameterNumber - 1).append(".").append("ID").append(" <> ").append("D42PAR").append(parameterNumber).append(".\"").append("ID").append("\" AND ").append("D42PAR").append(parameterNumber).append(".").append("TYPE_KEY").append(" = ?");
                whereParam.add(parameterKey);
            }
            List<String> list = parameterFilter.getCondition();
            if (list.isEmpty()) {
                Long refId = this.resolveReference(value);
                if (refId != null) {
                    whereQuery.append(" AND ");
                    whereQuery.append("D42PAR").append(parameterNumber).append(".").append("PARAMETER_CONF_ITEM_STORAGE_ID").append(" = ? ");
                    whereParam.add(refId);
                    continue;
                }
                whereQuery.append(" AND ");
                whereQuery.append("D42PAR").append(parameterNumber).append(".").append("VALUE").append(" LIKE ? ");
                whereParam.add("%" + value + "%");
                continue;
            }
            String cond = list.get(0);
            list.remove(0);
            whereQuery.append(" AND (");
            Iterator<String> it = list.iterator();
            while (it.hasNext()) {
                String val = it.next();
                Long refId = this.resolveReference(val);
                if (refId != null) {
                    whereQuery.append("D42PAR").append(parameterNumber).append(".").append("PARAMETER_CONF_ITEM_STORAGE_ID").append(" = ? ");
                    if (it.hasNext()) {
                        whereQuery.append(cond + " ");
                    }
                    whereParam.add(refId);
                    continue;
                }
                whereQuery.append("D42PAR").append(parameterNumber).append(".").append("VALUE").append(" LIKE ? ");
                if (it.hasNext()) {
                    whereQuery.append(cond + " ");
                }
                whereParam.add("%" + val + "%");
            }
            whereQuery.append(")");
        }
        query.where(whereQuery.toString(), whereParam.toArray());
        return query;
    }

    private int getCountConfigurationItemsBySearchFilter(ConfigurationItemFilter configurationItemFilter) {
        Query query = this.getQueryConfigurationItemsBySearchFilter(configurationItemFilter);
        return this.ao.count(ConfigurationItemAO.class, query);
    }

    private ConfigurationItemAO[] getDbConfigurationItemsBySearchFilter(ConfigurationItemFilter configurationItemFilter, int offset, int limit) {
        Query query = this.getQueryConfigurationItemsBySearchFilter(configurationItemFilter);
        query.order("CACHED_DISPLAY_NAME ASC");
        query.limit(limit).offset(offset);
        return (ConfigurationItemAO[])this.ao.find(ConfigurationItemAO.class, query);
    }

    @Override
    public void updateParameterType(@Nonnull String configurationItemTypeKey, @Nonnull ParameterType parameterType) throws D42Exception {
        String parameterTypeKey = parameterType.getKey();
        if (configurationItemTypeKey != null && parameterTypeKey != null) {
            ParameterTypeAO dbParamType = this.getParameterTypeAO(configurationItemTypeKey, parameterTypeKey, true);
            dbParamType.setName(parameterType.getName());
            dbParamType.setDescription(parameterType.getDescription());
            dbParamType.setParameterValueType(parameterType.getValueType());
            dbParamType.setViewWeight(parameterType.getViewWeight());
            dbParamType.setAdditionalTypeData(parameterType.getAdditionalTypeData());
            dbParamType.setSearchEnabled(parameterType.isSearchEnabled());
            dbParamType.setDefaultFilterEnabled(parameterType.isDefaultFilterViewEnabled());
            dbParamType.setEnabled(parameterType.isEnabled());
            dbParamType.save();
        }
    }

    @Override
    public void removeParameterType(String configurationItemTypeKey, String parameterKey) throws D42Exception {
        ParameterTypeAO dbParamType = this.getParameterTypeAO(configurationItemTypeKey, parameterKey, false);
        if (dbParamType != null) {
            this.ao.delete(new RawEntity[]{dbParamType});
        }
    }

    @Override
    public void importSchema(Schema schema) throws D42Exception {
        this.ao.delete(this.ao.find(ParameterTypeAO.class));
        this.ao.delete(this.ao.find(ConfigurationItemTypeAO.class));
        this.mergeSchema(schema);
    }

    @Override
    public void mergeSchema(Schema schema) throws D42Exception {
        for (ConfigurationItemType configurationItemType : schema) {
            this.saveConfigurationItemType(configurationItemType);
        }
    }

    @Override
    public void importDefaultSchema(boolean deleteExisting) throws D42Exception {
        String defaultSchemaPath = this.d42SupportManager.getCurrentSupportedVersion() >= D42Version.SERVICE_REWRITE_VERSION.getLong() ? "/com/device42/atlas/default-schema-v2.json" : "/com/device42/atlas/default-schema.json";
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)defaultSchemaPath, this.getClass());
        if (is != null) {
            try {
                String stringSchema = IOUtils.toString((InputStream)is);
                MapDonor schemaDonor = JsonUtil.jsonStringToMapDonor(stringSchema);
                if (schemaDonor != null) {
                    Schema schema = new Schema(schemaDonor);
                    if (deleteExisting) {
                        this.importSchema(schema);
                    }
                    this.mergeSchema(schema);
                }
                throw new D42Exception("Failed to parse loaded schema from json");
            }
            catch (IOException e) {
                throw new D42Exception("Failed to load default resource", e);
            }
        } else {
            throw new D42Exception("No default resource found");
        }
    }
}

