/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job.upgrade.v30;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.job.upgrade.v30.ConfigurationItemAO;
import com.device42.atlas.common.job.upgrade.v30.ConfigurationItemFilterAO;
import com.device42.atlas.common.job.upgrade.v30.FilterAO;
import com.device42.atlas.common.job.upgrade.v30.KeyContaining;
import com.device42.atlas.common.job.upgrade.v30.MigrationTypeAO;
import com.device42.atlas.common.job.upgrade.v30.ParameterAO;
import com.device42.atlas.common.job.upgrade.v30.ParameterFilterAO;
import com.device42.atlas.common.job.upgrade.v30._ConfigurationItemType;
import com.device42.atlas.common.job.upgrade.v30._ParameterType;
import com.device42.atlas.common.model.serialization.MapDonor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.util.JsonUtil;
import com.device42.atlas.common.util.ObjectUtils;
import java.io.InputStream;
import net.java.ao.Entity;
import net.java.ao.Query;
import org.apache.commons.io.IOUtils;

public class Device42ActiveObjectsUpgradeTask31
implements ActiveObjectsUpgradeTask {
    public static Logger.Log log = Logger.getInstance(Device42ActiveObjectsUpgradeTask31.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"31");
    }

    private <T1 extends Entity & MigrationTypeAO, T2 extends Enum<T2>> void migrateKeyedObject(ActiveObjects ao, Class<T1> migrationClass, Class<T2> typeClass, Query query, ParameterDonor keyMapping) {
        int objectsAmount = ao.count(migrationClass, query);
        for (int offset = 0; offset < objectsAmount; offset += 1000) {
            query.limit(1000).offset(offset).order("ID ASC");
            MigrationTypeAO[] items = (MigrationTypeAO[])ao.find(migrationClass, query);
            if (items == null) continue;
            for (MigrationTypeAO item : items) {
                String enumTypeStringified = item.getType();
                String key = null;
                KeyContaining enumType = ObjectUtils.enumValue(enumTypeStringified, typeClass, null);
                if (enumType instanceof KeyContaining) {
                    key = enumType.getKey();
                }
                if (keyMapping != null && key != null && keyMapping.contains(key)) {
                    Object mappedKey = keyMapping.get(key);
                    key = mappedKey == null ? key : mappedKey.toString();
                }
                item.setTypeKey(key);
                item.save();
            }
        }
    }

    private String join(String table1, String column1, String table2, String column2) {
        return table1 + "." + column1 + " = " + table2 + "." + column2;
    }

    private void migrateCI(ActiveObjects ao) {
        this.migrateKeyedObject(ao, ConfigurationItemAO.class, _ConfigurationItemType.class, Query.select(), null);
    }

    private void migrateCIFilter(ActiveObjects ao) {
        this.migrateKeyedObject(ao, ConfigurationItemFilterAO.class, _ConfigurationItemType.class, Query.select(), null);
    }

    private void migrateParameter(ActiveObjects ao, _ConfigurationItemType configurationItemType, ParameterDonor parameterMapping) {
        Query query = Query.select();
        query.alias(ParameterAO.class, "D42PAR").alias(ConfigurationItemAO.class, "D42CI").join(ConfigurationItemAO.class, this.join("D42PAR", "CONF_ITEM_ID", "D42CI", "ID")).where("D42CI.TYPE = ?", new Object[]{configurationItemType});
        this.migrateKeyedObject(ao, ParameterAO.class, _ParameterType.class, query, parameterMapping);
    }

    private void migrateParameterFilter(ActiveObjects ao, _ConfigurationItemType configurationItemType, ParameterDonor parameterMapping) {
        Query query = Query.select();
        query.alias(ParameterFilterAO.class, "D42PARF").alias(ConfigurationItemFilterAO.class, "D42CIF").join(ConfigurationItemFilterAO.class, this.join("D42PARF", "CONF_ITEM_FILTER_ID", "D42CIF", "ID")).where("D42CIF.TYPE = ?", new Object[]{configurationItemType});
        this.migrateKeyedObject(ao, ParameterFilterAO.class, _ParameterType.class, query, parameterMapping);
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects ao) {
        log.info((Object)"Device42 schema is starting to upgrade to 31 version");
        ao.migrate(new Class[]{ConfigurationItemAO.class, ConfigurationItemFilterAO.class, FilterAO.class, ParameterAO.class, ParameterFilterAO.class});
        this.migrateCI(ao);
        this.migrateCIFilter(ao);
        MapDonor mappingDonor = null;
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)"/com/device42/atlas/upgrade-31-mapping.json", this.getClass());
        if (is != null) {
            try {
                String mapping = IOUtils.toString((InputStream)is);
                mappingDonor = JsonUtil.jsonStringToMapDonor(mapping);
            }
            catch (Exception e) {
                log.error((Object)"Mapping json was not found, parameters were not migrated", (Throwable)e);
            }
        } else {
            log.error((Object)"Mapping json was not found, parameters were not migrated");
        }
        if (mappingDonor != null) {
            for (_ConfigurationItemType configurationItemType : _ConfigurationItemType.values()) {
                ParameterDonor ciParameterMapping = mappingDonor.extractNestedObject(configurationItemType.getKey());
                this.migrateParameter(ao, configurationItemType, ciParameterMapping);
                this.migrateParameterFilter(ao, configurationItemType, ciParameterMapping);
            }
        }
        log.info((Object)"Device42 schema was upgraded to 31 version successfully");
    }
}

