/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.device42.atlas.common.job.ConfigurationItemCollectionStatistics;
import com.device42.atlas.common.job.JobStatistics;
import com.device42.atlas.common.job.JobStatus;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42JobStatisticsManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.model.D42ConnectionInfo;
import com.device42.atlas.common.model.core.Filter;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.remote.Device42RestClient;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.PartialCIList;
import java.util.Date;
import java.util.List;

public class UpdateDataTask {
    public static final String TYPES_COUNT = "typesCount";
    private static final Logger.Log log = Logger.getInstance(UpdateDataTask.class);
    private final D42SettingsManager d42SettingsManager;
    private final D42DataManager d42DataManager;
    private final TransactionTemplate transactionTemplate;
    private final D42JobStatisticsManager jobStatisticsManager;

    public UpdateDataTask(D42SettingsManager d42SettingsManager, D42DataManager d42DataManager, TransactionTemplate transactionTemplate, D42JobStatisticsManager jobStatisticsManager) {
        this.d42SettingsManager = d42SettingsManager;
        this.d42DataManager = d42DataManager;
        this.transactionTemplate = transactionTemplate;
        this.jobStatisticsManager = jobStatisticsManager;
    }

    private void checkCancellation(String jobSessionId) throws D42Exception {
        JobStatus jobStatus = this.jobStatisticsManager.getCurrentJobStatus();
        if (jobStatus == JobStatus.CANCELLED) {
            this.jobStatisticsManager.setJobStatus(jobSessionId, JobStatus.ROLLBACK, true);
            throw new D42Exception("Job cancelled");
        }
        if (jobStatus == JobStatus.ROLLBACK) {
            throw new D42Exception("Job cancelled");
        }
    }

    private boolean addResultsInTransaction(final PartialCIList cis, final boolean deactivateCIs) {
        Boolean result = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                try {
                    UpdateDataTask.this.d42DataManager.createOrUpdateCIs(cis, deactivateCIs);
                    return true;
                }
                catch (Exception e) {
                    log.error((Object)"Failed to add CIs to the list", (Throwable)e);
                    return false;
                }
            }
        });
        return result;
    }

    private boolean postProcessInTransaction() {
        Boolean result = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                try {
                    log.info((Object)"All items collected. Fixing CI parameters");
                    UpdateDataTask.this.loadSchemaInTransaction();
                    log.info((Object)"CI parameters fixed. Reapplying filters");
                    List<Filter> filters = UpdateDataTask.this.d42DataManager.getNonPrimitiveFilters();
                    for (Filter filter : filters) {
                        UpdateDataTask.this.d42DataManager.applyFilter(filter, 1000);
                    }
                    return true;
                }
                catch (Exception e) {
                    log.error((Object)"Failed to add CIs to the list", (Throwable)e);
                    return false;
                }
            }
        });
        return result;
    }

    private Schema loadSchemaInTransaction() {
        Schema result = (Schema)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Schema>(){

            public Schema doInTransaction() {
                try {
                    log.info((Object)"Collecting schema");
                    return UpdateDataTask.this.d42DataManager.getCollectableSchema();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to gather schema", (Throwable)e);
                    return null;
                }
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(boolean forceRun, boolean fullRescan) {
        String jobSessionId = this.jobStatisticsManager.generateSessionId();
        try {
            Schema schema = this.loadSchemaInTransaction();
            if (schema.isEmpty()) {
                this.d42DataManager.importDefaultSchema(false);
                schema = this.loadSchemaInTransaction();
            }
            this.checkCancellation(jobSessionId);
            boolean jobStartResult = this.jobStatisticsManager.startJob(schema, jobSessionId, forceRun, fullRescan);
            this.jobStatisticsManager.setPendingManually(false);
            if (!jobStartResult) {
                log.error((Object)"Start job failed, skipping");
                boolean bl = false;
                return bl;
            }
            log.info((Object)("Starting D42 update task: " + new Date() + ", full rescan: " + fullRescan));
            D42ConnectionInfo d42ConnectionInfo = this.d42SettingsManager.getConnectionInfo();
            if (d42ConnectionInfo == null || !d42ConnectionInfo.isConfigured()) {
                throw new D42Exception("Device42 connection is not configured");
            }
            Device42RestClient restClient = new Device42RestClient(d42ConnectionInfo.getBaseUrl(), d42ConnectionInfo.getUsername(), d42ConnectionInfo.getPassword(), d42ConnectionInfo.getDefaultLimit());
            this.jobStatisticsManager.setJobStatus(jobSessionId, JobStatus.SCANNING, false);
            boolean collectionSucceeded = false;
            for (ConfigurationItemType type : schema) {
                log.info((Object)("Collecting " + type.getName() + " entities"));
                try {
                    if (fullRescan) {
                        this.getAll(restClient, schema, type, jobSessionId);
                    } else {
                        Date lastUpdatedTime = null;
                        if (type.hasLastUpdated()) {
                            lastUpdatedTime = this.jobStatisticsManager.getLastUpdatedTime(type);
                        }
                        this.getUpdatedAfter(restClient, schema, type, jobSessionId, lastUpdatedTime);
                    }
                    collectionSucceeded = true;
                }
                catch (Exception e) {
                    JobStatistics jobStatistics = this.jobStatisticsManager.getCurrentJobStatistics(schema);
                    long total = jobStatistics.getConfigurationItemCollectionStatistics(type).getTotal();
                    long collected = jobStatistics.getConfigurationItemCollectionStatistics(type).getCollected();
                    this.jobStatisticsManager.updateConfigurationItemStatistics(schema, jobSessionId, type, collected, total, ConfigurationItemCollectionStatistics.ConfigurationItemCollectionStatus.ERROR);
                    log.error((Object)("Failed to collect " + type.getName()), (Throwable)e);
                }
                this.checkCancellation(jobSessionId);
            }
            this.jobStatisticsManager.setJobStatus(jobSessionId, JobStatus.POST_PROCESSING, false);
            this.checkCancellation(jobSessionId);
            if (!collectionSucceeded) {
                throw new D42Exception("Failed to synch, no data collected");
            }
            this.postProcessInTransaction();
            this.jobStatisticsManager.setJobStatus(jobSessionId, fullRescan ? JobStatus.COMPLETED : JobStatus.INCREMENTAL_COMPLETED, false);
        }
        catch (Exception ex) {
            log.error((Object)"Error updating D42 data", (Throwable)ex);
            if (this.jobStatisticsManager.getCurrentJobStatus() == JobStatus.ROLLBACK) {
                this.jobStatisticsManager.setJobStatus(jobSessionId, JobStatus.ABORTED, true);
            } else {
                this.jobStatisticsManager.setJobStatus(jobSessionId, JobStatus.FAILED, true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            log.info((Object)("D42 update task finished: " + new Date()));
        }
        return true;
    }

    private long getAll(Device42RestClient restClient, Schema schema, ConfigurationItemType type, String jobSessionId) throws D42Exception {
        return this.getUpdatedAfter(restClient, schema, type, jobSessionId, null);
    }

    private long getUpdatedAfter(Device42RestClient restClient, Schema schema, final ConfigurationItemType type, String jobSessionId, Date updatedAfter) throws D42Exception {
        long total;
        long collected;
        log.debug((Object)("Starting " + type.getName() + " collection"));
        log.debug((Object)("Updated after: " + updatedAfter));
        if (updatedAfter != null) {
            JobStatistics jobStatistics = this.jobStatisticsManager.getCurrentJobStatistics(schema);
            collected = jobStatistics.getConfigurationItemCollectionStatistics(type).getCollected();
            total = restClient.getAmount(type, updatedAfter) + jobStatistics.getConfigurationItemCollectionStatistics(type).getTotal();
        } else {
            total = restClient.getAmount(type, updatedAfter);
            collected = 0L;
        }
        this.jobStatisticsManager.updateConfigurationItemStatistics(schema, jobSessionId, type, 0L, total, ConfigurationItemCollectionStatistics.ConfigurationItemCollectionStatus.COLLECTING);
        long limit = restClient.getDefaultLimit();
        Date lastUpdated = null;
        if (updatedAfter != null) {
            lastUpdated = updatedAfter;
        }
        if (total == 0L && updatedAfter == null) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    UpdateDataTask.this.d42DataManager.deactivateCIs(type);
                    return null;
                }
            });
        }
        for (long offset = 0L; offset < total; offset += limit) {
            this.checkCancellation(jobSessionId);
            PartialCIList partialResult = restClient.get(schema, type, limit, offset, updatedAfter);
            if (type.hasLastUpdated()) {
                lastUpdated = partialResult.getMostUpdated(lastUpdated);
            }
            this.addResultsInTransaction(partialResult, offset == 0L && updatedAfter == null);
            this.jobStatisticsManager.updateConfigurationItemStatistics(schema, jobSessionId, type, collected += (long)partialResult.size(), total, ConfigurationItemCollectionStatistics.ConfigurationItemCollectionStatus.COLLECTING);
            log.debug((Object)("Added " + partialResult.size() + " items, totally collected " + collected + (type.hasLastUpdated() ? " last updated found " + lastUpdated : "")));
        }
        if (type.hasLastUpdated()) {
            this.jobStatisticsManager.setLastUpdatedTime(jobSessionId, type, lastUpdated);
        }
        if (updatedAfter != null) {
            int count = (Integer)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction() {
                    return UpdateDataTask.this.d42DataManager.getDbActiveByTypeCount(type, null);
                }
            });
            if ((long)count < total) {
                total = count;
            }
            if ((long)count < collected) {
                collected = count;
            }
        }
        this.jobStatisticsManager.updateConfigurationItemStatistics(schema, jobSessionId, type, collected, total, ConfigurationItemCollectionStatistics.ConfigurationItemCollectionStatus.DONE);
        log.debug((Object)("Finishing " + type.getName() + " collection"));
        return collected;
    }
}

