/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.confluence.plugin.resources;

import com.coveo.confluence.plugin.model.CollectionResultModel;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

public abstract class BaseResource {
    private static final Logger logger = Logger.getLogger(BaseResource.class);
    private static final CacheControl m_CacheControlNever = CacheControl.valueOf((String)"never");

    protected <T> void setResultLinks(CollectionResultModel<T> result, UriInfo context, int offset, int limit, Boolean hasMoreItems) throws MalformedURLException, IllegalArgumentException, UriBuilderException {
        logger.debug((Object)"Entering setResultLinks");
        Preconditions.checkNotNull(result);
        Preconditions.checkNotNull(context);
        UriBuilder requestUriBuilder = context.getRequestUriBuilder();
        result.getLinks().setBase(context.getBaseUri().toString());
        result.getLinks().setSelf(requestUriBuilder.build(new Object[0]).toString());
        int currentTotalItems = offset + limit;
        if (hasMoreItems.booleanValue()) {
            requestUriBuilder.replaceQueryParam("limit", new Object[]{limit});
            requestUriBuilder.replaceQueryParam("start", new Object[]{currentTotalItems});
            URL absoluteRequestUrl = requestUriBuilder.build(new Object[0]).toURL();
            result.getLinks().setNext(absoluteRequestUrl.getFile());
        }
        logger.debug((Object)"Exiting setResultLinks");
    }

    protected String getErrorMessage(Throwable exception) {
        logger.debug((Object)"Entering getErrorMessage");
        Preconditions.checkNotNull(exception);
        String errorMessage = "Error: " + exception.getMessage() + " Type: " + exception.getClass().getName();
        logger.debug((Object)"Exiting getErrorMessage");
        return errorMessage;
    }

    protected Response.ResponseBuilder getUnauthorizedErrorResponse() {
        logger.debug((Object)"Entering getUnauthorizedErrorResponse");
        String message = String.format("The current user is not a Confluence administrator or a member of the group '%s'. The action cannot be performed.", "coveo-connector-plugin-users");
        Response.ResponseBuilder responseBuilder = this.getErrorResponse(Response.Status.UNAUTHORIZED, message);
        logger.debug((Object)"Exiting getUnauthorizedErrorResponse");
        return responseBuilder;
    }

    protected Response.ResponseBuilder getBadRequestErrorResponse(String message) {
        logger.debug((Object)"Entering getBadRequestErrorResponse");
        Preconditions.checkArgument(message != null && !message.isEmpty());
        Response.ResponseBuilder responseBuilder = this.getErrorResponse(Response.Status.BAD_REQUEST, "Invalid request: " + message + " The action cannot be performed.");
        logger.debug((Object)"Exiting getBadRequestErrorResponse");
        return responseBuilder;
    }

    protected Response.ResponseBuilder getErrorResponse(Response.Status status, String message) {
        logger.debug((Object)"Entering getErrorResponse");
        Preconditions.checkNotNull(status);
        Preconditions.checkArgument(message != null && !message.isEmpty());
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity((Object)message).cacheControl(m_CacheControlNever);
        logger.debug((Object)"Exiting getErrorResponse");
        return responseBuilder;
    }
}

