/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.confluence.plugin.incremental;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.event.events.space.SpaceEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.coveo.confluence.plugin.incremental.ItemCollection;
import com.coveo.confluence.plugin.incremental.ItemEvent;
import com.coveo.confluence.plugin.incremental.ItemEventService;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.log4j.Logger;

public final class ItemEventServiceImpl
implements ItemEventService {
    private static final Logger logger = Logger.getLogger(ItemEventServiceImpl.class);
    public static final String MOVED_EVENT = "moved";
    public static final String DELETED_EVENT = "deleted";
    public static final String RESTORED_EVENT = "restored";
    public static final String MODIFIED_RESTRICTIONS_EVENT = "modifiedRestrictions";
    public static final String MODIFIED_COMMENTS_EVENT = "modifiedComments";
    public static final ImmutableList<String> SUPPORTED_EVENTS = ImmutableList.of("moved", "deleted", "restored", "modifiedRestrictions", "modifiedComments");
    private final int EVENTS_RETENTION_IN_DAYS = 7;
    private final ActiveObjects ao;

    public ItemEventServiceImpl(ActiveObjects ao) {
        logger.debug((Object)"Entering ItemEventServiceImpl");
        this.ao = Preconditions.checkNotNull(ao);
        logger.debug((Object)"Exiting ItemEventServiceImpl");
    }

    @Override
    public void add(SpaceEvent event) {
        logger.debug((Object)"Entering add(SpaceEvent)");
        Preconditions.checkNotNull(event);
        Space space = event.getSpace();
        ItemEvent itemEvent = (ItemEvent)this.ao.create(ItemEvent.class, new DBParam[0]);
        itemEvent.setItemId(space.getKey());
        itemEvent.setItemType(space.getType());
        itemEvent.setEventType(DELETED_EVENT);
        itemEvent.setEventDate(new Date(event.getTimestamp()));
        itemEvent.setSpaceKey(space.getKey());
        itemEvent.setItemUrl(space.getUrlPath());
        itemEvent.save();
        logger.debug((Object)"Exiting add(SpaceEvent)");
    }

    @Override
    public void add(ContentEvent event) {
        logger.debug((Object)"Entering add(ContentEvent)");
        Preconditions.checkNotNull(event);
        String eventType = event instanceof PageMoveEvent || event instanceof BlogPostMovedEvent ? MOVED_EVENT : (event instanceof PageRestoreEvent || event instanceof BlogPostRestoreEvent ? RESTORED_EVENT : (event instanceof ContentPermissionEvent ? MODIFIED_RESTRICTIONS_EVENT : (event instanceof CommentEvent ? MODIFIED_COMMENTS_EVENT : DELETED_EVENT)));
        if (event instanceof AttachmentEvent) {
            for (Attachment attachement : ((AttachmentEvent)event).getAttachments()) {
                ItemEvent itemEvent = (ItemEvent)this.ao.create(ItemEvent.class, new DBParam[0]);
                itemEvent.setItemId("att" + attachement.getIdAsString());
                itemEvent.setItemType(attachement.getType());
                itemEvent.setEventDate(new Date(event.getTimestamp()));
                itemEvent.setEventType(eventType);
                itemEvent.setItemVersionId(attachement.getVersion());
                itemEvent.setSpaceKey(this.extractSpaceKey(event));
                itemEvent.setItemUrl(attachement.getUrlPath());
                itemEvent.save();
            }
        } else {
            ContentEntityObject content = event.getContent();
            if (event instanceof CommentEvent) {
                Comment comment = (Comment)content;
                content = comment.getContainer();
            }
            if (content != null) {
                ItemEvent itemEvent = (ItemEvent)this.ao.create(ItemEvent.class, new DBParam[0]);
                itemEvent.setItemId(content.getIdAsString());
                itemEvent.setItemType(content.getType());
                itemEvent.setEventDate(new Date(event.getTimestamp()));
                itemEvent.setEventType(eventType);
                itemEvent.setItemVersionId(content.getVersion());
                itemEvent.setSpaceKey(this.extractSpaceKey(event));
                itemEvent.setItemUrl(content.getUrlPath());
                if (event instanceof PageMoveEvent) {
                    itemEvent.setOldSpaceKey(((PageMoveEvent)event).getOldSpace().getKey());
                }
                if (event instanceof BlogPostMovedEvent) {
                    itemEvent.setOldSpaceKey(((BlogPostMovedEvent)event).getOriginalSpace().getKey());
                }
                itemEvent.save();
            }
        }
        logger.debug((Object)"Exiting add(ContentEvent)");
    }

    @Override
    public ItemCollection<ItemEvent> getEvents(String eventType, String itemType, String spaceKey, long ignoreOlderThan, int limit, int offset) {
        String whereClause;
        logger.debug((Object)"Entering getEvents");
        Preconditions.checkArgument(eventType != null && !eventType.isEmpty());
        Preconditions.checkArgument(limit > 0);
        Preconditions.checkArgument(offset >= 0);
        ArrayList<Object> params = new ArrayList<Object>();
        if (eventType.contains(",")) {
            ArrayList<String> eventTypes = Lists.newArrayList(Splitter.on(",").trimResults().omitEmptyStrings().split(eventType));
            String eventTypesParams = Joiner.on(", ").join(Iterables.transform(eventTypes, Functions.constant("?")));
            whereClause = "EVENT_TYPE IN (" + eventTypesParams + ")";
            params.addAll(eventTypes);
        } else {
            whereClause = "EVENT_TYPE = ?";
            params.add(eventType);
        }
        if (itemType != null && !itemType.isEmpty()) {
            whereClause = whereClause + " AND ITEM_TYPE = ?";
            params.add(itemType);
        }
        if (spaceKey != null && !spaceKey.isEmpty()) {
            whereClause = whereClause + " AND SPACE_KEY = ?";
            params.add(spaceKey);
        }
        if (ignoreOlderThan > 0L) {
            whereClause = whereClause + " AND EVENT_DATE >= ?";
            params.add(new Date(ignoreOlderThan));
        }
        Query query = Query.select().where(whereClause, params.toArray());
        int count = this.ao.count(ItemEvent.class, query);
        ItemEvent[] eventItems = (ItemEvent[])this.ao.find(ItemEvent.class, query.order("ID ASC").limit(limit).offset(offset));
        this.purgeOldItemEvents();
        logger.debug((Object)"Exiting getEvents");
        return new ItemCollection<ItemEvent>(Lists.newArrayList(eventItems), count);
    }

    private void purgeOldItemEvents() {
        logger.debug((Object)"Entering purgeOldItemEvents");
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        Date thresholdDate = cal.getTime();
        this.ao.deleteWithSQL(ItemEvent.class, "EVENT_DATE < ?", new Object[]{thresholdDate});
        logger.debug((Object)"Exiting purgeOldItemEvents");
    }

    private String extractSpaceKey(ContentEvent event) {
        Space space;
        logger.debug((Object)"Entering extractSpaceKey");
        Preconditions.checkNotNull(event);
        String spaceKey = null;
        ContentEntityObject entity = event.getContent();
        if (entity != null && entity instanceof Spaced && (space = ((Spaced)entity).getSpace()) != null) {
            spaceKey = space.getKey();
        }
        logger.debug((Object)"Exiting extractSpaceKey");
        return spaceKey;
    }
}

