/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.confluence.plugin.resources;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.coveo.confluence.plugin.helper.PermissionChecker;
import com.coveo.confluence.plugin.model.CachedGroupPager;
import com.coveo.confluence.plugin.model.CachedUser;
import com.coveo.confluence.plugin.model.CollectionResultModel;
import com.coveo.confluence.plugin.model.GlobalSpacePermissionModel;
import com.coveo.confluence.plugin.model.GroupModel;
import com.coveo.confluence.plugin.model.RestrictionModel;
import com.coveo.confluence.plugin.model.UserModel;
import com.coveo.confluence.plugin.resources.BaseResource;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="/security")
@Produces(value={"application/json"})
public class SecurityResource
extends BaseResource {
    private static final Logger logger = Logger.getLogger(SecurityResource.class);
    private static final int DEFAULT_OFFSET_NO_PAGINATION = 0;
    private final SpacePermissionManager spacePermissionManager;
    private final ContentPermissionManager contentPermissionManager;
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private final GroupManager groupManager;
    private final UserAccessor userAccessor;
    private final PermissionChecker permissionChecker;
    private final Cache<String, CachedUser> usersCache;
    private final Cache<String, CachedGroupPager> groupMembersCache;

    public SecurityResource(SpacePermissionManager spacePermissionManager, ContentPermissionManager contentPermissionManager, SpaceManager spaceManager, PageManager pageManager, GroupManager groupManager, UserAccessor userAccessor, PermissionManager permissionManager, CacheManager cacheManager) {
        logger.debug((Object)"Entering SecurityResource");
        this.spacePermissionManager = (SpacePermissionManager)Preconditions.checkNotNull((Object)spacePermissionManager);
        this.contentPermissionManager = (ContentPermissionManager)Preconditions.checkNotNull((Object)contentPermissionManager);
        this.pageManager = (PageManager)Preconditions.checkNotNull((Object)pageManager);
        this.groupManager = (GroupManager)Preconditions.checkNotNull((Object)groupManager);
        this.spaceManager = (SpaceManager)Preconditions.checkNotNull((Object)spaceManager);
        this.userAccessor = (UserAccessor)Preconditions.checkNotNull((Object)userAccessor);
        this.permissionChecker = new PermissionChecker(permissionManager, spaceManager, userAccessor);
        this.usersCache = cacheManager.getCache("Coveo Confluence Users Cache", (CacheLoader)new UserCacheLoader(userAccessor), new CacheSettingsBuilder().expireAfterAccess(4L, TimeUnit.HOURS).maxEntries(5000).build());
        this.groupMembersCache = cacheManager.getCache("Coveo Confluence Groups Cache", (CacheLoader)new GroupCacheLoader(), new CacheSettingsBuilder().remote().replicateViaInvalidation().expireAfterAccess(1L, TimeUnit.HOURS).maxEntries(10).build());
        logger.debug((Object)"Exiting SecurityResource");
    }

    @GET
    @Path(value="/users")
    public Response getUsers(@DefaultValue(value="0") @QueryParam(value="start") int offset, @DefaultValue(value="100") @QueryParam(value="limit") int limit, @Context UriInfo context) {
        Response.ResponseBuilder responseBuilder;
        logger.debug((Object)"Entering getUsers");
        logger.debug((Object)String.format("Executed API call: %s.", context.getRequestUri()));
        if (!this.permissionChecker.isUserAllowed().booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        try {
            logger.debug((Object)"Loading the users.");
            Pager usersPager = this.userAccessor.getUsers();
            usersPager.skipTo(offset);
            ArrayList<UserModel> users = new ArrayList<UserModel>();
            for (User user : usersPager) {
                users.add(SecurityResource.createUser(user));
                if (users.size() != limit) continue;
                break;
            }
            CollectionResultModel result = new CollectionResultModel(users, offset, limit);
            this.setResultLinks(result, context, offset, limit, usersPager.iterator().hasNext());
            responseBuilder = Response.ok(result);
        }
        catch (Exception ex) {
            logger.error((Object)"Unknown error has occurred when getting users.", (Throwable)ex);
            responseBuilder = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorMessage(ex));
        }
        logger.debug((Object)"Exiting getUsers");
        return responseBuilder.build();
    }

    @GET
    @Path(value="/users/{userName}")
    public Response getUser(@PathParam(value="userName") String userName, @DefaultValue(value="false") @QueryParam(value="useCache") boolean useCache, @Context UriInfo context) {
        Response.ResponseBuilder responseBuilder;
        logger.debug((Object)"Entering getUser");
        logger.debug((Object)String.format("Executed API call: %s.", context.getRequestUri()));
        if (!this.permissionChecker.isUserAllowed().booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        try {
            logger.debug((Object)String.format("Loading the user '%s'.", userName));
            UserModel result = this.getUser(userName, useCache);
            if (result == null) {
                String errorNotFound = String.format("User '%s' not found.", userName);
                logger.debug((Object)errorNotFound);
                return this.getErrorResponse(Response.Status.NOT_FOUND, errorNotFound).build();
            }
            logger.debug((Object)String.format("The user '%s' was retrieved.", userName));
            responseBuilder = Response.ok((Object)result);
        }
        catch (Exception ex) {
            logger.error((Object)"Unknown error has occurred when getting a specific user.", (Throwable)ex);
            responseBuilder = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorMessage(ex));
        }
        logger.debug((Object)"Exiting getUser");
        return responseBuilder.build();
    }

    @GET
    @Path(value="/groups")
    public Response getGroupMembers(@DefaultValue(value="") @QueryParam(value="groupName") String groupName, @DefaultValue(value="false") @QueryParam(value="useCache") boolean useCache, @DefaultValue(value="0") @QueryParam(value="start") int offset, @DefaultValue(value="100") @QueryParam(value="limit") int limit, @Context UriInfo context) {
        return this.getGroupUsers(context, groupName, useCache, offset, limit);
    }

    @GET
    @Path(value="/globalPermissions")
    public Response getGlobalReadPermissions(@Context UriInfo context) {
        Response.ResponseBuilder responseBuilder;
        logger.debug((Object)"Entering getGlobalSpacePermissions");
        logger.debug((Object)String.format("Executed API call: %s.", context.getRequestUri()));
        if (!this.permissionChecker.isUserAllowed().booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        try {
            logger.debug((Object)"Loading the global space permissions.");
            List globalPermissions = this.spacePermissionManager.getGlobalPermissions("USECONFLUENCE");
            responseBuilder = Response.ok(this.createSpacePermissionsCollectionModel(context, globalPermissions, new ArrayList<String>()));
        }
        catch (Exception ex) {
            logger.error((Object)"Unknown error has occurred when getting global permissions.", (Throwable)ex);
            responseBuilder = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorMessage(ex));
        }
        logger.debug((Object)"Exiting getGlobalSpacePermissions");
        return responseBuilder.build();
    }

    @GET
    @Path(value="/spacePermissions/{spaceKey}")
    public Response getSpacePermissions(@PathParam(value="spaceKey") String spaceKey, @Context UriInfo context) {
        Response.ResponseBuilder responseBuilder;
        logger.debug((Object)"Entering getSpacePermissions");
        logger.debug((Object)String.format("Executed API call: %s.", context.getRequestUri()));
        if (!this.permissionChecker.isUserAllowed().booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        Space specificSpace = this.spaceManager.getSpace(spaceKey);
        if (specificSpace == null) {
            String errorNotFound = String.format("Space '%s' not found.", spaceKey);
            logger.debug((Object)errorNotFound);
            return this.getErrorResponse(Response.Status.NOT_FOUND, errorNotFound).build();
        }
        if (!this.permissionChecker.checkUserCanViewSpace(spaceKey).booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        try {
            List spacePermissions = specificSpace.getPermissions();
            List<String> targetPermissionTypes = Arrays.asList("VIEWSPACE");
            responseBuilder = Response.ok(this.createSpacePermissionsCollectionModel(context, spacePermissions, targetPermissionTypes));
        }
        catch (Exception ex) {
            logger.error((Object)String.format("Unknown error has occurred when getting space '%s' permissions.", spaceKey), (Throwable)ex);
            responseBuilder = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorMessage(ex));
        }
        logger.debug((Object)"Exiting getSpacePermissions");
        return responseBuilder.build();
    }

    @GET
    @Path(value="/globalAdmins")
    public Response getGlobalAdmins(@Context UriInfo context) {
        Response.ResponseBuilder responseBuilder;
        logger.debug((Object)"Entering getGlobalAdmins");
        logger.debug((Object)String.format("Executed API call: %s.", context.getRequestUri()));
        if (!this.permissionChecker.isUserAllowed().booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        try {
            logger.debug((Object)"Loading the global admin permissions.");
            List permissions = this.spacePermissionManager.getGlobalPermissions();
            List<String> targetPermissionTypes = Arrays.asList("SYSTEMADMINISTRATOR", "ADMINISTRATECONFLUENCE");
            responseBuilder = Response.ok(this.createSpacePermissionsCollectionModel(context, permissions, targetPermissionTypes));
        }
        catch (Exception ex) {
            logger.error((Object)"Unknown error has occurred when getting global admin permissions.", (Throwable)ex);
            responseBuilder = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorMessage(ex));
        }
        logger.debug((Object)"Exiting getGlobalAdmins");
        return responseBuilder.build();
    }

    @GET
    @Path(value="/restrictions/{pageOrBlogId}")
    public Response getPageRestrictions(@PathParam(value="pageOrBlogId") Long pageOrBlogId, @Context UriInfo context) {
        Response.ResponseBuilder responseBuilder;
        logger.debug((Object)"Entering getPageRestrictions");
        logger.debug((Object)String.format("Executed API call: %s.", context.getRequestUri()));
        if (!this.permissionChecker.isUserAllowed().booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        try {
            logger.debug((Object)String.format("Loading the page '%s'.", pageOrBlogId));
            AbstractPage page = this.pageManager.getAbstractPage(pageOrBlogId.longValue());
            if (page == null) {
                String errorNotFound = String.format("Page '%s' not found.", pageOrBlogId);
                logger.debug((Object)errorNotFound);
                return this.getErrorResponse(Response.Status.NOT_FOUND, errorNotFound).build();
            }
            logger.debug((Object)String.format("Loading the content permission sets for page '%s'.", pageOrBlogId));
            List permissionSets = this.contentPermissionManager.getContentPermissionSets(page.getEntity(), "View");
            ArrayList<RestrictionModel> restrictions = new ArrayList<RestrictionModel>();
            for (ContentPermissionSet permissionSet : permissionSets) {
                ArrayList<UserModel> users = new ArrayList<UserModel>();
                ArrayList<GroupModel> groups = new ArrayList<GroupModel>();
                long id = permissionSet.getId();
                String type = permissionSet.getType();
                String owningContentType = "";
                String owningContentId = "";
                ContentEntityObject owningContent = permissionSet.getOwningContent();
                if (owningContent != null) {
                    owningContentType = owningContent.getType();
                    owningContentId = owningContent.getIdAsString();
                } else {
                    logger.warn((Object)String.format("The owning content of the permission set '%s' associated to the page '%s' was undefined.", permissionSet.getId(), pageOrBlogId));
                }
                for (ContentPermission contentPermission : permissionSet) {
                    if (contentPermission.isUserPermission()) {
                        ConfluenceUser user = contentPermission.getUserSubject();
                        if (user != null) {
                            users.add(SecurityResource.createUser((User)user));
                            continue;
                        }
                        logger.warn((Object)String.format("The user associated to the permission '%s' was undefined.", contentPermission.getId()));
                        continue;
                    }
                    if (!contentPermission.isGroupPermission()) continue;
                    groups.add(new GroupModel(contentPermission.getGroupName()));
                }
                RestrictionModel restriction = new RestrictionModel(id, type, owningContentType, owningContentId, users, groups);
                restrictions.add(restriction);
            }
            CollectionResultModel result = new CollectionResultModel(restrictions, 0, restrictions.size() + 1);
            this.setResultLinks(result, context, 0, restrictions.size(), false);
            responseBuilder = Response.ok(result);
        }
        catch (Exception ex) {
            logger.error((Object)"Unknown error has occurred when getting page restrictions.", (Throwable)ex);
            responseBuilder = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorMessage(ex));
        }
        logger.debug((Object)"Exiting getPageRestrictions");
        return responseBuilder.build();
    }

    private UserModel getUser(String userName, Boolean useCache) {
        logger.debug((Object)"Entering getUser");
        Preconditions.checkNotNull((Object)userName);
        UserModel result = null;
        if (useCache.booleanValue()) {
            CachedUser cachedUser = (CachedUser)this.usersCache.get((Object)userName);
            if (cachedUser != null) {
                result = cachedUser.getUser();
            }
        } else {
            result = SecurityResource.getUserModel(userName, this.userAccessor);
        }
        logger.debug((Object)"Exiting getUser");
        return result;
    }

    private static UserModel createUser(User user) {
        UserKey key;
        logger.debug((Object)"Entering createUser");
        Preconditions.checkNotNull((Object)user);
        String userName = user.getName();
        Boolean isDeactivated = false;
        String userKey = null;
        if (user instanceof ConfluenceUser && (key = ((ConfluenceUser)user).getKey()) != null) {
            userKey = key.getStringValue();
        }
        UserModel userModel = new UserModel(userKey, userName, user.getFullName(), user.getEmail(), isDeactivated);
        logger.debug((Object)"Exiting createUser");
        return userModel;
    }

    private static UserModel getUserModel(String userName, UserAccessor userAccessor) {
        logger.debug((Object)"Entering getUserModel");
        Preconditions.checkNotNull((Object)userName);
        Preconditions.checkNotNull((Object)userAccessor);
        ConfluenceUser user = userAccessor.getUserByName(userName);
        UserModel userModel = null;
        if (user != null) {
            userModel = SecurityResource.createUser((User)user);
        } else {
            logger.debug((Object)String.format("The user '%s' was not found. This user was probably deleted.", userName));
        }
        logger.debug((Object)"Exiting getUserModel");
        return userModel;
    }

    private CachedGroupPager getCachedGroupPager(String groupName) {
        logger.debug((Object)"Entering getCachedGroupPager");
        CachedGroupPager cachedGroupPager = null;
        try {
            if (this.groupMembersCache.containsKey((Object)groupName)) {
                cachedGroupPager = (CachedGroupPager)this.groupMembersCache.get((Object)groupName);
            }
        }
        catch (Exception ex) {
            logger.error((Object)String.format("Unknown error has occurred when getting the cached group page for '%s'.", groupName), (Throwable)ex);
        }
        logger.debug((Object)"Exiting getCachedGroupPager");
        return cachedGroupPager;
    }

    private Response getGroupUsers(UriInfo context, String groupName, boolean useCache, int offset, int limit) {
        Response.ResponseBuilder responseBuilder;
        logger.debug((Object)"Entering getGroupUsers");
        logger.debug((Object)String.format("Executed API call: %s.", context.getRequestUri()));
        if (!this.permissionChecker.isUserAllowed().booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        try {
            Pager<String> membersPager;
            Group group;
            ArrayList<UserModel> users = new ArrayList<UserModel>();
            logger.debug((Object)String.format("Loading the group '%s'.", groupName));
            CachedGroupPager cachedGroupPager = null;
            if (useCache) {
                cachedGroupPager = this.getCachedGroupPager(groupName);
            }
            if (cachedGroupPager != null) {
                logger.debug((Object)String.format("Using the cached entry for the group '%s'.", groupName));
                group = cachedGroupPager.getGroup();
            } else {
                group = this.groupManager.getGroup(groupName);
            }
            if (group == null) {
                String errorNotFound = String.format("Group '%s' not found.", groupName);
                logger.debug((Object)errorNotFound);
                return this.getErrorResponse(Response.Status.NOT_FOUND, errorNotFound).build();
            }
            logger.debug((Object)String.format("Getting members the group '%s'.", groupName));
            if (cachedGroupPager != null && cachedGroupPager.getCurrentOffset() == offset) {
                logger.debug((Object)String.format("Using the cached entry for the group members pager '%s' (offset: '%s').", groupName, offset));
                membersPager = cachedGroupPager.getMembersPager();
            } else {
                membersPager = this.groupManager.getMemberNames(group);
                membersPager.skipTo(offset);
            }
            for (String userName : membersPager) {
                UserModel user = this.getUser(userName, useCache);
                if (user == null) {
                    logger.warn((Object)String.format("The user '%s' associated to the group '%s' was not found.", userName, groupName));
                    continue;
                }
                users.add(user);
                if (users.size() != limit) continue;
                break;
            }
            logger.debug((Object)String.format("The batch of members was retrieved for the group '%s'.", groupName));
            int nextOffset = offset + limit;
            logger.debug((Object)String.format("Adding the members pager in the cache for the group '%s' (offset: %s).", groupName, nextOffset));
            if (useCache) {
                this.groupMembersCache.put((Object)groupName, (Object)new CachedGroupPager(group, membersPager, nextOffset));
            }
            CollectionResultModel result = new CollectionResultModel(users, offset, limit);
            this.setResultLinks(result, context, offset, limit, membersPager.iterator().hasNext());
            responseBuilder = Response.ok(result);
        }
        catch (Exception ex) {
            logger.error((Object)"Unknown error has occurred when getting group users.", (Throwable)ex);
            responseBuilder = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorMessage(ex));
        }
        logger.debug((Object)"Exiting getGroupUsers");
        return responseBuilder.build();
    }

    private CollectionResultModel<GlobalSpacePermissionModel> createSpacePermissionsCollectionModel(UriInfo context, List<SpacePermission> spacePermissions, List<String> targetPermissionTypes) throws MalformedURLException, IllegalArgumentException, UriBuilderException {
        ArrayList<GlobalSpacePermissionModel> permissionCollection = new ArrayList<GlobalSpacePermissionModel>();
        for (SpacePermission spacePermission : spacePermissions) {
            if (!targetPermissionTypes.isEmpty() && !targetPermissionTypes.contains(spacePermission.getType())) continue;
            UserModel user = null;
            GroupModel group = null;
            if (spacePermission.isUserPermission()) {
                ConfluenceUser confluenceUser = spacePermission.getUserSubject();
                if (confluenceUser != null) {
                    user = SecurityResource.createUser((User)confluenceUser);
                } else {
                    logger.warn((Object)String.format("The user associated to the permission '%s' was undefined.", spacePermission.getId()));
                }
            }
            if (spacePermission.isGroupPermission()) {
                group = new GroupModel(spacePermission.getGroup());
            }
            GlobalSpacePermissionModel curPermissionModel = new GlobalSpacePermissionModel(spacePermission.getId(), spacePermission.getType(), spacePermission.isAnonymousPermission(), user, group);
            permissionCollection.add(curPermissionModel);
        }
        CollectionResultModel<GlobalSpacePermissionModel> result = new CollectionResultModel<GlobalSpacePermissionModel>(permissionCollection, 0, permissionCollection.size() + 1);
        this.setResultLinks(result, context, 0, permissionCollection.size(), false);
        return result;
    }

    private class UserCacheLoader
    implements CacheLoader<String, CachedUser> {
        private final UserAccessor userAccessor;

        public UserCacheLoader(UserAccessor userAccessor) {
            this.userAccessor = (UserAccessor)Preconditions.checkNotNull((Object)userAccessor);
        }

        public CachedUser load(@Nonnull String userName) {
            logger.debug((Object)String.format("The user '%s' is not cached and it will be loaded.", userName));
            UserModel cachedUser = SecurityResource.getUserModel(userName, this.userAccessor);
            return new CachedUser(cachedUser);
        }
    }

    private class GroupCacheLoader
    implements CacheLoader<String, CachedGroupPager> {
        private GroupCacheLoader() {
        }

        public CachedGroupPager load(@Nonnull String groupName) {
            return null;
        }
    }
}

