/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.confluence.plugin.resources;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.coveo.confluence.plugin.helper.PermissionChecker;
import com.coveo.confluence.plugin.incremental.ItemCollection;
import com.coveo.confluence.plugin.incremental.ItemEvent;
import com.coveo.confluence.plugin.incremental.ItemEventService;
import com.coveo.confluence.plugin.incremental.ItemEventServiceImpl;
import com.coveo.confluence.plugin.model.CollectionResultModel;
import com.coveo.confluence.plugin.model.ItemEventModel;
import com.coveo.confluence.plugin.resources.BaseResource;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="/incremental")
@Produces(value={"application/json"})
public class IncrementalResource
extends BaseResource {
    private static final Logger logger = Logger.getLogger(IncrementalResource.class);
    private final String EVENT_ITEM_TYPE_PARAMETER = "type";
    private final String EVENT_SPACE_PARAMETER = "space";
    private final String EVENT_SPACE_ITEM_TYPE = "space";
    private final String EVENT_IGNORE_OLDER_THAN_PARAMETER = "ignoreOlderThan";
    private final ItemEventService itemEventService;
    private final PermissionChecker permissionChecker;

    public IncrementalResource(ItemEventService itemEventService, PermissionManager permissionManager, SpaceManager spaceManager, UserAccessor userAccessor) {
        logger.debug((Object)"Entering IncrementalResource");
        this.itemEventService = (ItemEventService)Preconditions.checkNotNull((Object)itemEventService);
        this.permissionChecker = new PermissionChecker((PermissionManager)Preconditions.checkNotNull((Object)permissionManager), (SpaceManager)Preconditions.checkNotNull((Object)spaceManager), (UserAccessor)Preconditions.checkNotNull((Object)userAccessor));
        logger.debug((Object)"Exiting IncrementalResource");
    }

    @GET
    @Path(value="/changes")
    public Response getChanges(@QueryParam(value="type") String itemType, @QueryParam(value="space") String spaceKey, @QueryParam(value="ignoreOlderThan") long ignoreOlderThan, @DefaultValue(value="0") @QueryParam(value="start") int offset, @DefaultValue(value="100") @QueryParam(value="limit") int limit, @Context UriInfo context) {
        Response.ResponseBuilder responseBuilder;
        logger.debug((Object)"Entering getChanges");
        logger.debug((Object)String.format("Executed API call: %s.", context.getRequestUri()));
        if (!this.permissionChecker.isUserAllowed().booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        if (spaceKey == null || spaceKey.isEmpty()) {
            return this.getBadRequestErrorResponse("The query parameter space key must be specified.").build();
        }
        if (!this.permissionChecker.checkUserCanViewSpace(spaceKey).booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        String allEventTypes = String.join((CharSequence)",", ItemEventServiceImpl.SUPPORTED_EVENTS);
        try {
            CollectionResultModel<ItemEventModel> result = this.getItemEvents(itemType, spaceKey, ignoreOlderThan, allEventTypes, offset, limit, context);
            responseBuilder = Response.ok(result);
        }
        catch (Exception ex) {
            logger.error((Object)"Unknown error has occurred when getting items.", (Throwable)ex);
            responseBuilder = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorMessage(ex));
        }
        logger.debug((Object)"Exiting getChanges");
        return responseBuilder.build();
    }

    @GET
    @Path(value="/deletedSpaces")
    public Response getDeletedSpaces(@QueryParam(value="ignoreOlderThan") long ignoreOlderThan, @DefaultValue(value="0") @QueryParam(value="start") int offset, @DefaultValue(value="100") @QueryParam(value="limit") int limit, @Context UriInfo context) {
        Response.ResponseBuilder responseBuilder;
        logger.debug((Object)"Entering getDeletedSpaces");
        logger.debug((Object)String.format("Executed API call: %s.", context.getRequestUri()));
        if (!this.permissionChecker.isUserAllowed().booleanValue()) {
            return this.getUnauthorizedErrorResponse().build();
        }
        try {
            CollectionResultModel<ItemEventModel> result = this.getItemEvents("space", "", ignoreOlderThan, "deleted", offset, limit, context);
            responseBuilder = Response.ok(result);
        }
        catch (Exception ex) {
            logger.error((Object)"Unknown error has occurred when getting deleted space items.", (Throwable)ex);
            responseBuilder = this.getErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, this.getErrorMessage(ex));
        }
        logger.debug((Object)"Exiting getDeletedSpaces");
        return responseBuilder.build();
    }

    private CollectionResultModel<ItemEventModel> getItemEvents(String itemType, String spaceKey, long ignoreOlderThan, String eventType, int offset, int limit, UriInfo context) throws MalformedURLException, IllegalArgumentException, UriBuilderException {
        logger.debug((Object)"Entering getItemEvents");
        Preconditions.checkArgument((eventType != null && !eventType.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)context);
        ItemCollection<ItemEvent> eventsCollection = this.itemEventService.getEvents(eventType, itemType, spaceKey, ignoreOlderThan, limit, offset);
        ArrayList<ItemEventModel> eventsResult = new ArrayList<ItemEventModel>();
        for (ItemEvent event : eventsCollection.getResults()) {
            eventsResult.add(new ItemEventModel(event.getID(), event.getItemId(), event.getItemType(), event.getEventDate(), event.getEventType(), event.getItemVersionId(), event.getSpaceKey(), event.getOldSpaceKey(), event.getItemUrl()));
        }
        CollectionResultModel<ItemEventModel> result = new CollectionResultModel<ItemEventModel>(eventsResult, offset, limit);
        boolean hasMoreEvents = offset + limit < eventsCollection.getTotal();
        this.setResultLinks(result, context, offset, limit, hasMoreEvents);
        logger.debug((Object)"Exiting getItemEvents");
        return result;
    }
}

