/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.confluence.plugin.incremental;

import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.event.events.space.SpaceEvent;
import com.atlassian.confluence.event.events.types.Removed;
import com.atlassian.confluence.event.events.types.Trashed;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.coveo.confluence.plugin.incremental.ItemEventService;
import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;

public class IncrementalEventListener
implements DisposableBean {
    private static final Logger logger = Logger.getLogger(IncrementalEventListener.class);
    private final EventPublisher eventPublisher;
    private final ItemEventService itemEventService;

    public IncrementalEventListener(EventPublisher eventPublisher, ItemEventService itemEventService) {
        logger.debug((Object)"Entering IncrementalEventListener");
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.itemEventService = (ItemEventService)Preconditions.checkNotNull((Object)itemEventService);
        eventPublisher.register((Object)this);
        logger.debug((Object)"Exiting IncrementalEventListener");
    }

    @EventListener
    public void spaceEvent(SpaceEvent event) {
        logger.debug((Object)"Entering spaceEvent");
        try {
            if (event instanceof Removed || event instanceof Trashed) {
                this.itemEventService.add(event);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"An error has occurred on Space event processing", (Throwable)ex);
        }
        logger.debug((Object)"Exiting spaceEvent");
    }

    @EventListener
    public void contentEvent(ContentEvent event) {
        logger.debug((Object)"Entering contentEvent");
        try {
            ContentPermissionEvent contentPermissionEvent;
            ContentPermission contentPermission;
            if (event instanceof Removed || event instanceof Trashed || event instanceof PageMoveEvent || event instanceof BlogPostMovedEvent || event instanceof PageRestoreEvent || event instanceof BlogPostRestoreEvent || event instanceof CommentEvent) {
                this.itemEventService.add(event);
            } else if (event instanceof ContentPermissionEvent && (contentPermission = (contentPermissionEvent = (ContentPermissionEvent)event).getContentPermission()) != null && contentPermission.getType() == "View") {
                this.itemEventService.add(event);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"An error has occurred on Content event processing", (Throwable)ex);
        }
        logger.debug((Object)"Exiting contentEvent");
    }

    public void destroy() throws Exception {
        logger.debug((Object)"Entering destroy");
        this.eventPublisher.unregister((Object)this);
        logger.debug((Object)"Exiting destroy");
    }
}

