/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.confluence.plugin.helper;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.log4j.Logger;

public class PermissionChecker {
    private static final Logger logger = Logger.getLogger(PermissionChecker.class);
    public static final String COVEO_CONNECTOR_PLUGIN_USERS_GROUP_NAME = "coveo-connector-plugin-users";
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;

    public PermissionChecker(PermissionManager permissionManager, SpaceManager spaceManager, UserAccessor userAccessor) {
        logger.debug((Object)"Entering PermissionChecker");
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.spaceManager = (SpaceManager)Preconditions.checkNotNull((Object)spaceManager);
        this.userAccessor = (UserAccessor)Preconditions.checkNotNull((Object)userAccessor);
        logger.debug((Object)"Entering PermissionChecker");
    }

    public Boolean isUserAllowed() {
        logger.debug((Object)"Entering isUserAllowed");
        boolean isUserAllowed = this.checkUserIsMemberOfCoveoConnectorPluginUsersGroup() != false || this.checkUserIsAdmin() != false;
        logger.debug((Object)"Exiting isUserAllowed");
        return isUserAllowed;
    }

    public Boolean checkUserCanViewSpace(String spaceKey) {
        Space specificSpace;
        logger.debug((Object)"Entering checkUserCanViewSpace");
        Boolean canView = false;
        ConfluenceUser currentUser = this.getCurrentUser();
        if (currentUser != null && (specificSpace = this.spaceManager.getSpace(spaceKey)) != null) {
            canView = this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)specificSpace);
        }
        logger.debug((Object)"Exiting checkUserCanViewSpace");
        return canView;
    }

    private Boolean checkUserIsAdmin() {
        logger.debug((Object)"Entering checkUserIsAdmin");
        Boolean isAdmin = false;
        ConfluenceUser currentUser = this.getCurrentUser();
        if (currentUser != null) {
            isAdmin = this.permissionManager.hasPermission((User)currentUser, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
        }
        logger.debug((Object)"Exiting checkUserIsAdmin");
        return isAdmin;
    }

    private Boolean checkUserIsMemberOfCoveoConnectorPluginUsersGroup() {
        logger.debug((Object)"Entering checkUserIsMemberOfCoveoConnectorPluginUsersGroup");
        Boolean canView = false;
        ConfluenceUser currentUser = this.getCurrentUser();
        if (currentUser != null) {
            List userGroups = this.userAccessor.getGroupNames((User)currentUser);
            canView = userGroups.contains(COVEO_CONNECTOR_PLUGIN_USERS_GROUP_NAME);
        }
        logger.debug((Object)"Exiting checkUserIsMemberOfCoveoConnectorPluginUsersGroup");
        return canView;
    }

    private ConfluenceUser getCurrentUser() {
        logger.debug((Object)"Entering getCurrentUser");
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        logger.debug((Object)"Exiting getCurrentUser");
        return currentUser;
    }
}

