/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;

requirejs(['cw', 'jquery'], function (CW, $) {

    /**
     * Just search in the DOM for the right panel present in Confluence Dashboard, call to DocumentActionsDashboard view action
     * and prepend the rendered velocity template in the right panel.
     */
    CW.toInit(function () {
        if ($("#isDocActionsEnabled").val() === "false") {
            return;
        }
        if ($(".awpdashboard").length == 1) {
            return;
        }
        var rightPanel = $("table.dashboard td.right div.padded:first");
        if (rightPanel.length == 0) {
            rightPanel = jQuery(".dashboard-group.right div:first");
            if (rightPanel.length == 0) {
                rightPanel = jQuery("div.welcome-message");  // Confluence 5.9+ Dashboard
                if (rightPanel.length == 0) {
                    return;
                }
            }
        }

        const iframeDiv = $('<div>').attr('id', 'cw-documentactions-user-dashboard');

        rightPanel.prepend(iframeDiv);

        var DocumentActionsDashboardIframe = new CW.iframe({
            id: 'DocumentActionsDashboardIframe',
            url: '/documentactions/components/Dashboard',
            width: '100%',
            height: '100%'
        });

        $('#cw-documentactions-user-dashboard').html(DocumentActionsDashboardIframe.render());

    })
});
