/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.links.linktypes.AbstractContentEntityLink;
import com.atlassian.confluence.spaces.Space;
import java.util.Collection;
import org.randombits.confluence.filtering.criteria.AutowiredCriterion;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.criteria.SourceCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelCriterion
extends AutowiredCriterion
implements SourceCriterion<ContentEntityObject> {
    private ParsedLabelName labelName;
    private LabelManager labelManager;

    public LabelCriterion(ParsedLabelName labelName) {
        this.labelName = labelName;
    }

    public LabelCriterion(String labelName) {
        this(LabelParser.parse((String)labelName));
    }

    @Override
    public boolean matches(Object object) {
        if (object instanceof AbstractContentEntityLink) {
            object = ((AbstractContentEntityLink)object).getDestinationContent();
        }
        if (object instanceof Space) {
            object = ((Space)object).getDescription();
        }
        if (object instanceof Labelable) {
            Labelable labelable = (Labelable)object;
            Label label = this.getLabel();
            if (label != null) {
                return labelable.getLabels().contains(label);
            }
        }
        return false;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public String toString() {
        return "{has label: " + (this.labelName.getPrefix() != null ? this.labelName.getPrefix() + ":" : "") + this.labelName.getName() + "}";
    }

    @Override
    public Collection<ContentEntityObject> getMatchingValues() {
        Label label = this.getLabel();
        if (label != null) {
            return this.labelManager.getContent(label);
        }
        return null;
    }

    private Label getLabel() {
        return this.labelManager.getLabel(this.labelName);
    }

    @Override
    public SourceCriterion.Weight getWeight() {
        Label label = this.getLabel();
        if (label != null) {
            int count = this.labelManager.getContentCount(label);
            if (count < 10) {
                return SourceCriterion.Weight.LIGHT;
            }
            if (count < 100) {
                return SourceCriterion.Weight.MEDIUM;
            }
            return SourceCriterion.Weight.HEAVY;
        }
        return SourceCriterion.Weight.LIGHT;
    }

    public static class Interpreter
    implements CriterionInterpreter {
        public Criterion createCriterion(String value) {
            return new LabelCriterion(value);
        }
    }
}

