/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.translator.domain;

import com.comalatech.confluence.translator.domain.CloudTranslation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ServerWorkflow {
    private static final String STATE = "state";
    private static final String APPROVAL = "approval";
    private static final String STATES = "states";
    private static final String UNSUPPORTED_ELEMENTS = "unsupportedElements";
    private static final String UNSUPPORTED_PARAMETERS = "unsupportedParameters";
    private static final String CONTENT_TYPES = "contentTypes";
    private static final String DISPLAY_PROGRESS_TRACKER = "displayProgressTracker";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String COLOUR = "colour";
    private static final String FINAL = "final";
    private static final String DUE_DATE = "dueDate";
    private static final String TRANSITIONS = "transitions";
    private static final String APPROVALS = "approvals";
    private static final String SUBMIT = "submit";
    private static final String SELECT = "select";
    private static final String WORKFLOW = "workflow";
    private static final String LABEL = "label";
    private static final String PARAMETERS = "parameters";
    private static final String EDITABLE = "editable";
    private static final String TYPE = "type";
    private static final String LIST = "list";
    private static final String OPTIONS = "options";
    private static final String VALUE = "value";
    private static final String APPROVE_LABEL = "approveLabel";
    private static final String REJECT_LABEL = "rejectLabel";
    private static final String MINIMUM = "minimum";
    private static final String CREDENTIALS = "credentials";
    private static final String ASSIGNABLE = "assignable";
    private static final String USERS = "users";
    private static final String GROUPS = "groups";
    private static final String SELECTED_APPROVER = "selectedApprover";
    private static final String SELECTED_APPROVERS = "selectedApprovers";
    private static final String USER_PASSWORD = "user+password";
    private static final String PREASSIGNED_USERS = "preassignedUsers";
    private static final String ITEMS = "items";
    private static final String PREASSIGNED_GROUPS = "preassignedGroups";
    private static final String CONDITIONS = "conditions";
    private static final Set<String> ROOT_ELEMENTS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("active", "blobTriggers", "key"));
    private static final Set<String> APPROVAL_PARAMETERS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("visibleContentTypes", "conditions"));
    private static final Set<String> WORKFLOW_UNSUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("adminUsers", "invertLabels", "labels", "stickyLabels", "updateStatus", "hasLabel", "label"));
    private static final Set<String> WORKFLOW_UNSUPPORTED_SPECIAL_PARAMETERS = new HashSet<String>(Arrays.asList("contentTypes", "displayProgressTracker"));
    private static final Set<String> ROOT_SUPPORTED_ELEMENTS = new HashSet<String>(Arrays.asList("name", "description", "states", "parameters"));
    private static final Set<String> STATE_SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("name", "description", "colour", "final", "dueDate", "transitions", "approvals"));
    private static final Set<String> APPROVAL_SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("name", "approveLabel", "rejectLabel", "minimum", "credentials", "assignable", "users", "groups", "selectedApprover", "selectedApprovers", "preassignedUsers", "preassignedGroups"));
    private static final Map<String, String> UNSUPPORTED_KEYS_DICTIONARY = new HashMap<String, String>(){
        {
            this.put("pageFooter", "pagefooter");
            this.put("instructions", "workflow-instructions");
            this.put("readAck", "read-ack");
            this.put("triggers", "trigger");
            this.put("changeDueDate", "changeduedate");
            this.put("hideFromPath", "hidefrompath");
            this.put(ServerWorkflow.CONTENT_TYPES, "content");
            this.put("hideSelection", "hideselection");
            this.put(ServerWorkflow.DISPLAY_PROGRESS_TRACKER, "progresstracker");
            this.put("versionsCompleted", "versionscompleted");
            this.put("pageHeader", "pageheader");
            this.put("hasLabel", "haslabel");
            this.put("tasks", "task");
            this.put("labels", ServerWorkflow.LABEL);
            this.put("invertLabels", "invertlabel");
            this.put("adminUsers", "adminusers");
            this.put("stickyLabels", "stickylabels");
            this.put("updateStatus", "updatestatus");
            this.put("rememberAssignees", "rememberassignees");
            this.put("allowedAssignGroups", "allowedassigngroups");
            this.put("allowedAssignUsers", "allowedassignusers");
        }
    };
    private final Map<String, Object> workflow;

    public CloudTranslation toCloud() {
        Set<Object> unsupportedParameters = this.getUnsupportedParameters();
        Set<Object> rootUnsupportedElements = this.getRootUnsupportedElements();
        HashMap<String, Object> cloudWorkflow = new HashMap<String, Object>();
        ServerWorkflow.addName(this.workflow, cloudWorkflow);
        ServerWorkflow.addDescription(this.workflow, cloudWorkflow);
        Collection parameters = (Collection)this.workflow.get(PARAMETERS);
        if (null != parameters) {
            cloudWorkflow.put(PARAMETERS, this.getCloudParameters(parameters));
        }
        cloudWorkflow.put(STATES, this.getCloudStates(unsupportedParameters));
        CloudTranslation cloudTranslation = CloudTranslation.builder().workflow(cloudWorkflow).messages(new HashMap<String, Set<Object>>()).build();
        if (!rootUnsupportedElements.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(rootUnsupportedElements);
            cloudTranslation.addErrors(UNSUPPORTED_ELEMENTS, rootUnsupportedElements);
        }
        if (!unsupportedParameters.isEmpty()) {
            cloudTranslation.addErrors(UNSUPPORTED_PARAMETERS, unsupportedParameters);
        }
        return cloudTranslation;
    }

    private List<Map<String, Object>> getCloudParameters(Collection<?> parameters) {
        return parameters.parallelStream().map(e -> (Map)e).map(parameter -> {
            String options;
            HashMap<String, Object> cloudParameter = new HashMap<String, Object>();
            ServerWorkflow.addName(parameter, cloudParameter);
            ServerWorkflow.addDescription(parameter, cloudParameter);
            cloudParameter.put(EDITABLE, true);
            String type = (String)parameter.get(TYPE);
            if (null != type) {
                cloudParameter.put(TYPE, LIST.equals(type) ? OPTIONS : type);
            }
            cloudParameter.put(LABEL, parameter.get(NAME));
            String value = (String)parameter.get(VALUE);
            if (null != value) {
                cloudParameter.put(VALUE, value);
            }
            if (null != (options = (String)parameter.get(OPTIONS))) {
                cloudParameter.put(OPTIONS, options);
            }
            return cloudParameter;
        }).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getCloudStates(Set<Object> unsupportedParameters) {
        Set<Object> statesUnsupportedParameters = Collections.synchronizedSet(new HashSet());
        Set<Object> approvalsUnsupportedParameters = Collections.synchronizedSet(new HashSet());
        Collection states = (Collection)this.workflow.get(STATES);
        if (states == null) {
            return new ArrayList<Map<String, Object>>();
        }
        List<Map<String, Object>> cloudStates = states.parallelStream().map(e -> (Map)e).map(state -> {
            Object approvals;
            Object transitions;
            String dueDate;
            statesUnsupportedParameters.addAll(state.keySet().parallelStream().filter(e -> !STATE_SUPPORTED_PARAMETERS.contains(e)).collect(Collectors.toSet()));
            HashMap<String, Object> cloudState = new HashMap<String, Object>();
            ServerWorkflow.addName(state, cloudState);
            ServerWorkflow.addDescription(state, cloudState);
            cloudState.put(COLOUR, state.get(COLOUR));
            Boolean isFinal = (Boolean)state.get(FINAL);
            if (null != isFinal) {
                cloudState.put(FINAL, isFinal);
            }
            if (null != (dueDate = (String)state.get(DUE_DATE))) {
                cloudState.put(DUE_DATE, dueDate);
            }
            if (null != (transitions = state.get(TRANSITIONS))) {
                Map cloudTransitions = (Map)transitions;
                if (cloudTransitions.containsKey(SUBMIT)) {
                    cloudTransitions.put(SELECT, (String)cloudTransitions.get(SUBMIT));
                    cloudTransitions.remove(SUBMIT);
                    cloudState.put(TRANSITIONS, cloudTransitions);
                } else {
                    cloudState.put(TRANSITIONS, transitions);
                }
            }
            if (null != (approvals = state.get(APPROVALS))) {
                List<Map<String, Object>> cloudApprovals = ServerWorkflow.getCloudApprovals(approvalsUnsupportedParameters, (Collection)approvals);
                cloudState.put(APPROVALS, cloudApprovals);
            }
            return cloudState;
        }).collect(Collectors.toList());
        if (!statesUnsupportedParameters.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(statesUnsupportedParameters);
            unsupportedParameters.add(Collections.singletonMap(STATE, statesUnsupportedParameters));
        }
        if (!approvalsUnsupportedParameters.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(approvalsUnsupportedParameters);
            unsupportedParameters.add(Collections.singletonMap(APPROVAL, approvalsUnsupportedParameters));
        }
        return cloudStates;
    }

    private static List<Map<String, Object>> getCloudApprovals(Set<Object> approvalsUnsupportedParameters, Collection<?> approvals) {
        return approvals.parallelStream().map(e -> (Map)e).map(approval -> {
            Boolean assignable;
            String credentials;
            String minimum;
            String rejectLabel;
            String approveLabel;
            HashMap<String, Object> cloudApproval = new HashMap<String, Object>();
            approvalsUnsupportedParameters.addAll(approval.entrySet().parallelStream().filter(entry -> !APPROVAL_SUPPORTED_PARAMETERS.contains(entry.getKey())).filter(entry -> !APPROVAL_PARAMETERS_TO_BE_IGNORED.contains(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet()));
            ServerWorkflow.addName(approval, cloudApproval);
            List conditions = (List)approval.get(CONDITIONS);
            if (null != conditions) {
                approvalsUnsupportedParameters.addAll(conditions.parallelStream().map(e -> (Map)e).map(e -> e.get(TYPE)).collect(Collectors.toSet()));
            }
            if (null != (approveLabel = (String)approval.get(APPROVE_LABEL))) {
                cloudApproval.put(APPROVE_LABEL, approveLabel);
            }
            if (null != (rejectLabel = (String)approval.get(REJECT_LABEL))) {
                cloudApproval.put(REJECT_LABEL, rejectLabel);
            }
            if (null != (minimum = (String)approval.get(MINIMUM)) && !"1".equals(minimum)) {
                cloudApproval.put(MINIMUM, minimum);
            }
            if (null != (credentials = (String)approval.get(CREDENTIALS))) {
                cloudApproval.put(CREDENTIALS, USER_PASSWORD);
            }
            if (null != (assignable = (Boolean)approval.get(ASSIGNABLE)) && assignable.booleanValue()) {
                cloudApproval.put(ASSIGNABLE, true);
            }
            ServerWorkflow.addPreassignedUsers(approval, cloudApproval);
            ServerWorkflow.addPreassignedGroups(approval, cloudApproval);
            return cloudApproval;
        }).collect(Collectors.toList());
    }

    private Set<Object> getRootUnsupportedElements() {
        return this.workflow.keySet().parallelStream().filter(e -> !ROOT_SUPPORTED_ELEMENTS.contains(e)).filter(e -> !ROOT_ELEMENTS_TO_BE_IGNORED.contains(e)).filter(e -> !WORKFLOW_UNSUPPORTED_PARAMETERS.contains(e)).filter(e -> !WORKFLOW_UNSUPPORTED_SPECIAL_PARAMETERS.contains(e)).collect(Collectors.toSet());
    }

    private Set<Object> getUnsupportedParameters() {
        Set<Object> unsupportedParametersKeys = this.workflow.entrySet().parallelStream().filter(ServerWorkflow::isUnsupportedParameter).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!this.workflow.containsKey(DISPLAY_PROGRESS_TRACKER)) {
            unsupportedParametersKeys.add(DISPLAY_PROGRESS_TRACKER);
        }
        HashSet<Object> unsupportedParameters = new HashSet<Object>();
        if (!unsupportedParametersKeys.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(unsupportedParametersKeys);
            unsupportedParameters.add(Collections.singletonMap(WORKFLOW, unsupportedParametersKeys));
        }
        return unsupportedParameters;
    }

    private static boolean isUnsupportedParameter(Map.Entry<String, Object> entry) {
        return CONTENT_TYPES.equals(entry.getKey()) && ((List)entry.getValue()).size() != 2 || WORKFLOW_UNSUPPORTED_PARAMETERS.contains(entry.getKey());
    }

    private static void convertKeysToMarkupStyle(Set<Object> unsupported) {
        UNSUPPORTED_KEYS_DICTIONARY.keySet().parallelStream().forEach(key -> {
            if (unsupported.contains(key)) {
                unsupported.remove(key);
                unsupported.add(UNSUPPORTED_KEYS_DICTIONARY.get(key));
            }
        });
    }

    private static void addName(Map<String, Object> source, Map<String, Object> target) {
        target.put(NAME, source.get(NAME));
    }

    private static void addDescription(Map<String, Object> source, Map<String, Object> target) {
        String description = (String)source.get(DESCRIPTION);
        if (null != description) {
            target.put(DESCRIPTION, description);
        }
    }

    private static void addPreassignedUsers(Map<String, Object> source, Map<String, Object> target) {
        Map selectedApprovers;
        Map selectedApprover;
        Map users;
        HashMap preassignedUsersMap = new HashMap();
        HashSet usersSet = new HashSet();
        Map preassignedUsers = (Map)source.get(PREASSIGNED_USERS);
        if (null != preassignedUsers) {
            usersSet.addAll(((List)preassignedUsers.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (null != (users = (Map)source.get(USERS))) {
            usersSet.addAll(((List)users.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (null != (selectedApprover = (Map)source.get(SELECTED_APPROVER))) {
            usersSet.addAll(((List)selectedApprover.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (null != (selectedApprovers = (Map)source.get(SELECTED_APPROVERS))) {
            usersSet.addAll(((List)selectedApprovers.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (!usersSet.isEmpty()) {
            preassignedUsersMap.put(ITEMS, usersSet);
            target.put(PREASSIGNED_USERS, preassignedUsersMap);
        }
    }

    private static void addPreassignedGroups(Map<String, Object> source, Map<String, Object> target) {
        Map groups;
        HashMap preassignedGroupsMap = new HashMap();
        HashSet groupsSet = new HashSet();
        Map preassignedGroups = (Map)source.get(PREASSIGNED_GROUPS);
        if (null != preassignedGroups) {
            groupsSet.addAll(((List)preassignedGroups.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (null != (groups = (Map)source.get(GROUPS))) {
            groupsSet.addAll(((List)groups.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (!groupsSet.isEmpty()) {
            preassignedGroupsMap.put(ITEMS, groupsSet);
            target.put(PREASSIGNED_GROUPS, preassignedGroupsMap);
        }
    }

    ServerWorkflow(Map<String, Object> workflow) {
        this.workflow = workflow;
    }

    public static ServerWorkflowBuilder builder() {
        return new ServerWorkflowBuilder();
    }

    public static class ServerWorkflowBuilder {
        private Map<String, Object> workflow;

        ServerWorkflowBuilder() {
        }

        public ServerWorkflowBuilder workflow(Map<String, Object> workflow) {
            this.workflow = workflow;
            return this;
        }

        public ServerWorkflow build() {
            return new ServerWorkflow(this.workflow);
        }

        public String toString() {
            return "ServerWorkflow.ServerWorkflowBuilder(workflow=" + this.workflow + ")";
        }
    }
}

