/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.provider;

import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryScope;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import com.comalatech.confluence.documentActivity.service.provider.AbstractActivityProvider;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import java.util.List;

public abstract class AbstractPageActivityProvider<T>
extends AbstractActivityProvider {
    protected final ContentEntityManager contentEntityManager;
    protected List<ActionType.Type> excludingTypes;
    protected ActionType.Type activityType;
    protected List<ActionType.Subtype> activitySubtypes;

    public AbstractPageActivityProvider(ContentEntityManager contentEntityManager, ActorUtils actorUtils) {
        super(actorUtils);
        this.contentEntityManager = contentEntityManager;
    }

    protected abstract boolean matchesFilters(T var1, InternalDocumentActivityQuery var2);

    protected ContentEntityObject getContent(InternalDocumentActivityQuery query) {
        DocumentActivityQueryScope scope = ((InternalDocumentActivityQueryFilter)query.getFilters()).getScope();
        if (scope == null) {
            throw new IllegalArgumentException("Missing mandatory scope filter");
        }
        if (scope.getSpaceKeys() != null && !scope.getSpaceKeys().isEmpty()) {
            throw new IllegalArgumentException("This type of query does not allow selecting spaces");
        }
        if (scope.getPageIds().size() > 1) {
            throw new IllegalArgumentException("This type of query is intended for an scope of only one page");
        }
        if (scope.getPageIds() == null || scope.getPageIds().isEmpty()) {
            throw new IllegalArgumentException("Missing mandatory scope filter");
        }
        ContentEntityObject ceo = this.contentEntityManager.getById(scope.getPageIds().get(0).longValue());
        if (ceo == null) {
            throw new NotFoundException("There is no content entity with this id: " + scope.getPageIds().get(0));
        }
        return ceo;
    }

    @Override
    public boolean shouldApply(InternalDocumentActivityQuery query) {
        InternalDocumentActivityQueryFilter filters = (InternalDocumentActivityQueryFilter)query.getFilters();
        return filters == null || (filters.getParticipants() == null || filters.getParticipants().isEmpty()) && (filters.getStateNames() == null || filters.getStateNames().isEmpty()) && this.matchTypeAndSubtype(filters, this.activityType, this.activitySubtypes);
    }

    private boolean matchTypeAndSubtype(InternalDocumentActivityQueryFilter filters, ActionType.Type type, List<ActionType.Subtype> subtypes) {
        return filters.getTypes() == null || filters.getTypes().stream().anyMatch(types -> {
            boolean applied = types.getType().equals(type.getValue());
            if (subtypes != null && !subtypes.isEmpty() && types.getSubtypes() != null && !types.getSubtypes().isEmpty()) {
                applied = applied && types.getSubtypes().stream().anyMatch(subtype -> subtypes.contains((Object)ActionType.Subtype.fromString(subtype)));
            }
            return applied;
        });
    }
}

