/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.approval;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.events.BlogPostApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.PageApprovalApproveEvent;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.workflow.model.SignatureType;
import com.google.gson.Gson;
import java.util.ArrayList;

public class ApprovalApprovedMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public ApprovalApprovedMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageApprovalApproveEvent) {
            PageApprovalApproveEvent pageApprovalApproveEvent = (PageApprovalApproveEvent)event;
            return this.buildActivity(pageApprovalApproveEvent.getAbstractPage(), pageApprovalApproveEvent.getState(), pageApprovalApproveEvent.getApprovalCheck(), pageApprovalApproveEvent.getApprovalCheck().getLastApprover(), pageApprovalApproveEvent.isPartial());
        }
        if (event instanceof BlogPostApprovalApproveEvent) {
            BlogPostApprovalApproveEvent blogPostApprovalApproveEvent = (BlogPostApprovalApproveEvent)event;
            return this.buildActivity(blogPostApprovalApproveEvent.getAbstractPage(), blogPostApprovalApproveEvent.getState(), blogPostApprovalApproveEvent.getApprovalCheck(), blogPostApprovalApproveEvent.getApprovalCheck().getLastApprover(), blogPostApprovalApproveEvent.isPartial());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, ApprovalCheck approvalCheck, Approver approver, boolean isPartial) {
        Action action;
        Actor actor = this.actorUtils.buildActor(approver.getPerformer());
        ActionDetails details = this.getApprovalActivityDetails(state, approvalCheck, approver);
        if (!isPartial) {
            details.addDetail(ActionDetailType.APPROVAL_TIME_LAPSED, String.valueOf(approver.getDate().getTime() - state.getDate().getTime()));
            this.addRequiredApprovers(approvalCheck, details);
            this.addApprovers(approvalCheck, details);
            action = new Action(new ActionType(ActionType.Type.APPROVAL, ActionType.Subtype.APPROVAL_FULLY_APPROVED), actor, details);
        } else {
            action = new Action(new ActionType(ActionType.Type.APPROVAL, ActionType.Subtype.APPROVAL_APPROVED), actor, details);
        }
        return new Activity(ApprovalApprovedMapper.buildTarget((ContentEntityObject)abstractPage), approver.getDate().getTime(), action);
    }

    private ActionDetails getApprovalActivityDetails(PageState state, ApprovalCheck approvalCheck, Approver approver) {
        ActionDetails details = this.buildApprovalsActionDetails(approvalCheck.getName(), approvalCheck.getId(), approver.getComment());
        if (approver.getSignatureType() != SignatureType.NONE) {
            details.addDetail(ActionDetailType.APPROVAL_SIGNATURE_MODE, approver.getESignature().toString());
            details.addDetail(ActionDetailType.APPROVAL_SIGNATURE_TYPE, approver.getSignatureType().toString());
        }
        if (!approvalCheck.getAssignments().isEmpty() && approvalCheck.getAssignments().stream().anyMatch(assignment -> assignment.getAssignee().equals(approver.getUser()))) {
            details.addDetail(ActionDetailType.ASSIGNEE_TIME_TO_APPROVE, String.valueOf(approver.getDate().getTime() - approvalCheck.getAssignments().stream().filter(assignment -> assignment.getAssignee().equals(approver.getUser())).findFirst().get().getDate().getTime()));
        }
        details.addAll(this.buildRoleNameActionDetails(approver.getRole()));
        details.addAll(this.buildStateActionDetails(state));
        return details;
    }

    private void addRequiredApprovers(ApprovalCheck approvalCheck, ActionDetails details) {
        if (approvalCheck.getRequiredApprovers() != null && approvalCheck.getRequiredApprovers().length > 0) {
            ArrayList<String> requiredApproversUserkeys = new ArrayList<String>();
            for (String username : approvalCheck.getRequiredApprovers()) {
                requiredApproversUserkeys.add(this.actorUtils.buildActor(username).getId());
            }
            details.addDetail(ActionDetailType.APPROVAL_REQUIRED_APPROVERS, new Gson().toJson(requiredApproversUserkeys.toArray()));
        }
    }

    private void addApprovers(ApprovalCheck approvalCheck, ActionDetails details) {
        if (approvalCheck.getApprovers() != null && approvalCheck.getApprovers().length > 0) {
            ArrayList<String> approversUserkeys = new ArrayList<String>();
            for (Approver approverUser : approvalCheck.getApprovers()) {
                if (!approverUser.isApproved()) continue;
                approversUserkeys.add(this.actorUtils.buildActor(approverUser.getUserName()).getId());
            }
            details.addDetail(ActionDetailType.APPROVAL_APPROVERS, new Gson().toJson(approversUserkeys.toArray()));
        }
    }
}

