/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest.model;

import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.workflow.model.SignatureType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class AbstractApproval {
    public static final int MAX_NAME_LENGTH = 30;
    private String name;
    private String shortName;
    protected String id;
    private boolean approved;
    private boolean rejected;
    private boolean canApprove;
    private boolean canReject;
    private String mark;
    private String signatureType;
    private ValidActions defaultAction;
    protected List<ValidActions> actions;

    public AbstractApproval() {
    }

    public AbstractApproval(String name, boolean approved, boolean rejected, boolean canApprove, boolean canReject, SignatureType signatureType) {
        this.name = name;
        this.shortName = name.length() > 30 ? name.substring(0, 30) + "..." : name;
        this.approved = approved;
        this.rejected = rejected;
        this.canApprove = canApprove;
        this.canReject = canReject;
        this.mark = approved ? "approved" : (rejected ? "rejected" : "");
        this.signatureType = signatureType != null && signatureType != SignatureType.NONE ? signatureType.name() : "";
        this.actions = new ArrayList<ValidActions>();
        if (canApprove) {
            this.addAction(ValidActions.APPROVE);
        }
        if (canReject) {
            this.addAction(ValidActions.REJECT);
        }
        this.id = "approvalv2-" + name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public boolean isCanApprove() {
        return this.canApprove;
    }

    public boolean isCanReject() {
        return this.canReject;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public String getMark() {
        return this.mark;
    }

    public String getSignatureType() {
        return this.signatureType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public void setRejected(boolean rejected) {
        this.rejected = rejected;
    }

    public void setCanApprove(boolean canApprove) {
        this.canApprove = canApprove;
    }

    public void setCanReject(boolean canReject) {
        this.canReject = canReject;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public void setSignatureType(String signatureType) {
        this.signatureType = signatureType;
    }

    public String getId() {
        return this.id;
    }

    public void addAction(ValidActions action) {
        if (this.defaultAction == null) {
            this.defaultAction = action;
        }
        this.actions.add(action);
    }

    public List<ValidActions> getActions() {
        return this.actions;
    }

    public ValidActions getDefaultAction() {
        return this.defaultAction;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDefaultAction(ValidActions defaultAction) {
        this.defaultAction = defaultAction;
    }

    public void setActions(List<ValidActions> actions) {
        this.actions = actions;
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class ValidActions {
        public static final ValidActions APPROVE = new ValidActions("approve", "approvalsworkflow.approval.approve");
        public static final ValidActions REJECT = new ValidActions("reject", "approvalsworkflow.approval.reject");
        public static final ValidActions ASSIGN = new ValidActions("assign", "approvalsworkflow.approval.assign");
        public static final ValidActions UNASSIGN = new ValidActions("unassign", "approvalsworkflow.approval.unassign");
        public static final ValidActions DELETE = new ValidActions("delete", "approvalsworkflow.approval.delete");
        private String caption;
        private String id;

        ValidActions() {
        }

        ValidActions(String id, String key) {
            this.id = id;
            this.caption = key;
        }

        public String getCaption() {
            return ComalaI18nBean.getComalaI18nBean().getText(this.caption);
        }

        public String getId() {
            return this.id;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

