/*
 * Copyright (c) 2024 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    CW.toInit(function () {
        $('.cw-workflow-tasks-report-container[data-cw-report]').each(function (i, item) {
            const $target = $(item);
            const pageId = $target.data('cwPageId') || CW.getParam('pageId');
            const spaceKey = CW.getParam('spaceKey');
            const cqlQuery = $target.data('cwCql');
            const assignee = $target.data('cwAssignee');
            const numberOfItemsPerPage = $target.data('cwNumberOfItems');

            // Workflow States Report Macro Iframe
            const TasksReportIframe = new CW.iframe({
                id: 'TasksReportIframe-' + spaceKey + '-' + i,
                url: '/report/tasks/' + spaceKey,
                width: '100%',
                height: '100%',
                query: {
                    rowsPerPage: numberOfItemsPerPage,
                },
                customData: {
                    spaceKey: spaceKey,
                    filterNumberOfItems: numberOfItemsPerPage,
                    cqlQuery: cqlQuery,
                    assignee: assignee,
                    dateFormat: CW.getParam('cwConfluenceDateFormat'),
                    timeFormat: CW.getParam('cwConfluenceTimeFormat'),
                    dateTimeFormat: CW.getParam('cwConfluenceDateTimeFormat'),
                    locale: CW.getParam('cwConfluenceLocale'),
                    isPreview: $target.data('cwIsPreview')
                }
            });

            /** If the Iframe is inside an expand Macro we need to reload the iframe */
            AJS.$('.expand-control').click((e) => {
                const expandItem = e.currentTarget.id.replace('control', 'content');
                const iframe = $(`#${expandItem}`).find(`#TasksReportIframe-${spaceKey}-${i}`);
                if (iframe.length !== 0) {
                    $target.html(TasksReportIframe.reload());
                }
            });

            $target.html(TasksReportIframe.render());
        })
    });
});
