/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBuffer
implements CharSequence,
Cloneable,
Comparable<Object>,
Serializable {
    protected static final int UNDEFINED = -1;
    private static final int ASIZE = 65535;
    private int[] charShift;
    protected char[] chars;
    protected int length;
    protected int increment = -1;

    public TextBuffer() {
        this((char[])null);
    }

    public TextBuffer(CharSequence value) {
        this(((Object)value).toString().toCharArray());
    }

    public TextBuffer(char[] value) {
        this(value, 0, value != null ? value.length : 0);
    }

    public TextBuffer(char[] value, int length) {
        this(value, 0, length);
    }

    public TextBuffer(char[] value, int start, int length) {
        this.chars = new char[length];
        if (value != null) {
            System.arraycopy(value, start, this.chars, 0, length);
        }
        this.length = length;
    }

    public TextBuffer(TextBuffer value) {
        this.chars = new char[value.chars.length];
        System.arraycopy(value.chars, 0, this.chars, 0, value.length);
        this.length = value.length;
        this.increment = value.increment;
    }

    public int indexOf(CharSequence substring, int beginIndex) {
        return this.indexOf(((Object)substring).toString().toCharArray(), beginIndex);
    }

    public int indexOf(CharSequence substring) {
        return this.indexOf(((Object)substring).toString(), 0);
    }

    public int indexOf(char chr, int beginIndex) {
        int foundAt;
        for (foundAt = beginIndex; this.chars[foundAt] != chr && foundAt < this.length; ++foundAt) {
        }
        return foundAt < this.length ? foundAt : -1;
    }

    public int indexOf(char chr) {
        return this.indexOf(chr, 0);
    }

    public int indexOf(TextBuffer substring, int beginIndex) {
        return this.indexOf(substring.chars, beginIndex);
    }

    public int indexOf(TextBuffer substring) {
        return this.indexOf(substring, 0);
    }

    public int indexOf(char[] target, int beginIndex) {
        int i;
        int ts = target.length;
        boolean matched = false;
        if (this.charShift == null) {
            this.charShift = new int[65535];
        }
        for (i = 0; i < ts; ++i) {
            this.charShift[target[i]] = ts - i;
        }
        i = beginIndex;
        int stop = this.length - ts;
        while (!matched && i <= stop) {
            if (TextBuffer.match(this.chars, i, target, 0, ts)) {
                matched = true;
                continue;
            }
            if (i < stop) {
                int cs;
                i += (cs = this.charShift[this.chars[i + ts]]) != 0 ? cs : ts + 1;
                continue;
            }
            i += ts + 1;
        }
        for (int j = 0; j < ts; ++j) {
            this.charShift[target[j]] = 0;
        }
        return matched ? i : -1;
    }

    public int indexOf(char[] target) {
        return this.indexOf(target, 0);
    }

    public TextBuffer substring(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException(beginIndex + " < 0");
        }
        if (endIndex > this.length) {
            throw new IndexOutOfBoundsException(endIndex + " > length");
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(beginIndex + " > " + endIndex);
        }
        return new TextBuffer(this.chars, beginIndex, endIndex - beginIndex);
    }

    public TextBuffer substring(int beginIndex) {
        return this.substring(beginIndex, this.length);
    }

    public TextBuffer add(int index, CharSequence substring) {
        return this.add(index, ((Object)substring).toString().toCharArray());
    }

    public TextBuffer add(CharSequence substring) {
        return this.add(this.length, substring);
    }

    public TextBuffer add(int index, TextBuffer substring) {
        return this.add(index, substring.chars, 0, substring.length);
    }

    public TextBuffer add(TextBuffer substring) {
        return this.add(this.length, substring);
    }

    public TextBuffer add(int index, char[] substring) {
        return this.add(index, substring, 0, substring.length);
    }

    public TextBuffer add(char[] substring) {
        return this.add(this.length, substring);
    }

    public TextBuffer add(int index, char[] substring, int startAt, int count) {
        this.ensureCharsLength(this.length + count);
        if (index < this.length) {
            this.moveChars(index, index + count, this.length - index);
        }
        System.arraycopy(substring, startAt, this.chars, index, count);
        this.length += count;
        return this;
    }

    public TextBuffer add(char ch) {
        return this.add(this.length, new char[]{ch}, 0, 1);
    }

    public TextBuffer add(int index, char ch) {
        return this.add(index, new char[]{ch}, 0, 1);
    }

    public TextBuffer remove(int fromIndex, int count) {
        int toIndex = fromIndex + count;
        int n = count = toIndex >= this.length ? this.length - fromIndex : count;
        if (fromIndex < this.length) {
            this.moveChars(toIndex, fromIndex, this.length - toIndex);
        }
        this.length -= count;
        return this;
    }

    public TextBuffer remove(int fromIndex) {
        return this.remove(fromIndex, this.length - fromIndex);
    }

    public TextBuffer replace(char oldChar, char newChar) {
        return this.replace(oldChar, newChar, -1);
    }

    public TextBuffer replace(char oldChar, char newChar, int instances) {
        for (int i = 0; i < this.length && instances != 0; ++i) {
            if (this.chars[i] != oldChar) continue;
            this.chars[i] = newChar;
            instances -= instances > 0 ? 1 : 0;
        }
        return this;
    }

    public TextBuffer replace(CharSequence oldSubstr, CharSequence newSubstr, int instances) {
        return this.replace(((Object)oldSubstr).toString().toCharArray(), ((Object)newSubstr).toString().toCharArray(), instances);
    }

    public TextBuffer replace(CharSequence oldSubstr, CharSequence newSubstr) {
        return this.replace(oldSubstr, newSubstr, -1);
    }

    public TextBuffer replace(TextBuffer oldSubstr, TextBuffer newSubstr, int instances) {
        return this.replace(oldSubstr.toCharArray(), newSubstr.toCharArray(), instances);
    }

    public TextBuffer replace(TextBuffer oldSubstr, TextBuffer newSubstr) {
        return this.replace(oldSubstr, newSubstr, -1);
    }

    public TextBuffer replace(char[] oldSubstr, char[] newSubstr, int instances) {
        int nextIndex = this.indexOf(oldSubstr);
        int diff = newSubstr.length - oldSubstr.length;
        int oldLength = oldSubstr.length;
        int newLength = newSubstr.length;
        while (nextIndex != -1 && (instances == -1 || instances > 0)) {
            this.ensureCharsLength(this.length + diff);
            this.moveChars(nextIndex + oldLength, nextIndex + newLength, this.length - (nextIndex + oldLength));
            System.arraycopy(newSubstr, 0, this.chars, nextIndex, newLength);
            this.length += diff;
            nextIndex = this.indexOf(oldSubstr, nextIndex + newLength);
            instances -= instances > 0 ? 1 : 0;
        }
        return this;
    }

    public TextBuffer replace(char[] oldSubstr, char[] newSubstr) {
        return this.replace(oldSubstr, newSubstr, -1);
    }

    public TextBuffer pad(int minSize, char val2) {
        return this.pad(minSize, val2, true);
    }

    public TextBuffer pad(int minSize, char val2, boolean prefix) {
        if (minSize > this.length) {
            int index;
            this.ensureCharsLength(minSize);
            int padSize = minSize - this.length;
            if (prefix) {
                index = 0;
                this.moveChars(0, padSize, this.length);
            } else {
                index = this.length;
            }
            for (int i = index; i < index + padSize; ++i) {
                this.chars[i] = val2;
            }
        }
        return this;
    }

    public TextBuffer trim() {
        boolean stopped = false;
        int fromIndex = 0;
        int toIndex = this.length - 1;
        block6: while (!stopped) {
            switch (this.chars[fromIndex]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++fromIndex;
                    continue block6;
                }
            }
            stopped = true;
        }
        stopped = false;
        block7: while (!stopped) {
            switch (this.chars[toIndex]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    --toIndex;
                    continue block7;
                }
            }
            stopped = true;
        }
        this.length = toIndex - fromIndex;
        if (fromIndex != 0) {
            this.moveChars(fromIndex, 0, this.length);
        }
        return this;
    }

    public TextBuffer toLowerCase() {
        for (int i = 0; i < this.length; ++i) {
            this.chars[i] = Character.toLowerCase(this.chars[i]);
        }
        return this;
    }

    public TextBuffer toUpperCase() {
        for (int i = 0; i < this.length; ++i) {
            this.chars[i] = Character.toUpperCase(this.chars[i]);
        }
        return this;
    }

    public TextBuffer toTitleCase() {
        for (int i = 0; i < this.length; ++i) {
            this.chars[i] = Character.toTitleCase(this.chars[i]);
        }
        return this;
    }

    public TextBuffer plural() {
        String extra = "s";
        if (this.endsWith("sh") || this.endsWith("s") || this.endsWith("ch") || this.endsWith("x")) {
            extra = "es";
        } else if (this.endsWith("y") && this.length > 1 && "aeiou".indexOf(Character.toLowerCase(this.chars[this.length - 2])) == -1) {
            this.remove(this.length - 1);
            extra = "ies";
        }
        return this.add(extra);
    }

    public boolean startsWith(CharSequence substring) {
        return this.startsWith(((Object)substring).toString().toCharArray());
    }

    public boolean startsWith(TextBuffer substring) {
        return this.startsWith(substring.chars, 0, substring.length);
    }

    public boolean startsWith(char[] substring) {
        return this.startsWith(substring, 0, substring.length);
    }

    public boolean startsWith(char[] substring, int offset, int count) {
        if (count <= this.length) {
            return TextBuffer.match(this.chars, 0, substring, offset, count);
        }
        return false;
    }

    public boolean endsWith(CharSequence substring) {
        return this.endsWith(((Object)substring).toString().toCharArray());
    }

    public boolean endsWith(TextBuffer substring) {
        return this.endsWith(substring.chars, 0, substring.length);
    }

    public boolean endsWith(char[] substring) {
        return this.endsWith(substring, 0, substring.length);
    }

    public boolean endsWith(char[] substring, int offset, int count) {
        if (count <= this.length) {
            return TextBuffer.match(this.chars, this.length - count, substring, offset, count);
        }
        return false;
    }

    public byte[] getBytes() {
        return this.toString().getBytes();
    }

    public byte[] getBytes(String enc) throws UnsupportedEncodingException {
        return this.toString().getBytes(enc);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcEnd < srcBegin) {
            throw new IndexOutOfBoundsException("srcEnd (" + srcEnd + ") is less than srcBegin (" + srcBegin + ")");
        }
        if (srcEnd > this.length) {
            throw new IndexOutOfBoundsException("srcEnd (" + srcEnd + ") exceeds the length of the TextBuffer (" + this.length + ")");
        }
        System.arraycopy(this.chars, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    @Override
    public char charAt(int index) {
        if (index > this.length) {
            throw new IndexOutOfBoundsException("index (" + index + ") is greaterh than the length of the TextBuffer (" + this.length + ")");
        }
        return this.chars[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj instanceof String) {
            return this.compareTo((String)obj);
        }
        if (obj instanceof TextBuffer) {
            return this.compareTo((TextBuffer)obj);
        }
        if (obj instanceof CharSequence) {
            return this.compareTo(obj.toString());
        }
        throw new ClassCastException("Only Strings, CharSequences and CharBuffers may be compared to CharBuffers.");
    }

    @Override
    public int compareTo(String val2) {
        char[] strChars = val2.toCharArray();
        return this.compareTo(0, this.length, strChars, 0, strChars.length, false);
    }

    @Override
    public int compareTo(TextBuffer val2) {
        return this.compareTo(0, this.length, val2.chars, 0, val2.length, false);
    }

    public int compareToIgnoreCase(TextBuffer val2) {
        return this.compareTo(0, this.length, val2.chars, 0, val2.length, true);
    }

    @Override
    public int compareTo(char[] val2) {
        return this.compareTo(0, this.length, val2, 0, val2.length, false);
    }

    public int compareTo(int offset, int count, char[] val2, int voffset, int vcount, boolean ignoreCase) {
        int max = offset + count;
        int vmax = voffset + vcount;
        if (max > this.length) {
            throw new IndexOutOfBoundsException("offset + count (" + offset + count + ") exceeds the length of this TextBuffer (" + this.length + ")");
        }
        if (vmax > val2.length) {
            throw new IndexOutOfBoundsException("voffset + vcount (" + voffset + vcount + ") exceeds the length of the val (" + val2.length + ")");
        }
        while (offset < max && voffset < vmax && TextBuffer.uncase(this.chars[offset], ignoreCase) == TextBuffer.uncase(val2[voffset], ignoreCase)) {
            ++offset;
            ++voffset;
        }
        if (offset == max && voffset == vmax) {
            return 0;
        }
        if (offset == max || voffset == vmax) {
            return max - vmax;
        }
        return TextBuffer.uncase(this.chars[offset], ignoreCase) - TextBuffer.uncase(val2[voffset], ignoreCase);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextBuffer) {
            return this.compareTo((TextBuffer)obj) == 0;
        }
        return false;
    }

    public boolean equalsIgnoreCase(Object obj) {
        if (obj instanceof TextBuffer) {
            return this.compareToIgnoreCase((TextBuffer)obj) == 0;
        }
        return false;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public String toString() {
        return new String(this.chars, 0, this.length);
    }

    public char[] toCharArray() {
        char[] ret = new char[this.length];
        System.arraycopy(this.chars, 0, ret, 0, this.length);
        return ret;
    }

    public static TextBuffer valueOf(boolean val2) {
        return new TextBuffer(val2 ? "true" : "false");
    }

    public static TextBuffer valueOf(int val2) {
        return new TextBuffer(String.valueOf(val2));
    }

    public static TextBuffer valueOf(long val2) {
        return new TextBuffer(String.valueOf(val2));
    }

    public static TextBuffer valueOf(float val2) {
        return new TextBuffer(String.valueOf(val2));
    }

    public static TextBuffer valueOf(double val2) {
        return new TextBuffer(String.valueOf(val2));
    }

    public static TextBuffer valueOf(char val2) {
        return new TextBuffer(new char[]{val2});
    }

    public static TextBuffer valueOf(char[] val2) {
        return new TextBuffer(val2);
    }

    public static TextBuffer valueOf(char[] val2, int offset, int count) {
        return new TextBuffer(val2, offset, count);
    }

    public static TextBuffer valueOf(Object val2) {
        return new TextBuffer(val2.toString());
    }

    private static char uncase(char c, boolean ignoreCase) {
        return ignoreCase ? Character.toUpperCase(Character.toLowerCase(c)) : c;
    }

    private static boolean match(char[] a, int as, char[] b, int bs, int length) {
        int amax = as + length;
        int bmax = bs + length;
        if (a.length >= amax && b.length >= bmax) {
            boolean match = true;
            while (match && as < amax) {
                match = a[as++] == b[bs++];
            }
            return match;
        }
        return false;
    }

    private void moveChars(int from, int to, int count) {
        if (from != to) {
            boolean forward = from < to;
            int inc = forward ? -1 : 1;
            int start = forward ? count - 1 : 0;
            int finish = forward ? -1 : count;
            for (int i = start; i != finish; i += inc) {
                this.chars[to + i] = this.chars[from + i];
            }
        }
    }

    private void ensureCharsLength(int required) {
        if (this.chars.length < required) {
            int newLength;
            int n = newLength = this.chars.length == 0 ? 1 : this.chars.length;
            while (newLength < required) {
                newLength += this.increment > 0 ? this.increment : newLength;
            }
            char[] newChars = new char[newLength];
            System.arraycopy(this.chars, 0, newChars, 0, this.chars.length);
            this.chars = newChars;
        }
    }

    public TextBuffer copy() {
        return new TextBuffer(this);
    }

    public Object clone() {
        return this.copy();
    }
}

