/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.manager.state;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.api.model.search.SearchConf9Compatibility;
import com.comalatech.confluence.readack.dataextractor.ReadAckContentPropertyModel;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.cql.CQLExpansionParser;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import com.comalatech.confluence.workflowreports.manager.state.WorkflowStateReportManager;
import com.comalatech.confluence.workflowreports.mapper.ApprovalUsersMapper;
import com.comalatech.confluence.workflowreports.mapper.ReadAckContentMapper;
import com.comalatech.confluence.workflowreports.mapper.StateReportMapper;
import com.comalatech.confluence.workflowreports.model.ExportWorkflowStateReportEntry;
import com.comalatech.confluence.workflowreports.model.StateReportData;
import com.comalatech.confluence.workflowreports.model.WorkflowStatesReportOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportStateReport
implements WorkflowStateReportManager {
    private static final Logger log = LoggerFactory.getLogger(ExportStateReport.class);
    public final CQLSearchService cqlSearchService;
    public final PageManager pageManager;
    public final StateAccessor stateAccessor;
    public final WorkflowUserAccessor workflowUserAccessor;
    private final StateReportMapper stateReportMapper;
    private final ReadAckContentMapper readAckContentMapper;
    private final ApprovalUsersMapper approvalUsersMapper;
    private static final String EXPAND = "content.metadata.properties.comalaworkflows,content.history.lastUpdated,content.metadata.properties.comalaworkflowspendingapprovers,content.metadata.properties.comalaworkflowsfinishedapprovers,content.metadata.properties.comalaworkflowslastfinalversionapprovers,content.metadata.properties.comalaworflowscurrentmodelversion,content.metadata.properties.comalaworkflowspendingapprovals,content.metadata.properties.comalaworkflowsapprovedapprovals,content.metadata.properties.comalaworkflowsrejectedapprovals,content.metadata.properties.comalaworkflowsapprovals,content.space,content.metadata.properties.readack";
    private static final String REPORT_CQL_FILTER = "awphasworkflow=true";
    private static final String CQL_QUERY_PARAM = "cqlQuery";
    private static final Map<String, String> SORT_MAP = new HashMap<String, String>();

    public ExportStateReport(@ComponentImport CQLSearchService cqlSearchService, @ComponentImport PageManager pageManager, StateAccessor stateAccessor, WorkflowUserAccessor workflowUserAccessor, @ComponentImport UserAccessor userAccessor) {
        this.cqlSearchService = cqlSearchService;
        this.pageManager = pageManager;
        this.stateAccessor = stateAccessor;
        this.workflowUserAccessor = workflowUserAccessor;
        this.stateReportMapper = new StateReportMapper();
        this.readAckContentMapper = new ReadAckContentMapper();
        this.approvalUsersMapper = new ApprovalUsersMapper(userAccessor);
    }

    @Override
    public List<ExportWorkflowStateReportEntry> createReport(WorkflowStatesReportOptions options, Map<String, Object> parameters) {
        SearchPageResponse searchResult = this.cqlSearchService.search(this.buildCqlQuery(options, parameters), SearchOptions.buildDefault(), (PageRequest)new SimplePageRequest(0, Integer.parseInt(options.getNumberOfItemsPerPage())), CQLExpansionParser.parse(EXPAND));
        try {
            return this.buildReport((SearchPageResponse<SearchResult>)searchResult);
        }
        catch (WorkflowException e) {
            log.error(e.getMessage());
            return new ArrayList<ExportWorkflowStateReportEntry>();
        }
    }

    private String buildCqlQuery(WorkflowStatesReportOptions options, Map<String, Object> parameters) {
        StringJoiner stateJoiner = new StringJoiner("\",\"", "state IN (\"", "\")");
        options.getStates().forEach(stateJoiner::add);
        StringJoiner workflowJoiner = new StringJoiner("\",\"", "workflowname IN (\"", "\")");
        options.getWorkflows().forEach(workflowJoiner::add);
        Object cqlQuery = REPORT_CQL_FILTER;
        cqlQuery = StringUtils.isNotBlank((CharSequence)parameters.get(CQL_QUERY_PARAM).toString()) ? (String)cqlQuery + " AND " + parameters.get(CQL_QUERY_PARAM) : cqlQuery;
        cqlQuery = !options.getStates().isEmpty() ? (String)cqlQuery + " AND " + stateJoiner : cqlQuery;
        cqlQuery = !options.getWorkflows().isEmpty() ? (String)cqlQuery + " AND " + workflowJoiner : cqlQuery;
        cqlQuery = (String)cqlQuery + " ORDER BY " + SORT_MAP.get(options.getSort()) + " " + options.getSortOrder();
        return cqlQuery;
    }

    private List<ExportWorkflowStateReportEntry> buildReport(SearchPageResponse<SearchResult> searchResults) throws WorkflowException {
        ArrayList<ExportWorkflowStateReportEntry> report = new ArrayList<ExportWorkflowStateReportEntry>();
        for (SearchResult result : searchResults) {
            report.add(this.buildEntry(result));
        }
        return report;
    }

    private ExportWorkflowStateReportEntry buildEntry(SearchResult result) throws WorkflowException {
        AbstractPage page = this.pageManager.getAbstractPage(((Content)result.getEntity()).getId().asLong());
        if (page == null) {
            throw new WorkflowException("There was an error while creating the report.");
        }
        PageState pageState = this.stateAccessor.getLatestState(page);
        EnrichableMap properties = (EnrichableMap)((Content)result.getEntity()).getMetadata().get("properties");
        StateReportData reportData = properties.get((Object)"comalaworkflows") != null ? this.stateReportMapper.map(((JsonContentProperty)properties.get((Object)"comalaworkflows")).getValue().getValue()) : new StateReportData();
        ReadAckContentPropertyModel readAckData = properties.get((Object)"readack") != null ? this.readAckContentMapper.map(((JsonContentProperty)properties.get((Object)"readack")).getValue().getValue()) : new ReadAckContentPropertyModel();
        ArrayList<String> lastFinalVersionApprovers = properties.get((Object)"comalaworkflowslastfinalversionapprovers") != null ? this.approvalUsersMapper.map(((JsonContentProperty)properties.get((Object)"comalaworkflowslastfinalversionapprovers")).getValue().getValue()) : new ArrayList<String>();
        return ExportWorkflowStateReportEntry.builder().title(page.getTitle()).pageLink(this.getBaseUrl() + page.getUrlPath()).approvedVersion(reportData.getLastFinalVersionNumber()).approvedVersionApprovers(lastFinalVersionApprovers).approvedVersionLink(page.getIdAsString() != null ? this.getBaseUrl() + "/pages/releaseview.action?pageId=" + page.getIdAsString() : null).approvedVersionDate(reportData.getLastFinalVersionDate() != null ? TimerUtils.parseDateWithConfluenceDateFormat(reportData.getLastFinalVersionDate()) : null).changed(pageState != null && pageState.getDate() != null ? TimerUtils.parseDateWithConfluenceDateFormat(pageState.getDate()) : null).changedBy(pageState != null && pageState.getPerformer() != null ? pageState.getPerformer() : null).created(page.getCreationDate() != null ? TimerUtils.parseDateWithConfluenceDateFormat(page.getCreationDate()) : null).createdBy(page.getCreator() != null ? page.getCreator().getName() : "Anonymous").dueDate(reportData.getDueDate() != null ? TimerUtils.parseDateWithConfluenceDateFormat(reportData.getDueDate()) : null).readConfirmation(readAckData.readAckStatus != null ? readAckData.readAckStatus : null).state(reportData.getCurrentState()).space(page.getSpace().getName()).spaceLink(this.getBaseUrl() + page.getSpace().getUrlPath()).updated(SearchConf9Compatibility.getLastModifiedAt(result) != null ? TimerUtils.parseDateWithConfluenceDateFormat(SearchConf9Compatibility.getLastModifiedAt(result)) : null).updatedBy(page.getLastModifier() != null ? page.getLastModifier().getName() : "Anonymous").workflow(reportData.getWorkflowName()).build();
    }

    private String getBaseUrl() {
        String domainName = GeneralUtil.getGlobalSettings().getBaseUrl();
        if (StringUtils.isNotBlank((CharSequence)domainName) && domainName.endsWith("/")) {
            domainName = domainName.substring(0, domainName.length() - 1);
        }
        return domainName;
    }

    static {
        SORT_MAP.put("updated", "lastModified");
        SORT_MAP.put("createdBy", "creator");
        SORT_MAP.put("title", "title");
        SORT_MAP.put("created", "created");
    }
}

