/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.mappers;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ApprovalsReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.model.StateReportParameters;

public class SpaceParameterMapper
implements ParameterMapper {
    private final AbstractPage currentPage;
    private static final String SELF_SPACE = "@self";
    private static final String ALL_SPACES = "@all";

    public SpaceParameterMapper(AbstractPage page) {
        this.currentPage = page;
    }

    @Override
    public ReportParameter map(ReportParameter parameter) {
        if (this.parameterCanBeMapped(parameter)) {
            String spaceKey;
            StringReportParameterValue value = (StringReportParameterValue)parameter.getValue();
            switch (spaceKey = value.getValueOrDefault()) {
                case "@self": {
                    spaceKey = this.currentPage != null ? this.currentPage.getSpaceKey() : "";
                    break;
                }
                case "@all": {
                    spaceKey = "";
                }
            }
            parameter.setValue(new StringReportParameterValue(spaceKey, (String)value.getDefaultValue()));
        }
        return parameter;
    }

    @Override
    public boolean parameterCanBeMapped(ReportParameter parameter) {
        return (parameter.keyIs(StateReportParameters.SPACE.getKey()) || parameter.keyIs(ApprovalsReportParameters.SPACE.getKey())) && parameter.getValue() instanceof StringReportParameterValue;
    }
}

