/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.util.HtmlUtil;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.JsonSerialiserUtil;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.model.WorkflowParameter;
import com.comalatech.confluence.workflow.rest.model.RestWorkflowParam;
import com.comalatech.confluence.workflow.rest.model.RestWorkflowParamTranslator;
import com.comalatech.confluence.workflow.rest.model.SpaceWorkflowParam;
import com.comalatech.confluence.workflowcontainer.action.SpaceConfigurationAction;
import com.comalatech.workflow.model.WorkflowParameterType;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceWorkflowConfigurationAction
extends SpaceConfigurationAction {
    private static final Logger log = LoggerFactory.getLogger(SpaceWorkflowConfigurationAction.class);
    private InternalWorkflowParameterManager workflowParameterManager;
    private String name;
    private String value;
    private String type;
    private String update;
    private int durationCount;
    private String durationPeriod;
    private List<String> paramErrors = new ArrayList<String>();
    private String docoConfigurationUrl = "https://apps.appf.re/cdmdc/doc/spaceconfig/zSN1hk";
    private String docoParameterUrl = "https://apps.appf.re/cdmdc/doc/spaceparameters/jLw5cb";

    @Override
    public String execute() throws Exception {
        super.execute();
        return "success";
    }

    private WorkflowParameter getWorkflowParameter() {
        try {
            Period period;
            WorkflowParameterType workflowParameterType = WorkflowParameterType.parse(this.type);
            if (workflowParameterType == WorkflowParameterType.DURATION && (period = TimerUtils.parsePeriod(this.durationCount, this.durationPeriod)) != null) {
                this.value = TimerUtils.periodToString(period);
            }
            return new WorkflowParameter(this.name, null, workflowParameterType, this.value, null, false);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public void setWorkflowParameterManager(InternalWorkflowParameterManager workflowParameterManager) {
        this.workflowParameterManager = workflowParameterManager;
    }

    public List<com.comalatech.workflow.model.WorkflowParameter> getWorkflowParameters() {
        return this.workflowParameterManager.getSpaceWorkflowsParameters(this.getSpaceKey());
    }

    public String getWorkflowParametersAsJsonHtml() {
        ArrayList<SpaceWorkflowParam> spaceWorkflowParamList = new ArrayList<SpaceWorkflowParam>();
        List<RestWorkflowParam> restWorkflowParam = RestWorkflowParamTranslator.toRest(this.validateWorkflowParameters(this.getWorkflowParameters()));
        for (RestWorkflowParam workflowParam : restWorkflowParam) {
            spaceWorkflowParamList.add(this.mapperSpaceWorkflowParam(workflowParam));
        }
        JsonSerialiserUtil<SpaceWorkflowParam> serializer = new JsonSerialiserUtil<SpaceWorkflowParam>(SpaceWorkflowParam.class);
        return serializer.serialiseList(spaceWorkflowParamList);
    }

    public List<com.comalatech.workflow.model.WorkflowParameter> validateWorkflowParameters(List<com.comalatech.workflow.model.WorkflowParameter> workflowParameters) {
        ArrayList<com.comalatech.workflow.model.WorkflowParameter> validatedParamsList = new ArrayList<com.comalatech.workflow.model.WorkflowParameter>();
        for (com.comalatech.workflow.model.WorkflowParameter param : workflowParameters) {
            if (param.getType() == WorkflowParameterType.DURATION) {
                try {
                    TimerUtils.parsePeriod(param.getValue());
                    validatedParamsList.add(param);
                }
                catch (Exception e) {
                    param.setValue("P0D");
                    validatedParamsList.add(param);
                    this.addParamError(param.getName());
                }
                continue;
            }
            validatedParamsList.add(param);
        }
        return validatedParamsList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public void setDurationCount(int durationCount) {
        this.durationCount = durationCount;
    }

    public void setDurationPeriod(String durationPeriod) {
        this.durationPeriod = durationPeriod;
    }

    public void addParamError(String error) {
        this.paramErrors.add(error);
    }

    public List<String> getParamErrors() {
        return this.paramErrors;
    }

    public String getParamErrorsAsHtmlString() {
        return HtmlUtil.htmlEncode((String)StringUtils.join(this.paramErrors, (String)","));
    }

    private SpaceWorkflowParam mapperSpaceWorkflowParam(RestWorkflowParam workflowParam) {
        SpaceWorkflowParam spaceWorkflowParam = new SpaceWorkflowParam();
        spaceWorkflowParam.setId(Base64.getEncoder().encodeToString(workflowParam.getName().getBytes()));
        spaceWorkflowParam.setName(workflowParam.getName());
        spaceWorkflowParam.setType(workflowParam.getType());
        spaceWorkflowParam.setValue(workflowParam.getValue());
        spaceWorkflowParam.setDescription(workflowParam.getDescription());
        spaceWorkflowParam.setOptions(workflowParam.getOptions());
        spaceWorkflowParam.setOptionsList(workflowParam.getOptionsList());
        spaceWorkflowParam.setLabel(workflowParam.getLabel());
        return spaceWorkflowParam;
    }

    public String getDocoUrl(String screen) {
        return screen.equalsIgnoreCase("parameter") ? this.docoParameterUrl : this.docoConfigurationUrl;
    }
}

