/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.expander.content;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.adhocworkflows.rest.model.Approval;
import com.comalatech.confluence.adhocworkflows.rest.model.Approver;
import com.comalatech.confluence.adhocworkflows.rest.model.User;
import com.comalatech.confluence.workflow.rest.expander.content.AbstractWorkflowActionExpander;
import com.comalatech.confluence.workflow.rest.model.ContentAction;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowRequest;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ActionsExpander
extends AbstractWorkflowActionExpander {
    public static final String EXPANDER = "actions";

    public ActionsExpander() {
        super(EXPANDER);
    }

    @Override
    public void expand(ContentWorkflowResponse response, ContentWorkflowRequest request) {
        ArrayList<ContentAction> contentActions = new ArrayList<ContentAction>();
        String currentUser = AuthenticatedUserThreadLocal.getUsername();
        if (request.getWorkflowAction().isInitParameters() || request.getWorkflowAction().isHasParameters() || request.getWorkflowAction().isShowParameters()) {
            contentActions.add(new ContentAction.ParametersAction(request.getWorkflowAction().getInputFields(), request.getWorkflowAction().isInitParameters()));
        }
        if (!request.getWorkflowAction().isInitParameters()) {
            if (request.getWorkflowAction().getStates() != null && request.getWorkflowAction().getStates().size() > 0) {
                contentActions.add(new ContentAction.ChangeAction(request.getWorkflowAction().getStates()));
            } else if (request.getWorkflowAction().getApprovals() != null && request.getWorkflowAction().getApprovals().size() > 0) {
                for (Approval approval : request.getWorkflowAction().getApprovals()) {
                    List<User> involvedUsers = null;
                    ArrayList<String> actions = new ArrayList<String>();
                    boolean canApprove = approval.isCanApprove();
                    boolean canReject = approval.isCanReject();
                    boolean canAssign = approval.isCanAssign();
                    boolean canUnassign = false;
                    for (Approver approver : approval.getApprovers()) {
                        User approverUser = approver.getUser();
                        if (approverUser == null || !approverUser.getName().equals(currentUser) || approver.isPast()) continue;
                        canApprove = canApprove || approver.isCanApprove();
                        canReject = canReject || approver.isCanReject();
                        canUnassign = approver.isCanRemove();
                    }
                    if (canApprove) {
                        actions.add("approve");
                    }
                    if (canReject) {
                        actions.add("reject");
                    }
                    if (canAssign) {
                        actions.add("assign");
                        involvedUsers = request.getWorkflowAction().getInvolvedUsers();
                    }
                    if (canUnassign) {
                        actions.add("unassign");
                    }
                    if (actions.size() <= 0) continue;
                    contentActions.add(new ContentAction.ApprovalAction(approval.getName(), approval.getShortName(), actions, approval.getMessage(), StringUtils.isNotBlank((CharSequence)approval.getSignatureType()) ? approval.getSignatureType() : null, request.getWorkflowAction().getESignature(), involvedUsers, request.getWorkflowAction().isRequireApprovalComment(), request.getWorkflowAction().isHasSigning()));
                }
            }
        }
        response.actions = contentActions;
    }
}

