/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork.notification.task;

import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.FancyDateFormatter;
import com.comalatech.confluence.workflow.mywork.model.MyworkWorkflowMetadata;
import com.comalatech.confluence.workflow.mywork.notification.task.AbstractTaskNotification;
import com.comalatech.workflow.event.TaskAssignEvent;

public class TaskAssigneeNotification
extends AbstractTaskNotification {
    TaskAssignEvent event;

    public TaskAssigneeNotification(TaskAssignEvent event) {
        super(event);
        this.event = event;
    }

    @Override
    public String getItemTitle() {
        return this.event.getTask().getName();
    }

    @Override
    public String getDescription() {
        return this.event.getAssignment().getComment();
    }

    @Override
    public String getAction() {
        return "assigned";
    }

    @Override
    public MyworkWorkflowMetadata getMetadata(String toUser) {
        MyworkWorkflowMetadata metadata = super.getMetadata(toUser);
        if (this.event.getTask().getDueDate() != null) {
            String dueDate = FancyDateFormatter.decorateDateTimePretty(this.event.getTask().getDueDate(), false);
            metadata.setDuedate(ComalaI18nBean.getComalaI18nBean().getText("comalatech.awp.tasks.dueDate") + " " + dueDate);
        } else {
            metadata.setDuedate("");
        }
        return metadata;
    }
}

