/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.sal.api.component.ComponentLocator;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.ValueStoreManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.StateCondition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;

public class StateInDraftSpaceCondition
extends StateCondition {
    public static final String PUBLISHING_SOURCE_SPACE = "com.comalatech.space-config.publishing.source";

    public StateInDraftSpaceCondition(boolean not, String states) {
        super(not, states);
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        Page draftPage = StateInDraftSpaceCondition.getPageInDraftSpace(valueStore);
        return draftPage != null && super.evaluateBinary(StateInDraftSpaceCondition.getValueStoreManager().createValueStore((AbstractPage)draftPage));
    }

    public static Page getPageInDraftSpace(ValueStore valueStore) {
        AbstractPage page = valueStore.getPage();
        if (!(page instanceof Page)) {
            return null;
        }
        String draftSpaceKey = StateInDraftSpaceCondition.getDraftSpaceKey(page.getSpaceKey());
        if (draftSpaceKey == null) {
            return null;
        }
        return StateInDraftSpaceCondition.getPageManager().getPage(draftSpaceKey, page.getTitle());
    }

    private static String getDraftSpaceKey(String spaceKey) {
        return (String)StateInDraftSpaceCondition.getBandanaManager().getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), PUBLISHING_SOURCE_SPACE);
    }

    private static BandanaManager getBandanaManager() {
        return (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
    }

    private static PageManager getPageManager() {
        return (PageManager)ComponentLocator.getComponent(PageManager.class);
    }

    private static ValueStoreManager getValueStoreManager() {
        return PluginContainerManager.getComponent(ValueStoreManager.class);
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("stateindraft", (Object)((this.not ? "!" : "") + MiscUtils.stringListToCommaSeparatedList(this.states, ",")));
    }

    @Override
    public String toString(ValueStore valueStore) {
        StringBuilder sb = new StringBuilder("state in draft space httpNEW34Nis ");
        if (this.not) {
            sb.append("not ");
        }
        String separator = " " + ComalaI18nBean.getComalaI18nBean().getText("approvalsworkflow.spaceapprovals.condition.or") + " ";
        sb.append(MiscUtils.stringListToCommaSeparatedList(this.states, separator));
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("state in draft space is ");
        if (this.not) {
            sb.append("not ");
        }
        sb.append("{").append(MiscUtils.stringListToCommaSeparatedList(this.states, "or")).append("}");
        return sb.toString();
    }
}

