/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;
import com.comalatech.workflow.TaskService;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.model.ContentTask;
import com.comalatech.workflow.model.Task;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CompleteTaskMacro
extends AbstractActionMacro {
    protected static final String PARAM_TASKNAME = "task";
    protected static final String PARAM_COMMENT = "comment";
    protected TaskService taskService;

    public String execute(Map params, String body, RenderContext renderContext) throws MacroException {
        Task task;
        ContentEntityObject ceo;
        AbstractPage page = null;
        if (renderContext instanceof PageContext && (ceo = ((PageContext)renderContext).getEntity()) instanceof AbstractPage) {
            page = (AbstractPage)ceo;
        }
        if (page == null) {
            throw new MacroException("This macro can only be used on a page or blog post");
        }
        String comment = MapUtils.getString(params, PARAM_COMMENT);
        String taskName = MapUtils.getString(params, PARAM_TASKNAME);
        if (!StringUtils.isNotBlank((CharSequence)taskName)) {
            taskName = MapUtils.getString(params, "0");
        }
        if (!StringUtils.isNotBlank((CharSequence)taskName)) {
            throw new MacroException("Task Name not specified");
        }
        if (this.inExecuteMode(renderContext) && (task = this.getPageTask(taskName, page)) != null && !task.isCompleted()) {
            try {
                this.taskService.completeTask((ContentEntityObject)page, task.getActivityId(), comment);
            }
            catch (WorkflowException e) {
                this.logMessage(renderContext, e);
            }
        }
        return "";
    }

    protected Task getPageTask(String taskName, AbstractPage page) {
        List<ContentTask> tasks = this.taskService.getTasks((ContentEntityObject)page);
        for (ContentTask contentTask : tasks) {
            if (!contentTask.getTask().getName().equals(taskName)) continue;
            return contentTask.getTask();
        }
        return null;
    }

    @Override
    protected String getName() {
        return "complete-task";
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }
}

