/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.macro.WysiwygBodyType;
import com.comalatech.confluence.workflow.macros.templates.NoBodyBaseMacro;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.model.PageStatus;
import com.opensymphony.xwork2.ActionContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageStatusMacro
extends NoBodyBaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(PageStatusMacro.class);
    private WorkflowHandler workflowHandler;
    private static final String PAGE_STATUS_TEMPLATE = "templates/pagestatusmacro.vm";

    public String execute(Map<String, String> parameters, String body, ConversionContext context) {
        if (context.getEntity() instanceof AbstractPage) {
            return this.getPageStateSpan((AbstractPage)context.getEntity(), this.isRenderingPublishedPage(context));
        }
        return "";
    }

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        if (renderContext instanceof PageContext) {
            ContentEntityObject ceo = ((PageContext)renderContext).getEntity();
            return this.getPageStateSpan((AbstractPage)ceo, this.isRenderingPublishedPage(renderContext));
        }
        return "";
    }

    public String getPageStateSpan(AbstractPage page, boolean publishedView) {
        AbstractPage latestPage = page.getLatestVersion();
        PageStatus status = this.workflowHandler.getPageStatus((ContentEntityObject)latestPage, publishedView, false);
        if (status != null && StringUtils.isNotBlank((CharSequence)status.getStateName())) {
            return this.renderPageStatus(this.getStatusContext(status, publishedView));
        }
        return "";
    }

    public Map<String, Object> getStatusContext(PageStatus status, boolean publishedView) {
        String stateName;
        String colour;
        String finalClass = "";
        if (publishedView && status.getPublishedStateColour() != null && status.getPublishedStateName() != null) {
            colour = status.getPublishedStateColour();
            stateName = status.getPublishedStateName();
        } else {
            colour = status.getStateColour();
            stateName = status.getStateName();
        }
        if (status.isFinalState()) {
            finalClass = "final";
        } else if (status.isHasFinalState()) {
            finalClass = "notfinal";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("finalClass", finalClass);
        context.put("colour", colour);
        context.put("stateName", stateName);
        return context;
    }

    public String renderPageStatus(Map<String, Object> context) {
        try {
            return this.renderTemplate(context, PAGE_STATUS_TEMPLATE);
        }
        catch (MacroException e) {
            log.error("Page Status Macro Exception", (Throwable)e);
            return "";
        }
    }

    protected boolean isRenderingPublishedPage(RenderContext context) {
        return context.getParam((Object)"releaseview") != null || this.isRenderingPublishedPage();
    }

    protected boolean isRenderingPublishedPage(ConversionContext context) {
        return context != null && context.getProperty("releaseview") != null || this.isRenderingPublishedPage();
    }

    protected boolean isRenderingPublishedPage() {
        return "releaseview".equals(ActionContext.getContext().getActionName()) || ActionContext.getContext() != null && ActionContext.getContext().getContextMap() != null && ActionContext.getContext().getContextMap().get("releaseview") != null;
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.INLINE;
    }

    public TokenType getTokenType(Map arg0, String arg1, RenderContext arg2) {
        return TokenType.INLINE;
    }

    public WysiwygBodyType getWysiwygBodyType() {
        return WysiwygBodyType.WIKI_MARKUP;
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public boolean isInline() {
        return true;
    }

    public boolean suppressMacroRenderingDuringWysiwyg() {
        return false;
    }

    public boolean suppressSurroundingTagDuringWysiwygRendering() {
        return false;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public void setWorkflowHandler(WorkflowHandler workflowHandler) {
        this.workflowHandler = workflowHandler;
    }
}

