/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.util;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.comalatech.confluence.documentActivity.api.entities.PublicActor;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.license.WorkflowsFeatureManagerImpl;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import org.apache.commons.lang3.StringUtils;

public class ActorUtils {
    public static final String ANONYMOUS_USERNAME = "com.comalatech.anonymous";
    public static final String ANONYMOUS_PROFILE_PIC_PATH = "/images/icons/profilepics/anonymous.png";
    public static final String DELETED_USERNAME = "com.comalatech.deleted";
    private final UserAccessor userAccessor;
    private final WorkflowUserAccessor workflowUserAccessor;

    public ActorUtils(UserAccessor userAccessor, WorkflowUserAccessor workflowUserAccessor) {
        this.userAccessor = userAccessor;
        this.workflowUserAccessor = workflowUserAccessor;
    }

    public static Actor buildActor(String id, String username, String fullName, String profilePictureInfo, boolean showAsLink) {
        Actor actor = new Actor();
        actor.setId(id);
        actor.setName(username);
        actor.setDisplayName(fullName);
        actor.setProfilePicPath(profilePictureInfo);
        actor.setShowAsLink(showAsLink);
        return actor;
    }

    public Actor buildActor(String userName) {
        return this.buildActor(userName, false);
    }

    public Actor buildActor(String userName, boolean isCloudMigration) {
        if (ANONYMOUS_USERNAME.equals(userName) || StringUtils.isEmpty((CharSequence)userName)) {
            return this.buildAnonymousActor();
        }
        if (WorkflowsFeatureManagerImpl.isWorkflowsUser(userName)) {
            return this.buildWorkflowActor();
        }
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            user = this.userAccessor.getUserByKey(new UserKey(userName));
        }
        if (user != null) {
            return this.buildActor(user);
        }
        return this.buildDeletedActor(userName, isCloudMigration);
    }

    public Actor buildActorWithKey(String userKey) throws WorkflowUserException {
        if (WorkflowsFeatureManagerImpl.isWorkflowsUser(userKey)) {
            return this.buildWorkflowActor();
        }
        if (ANONYMOUS_USERNAME.equals(userKey)) {
            return this.buildAnonymousActor();
        }
        ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(userKey));
        return user != null ? this.buildActor(user) : this.buildActor(userKey);
    }

    public Actor buildActor(ConfluenceUser user) {
        if (user == null) {
            return this.buildAnonymousActor();
        }
        String profilePictureUri = this.userAccessor.getUserProfilePicture((User)user).getUriReference();
        return ActorUtils.buildActor(user.getKey().getStringValue(), user.getName(), user.getFullName(), profilePictureUri, true);
    }

    public Actor buildWorkflowActor() {
        return ActorUtils.buildActor(this.workflowUserAccessor.getAddonUser().getName(), this.workflowUserAccessor.getAddonUser().getName(), this.workflowUserAccessor.getAddonUser().getFullName(), this.workflowUserAccessor.getAddonUserAvatarPath(), false);
    }

    public Actor buildAnonymousActor() {
        return ActorUtils.buildActor(ANONYMOUS_USERNAME, ANONYMOUS_USERNAME, ANONYMOUS_USERNAME, ANONYMOUS_PROFILE_PIC_PATH, false);
    }

    private Actor buildDeletedActor(String userName, boolean isCloudMigration) {
        if (!isCloudMigration && StringUtils.isNotBlank((CharSequence)userName)) {
            return ActorUtils.buildActor(userName, userName, userName, ANONYMOUS_PROFILE_PIC_PATH, false);
        }
        return ActorUtils.buildActor(DELETED_USERNAME, DELETED_USERNAME, DELETED_USERNAME, ANONYMOUS_PROFILE_PIC_PATH, false);
    }

    public PublicActor actorToPublic(Actor actor) {
        return PublicActor.builder().id(actor.getId()).displayName(actor.getDisplayName()).name(actor.getName()).profilePicPath(actor.getProfilePicPath()).build();
    }
}

