/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.Action;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.ActionDetail;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.ActionType;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.Actor;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.Target;
import com.comalatech.confluence.cloud.migration.usecases.mappers.ActorMapper;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import java.util.ArrayList;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class ActivityMapper {
    private final ActorMapper actorMapper = Mappers.getMapper(ActorMapper.class);

    public com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity map(Activity docActivity) {
        if (docActivity == null) {
            return null;
        }
        com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity activity = new com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity();
        activity.setCloudTarget(this.targetToTarget(docActivity.getTarget()));
        activity.setAction(this.actionToAction(docActivity.getAction()));
        activity.setServerTarget(this.targetToTarget(docActivity.getTarget()));
        activity.setMoment(docActivity.getMoment());
        return activity;
    }

    protected Target targetToTarget(com.comalatech.confluence.documentActivity.domain.entities.Target target) {
        if (target == null) {
            return null;
        }
        Target target1 = new Target();
        target1.setTargetVersion("v" + target.getTargetVersion());
        target1.setTargetId(String.valueOf(target.getTargetId()));
        return target1;
    }

    protected Action actionToAction(com.comalatech.confluence.documentActivity.domain.entities.Action action) {
        if (action == null) {
            return null;
        }
        Action action1 = new Action();
        action1.setPerformer(this.actorListToPerformer(action.getActors()));
        action1.setActionType(this.actionTypeToActionType(action.getActionType()));
        action1.setActionDetails(this.actionDetailsToActionDetail(action.getActionDetails()));
        action1.setActuatedElements(this.actionDetailsToActuatedElement(action.getActionDetails()));
        return action1;
    }

    protected Actor actorListToPerformer(List<com.comalatech.confluence.documentActivity.domain.entities.Actor> list) {
        if (list == null) {
            return null;
        }
        Actor actor = null;
        if (list.size() > 0) {
            actor = this.actorMapper.pageActivityActorToMigrationActivityActor(list.get(0));
        }
        return actor;
    }

    protected ActionType actionTypeToActionType(com.comalatech.confluence.documentActivity.domain.entities.ActionType actionType) {
        if (actionType == null) {
            return null;
        }
        ActionType actionType1 = new ActionType();
        if (actionType.getType().equals((Object)ActionType.Type.STATE)) {
            actionType1.setType(ActionType.Type.STATE);
        }
        return actionType1;
    }

    protected List<ActionDetail> actionDetailsToActionDetail(ActionDetails actionDetails) {
        if (actionDetails == null) {
            return null;
        }
        ArrayList<ActionDetail> migrationDetails = new ArrayList<ActionDetail>();
        com.comalatech.confluence.documentActivity.domain.entities.ActionDetail isPublished = actionDetails.getDetail(ActionDetailType.IS_PUBLISHED);
        com.comalatech.confluence.documentActivity.domain.entities.ActionDetail stateComment = actionDetails.getDetail(ActionDetailType.STATE_COMMENT);
        com.comalatech.confluence.documentActivity.domain.entities.ActionDetail stateColour = actionDetails.getDetail(ActionDetailType.STATE_COLOUR);
        if (isPublished != null && isPublished.getValue() != null) {
            migrationDetails.add(this.actionDetailToActionDetail(isPublished));
        }
        if (stateComment != null && stateComment.getValue() != null) {
            migrationDetails.add(this.actionDetailToActionDetail(stateComment));
        }
        if (stateColour != null && stateColour.getValue() != null) {
            migrationDetails.add(this.actionDetailToActionDetail(stateColour));
        }
        return migrationDetails;
    }

    protected ActionDetail actionDetailToActionDetail(com.comalatech.confluence.documentActivity.domain.entities.ActionDetail actionDetail) {
        if (actionDetail == null) {
            return null;
        }
        ActionDetail actionDetail1 = new ActionDetail();
        actionDetail1.setValue(actionDetail.getValue());
        actionDetail1.setType(this.typeToType(actionDetail.getType()));
        return actionDetail1;
    }

    protected ActionDetail.Type typeToType(ActionDetailType type) {
        ActionDetail.Type type1;
        if (type == null) {
            return null;
        }
        switch (type) {
            case IS_PUBLISHED: {
                type1 = ActionDetail.Type.IS_PUBLISHED;
                break;
            }
            case STATE_COMMENT: {
                type1 = ActionDetail.Type.COMMENT;
                break;
            }
            case STATE_COLOUR: {
                type1 = ActionDetail.Type.COLOUR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + type);
            }
        }
        return type1;
    }

    protected String actionDetailsToActuatedElement(ActionDetails actionDetails) {
        if (actionDetails == null) {
            return null;
        }
        String actuatedElement = null;
        com.comalatech.confluence.documentActivity.domain.entities.ActionDetail stateNameActionDetail = actionDetails.getDetail(ActionDetailType.STATE_NAME);
        if (stateNameActionDetail != null) {
            actuatedElement = stateNameActionDetail.getValue();
        }
        return actuatedElement;
    }
}

