/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    CW.toInit(function () {
        var WorkflowsUsageIframe = new CW.iframe({
            id: 'WorkflowsUsageIframe',
            url: '/admin/global/workflowsusagereport',
            width: '100%',
            height: '100%'
        });
        $('#cw-workflowsusage-report').html(WorkflowsUsageIframe.render());


        // Workflow Preview Modal
        CW.connect("workflowUsageOpenModal", function (data) {

            const { spaceKey, workflowId, mode, workflowType, isGlobal } = data;

            // Workflow preview info
            var workflowPreview = new CW.Dialog({
                id: 'cw-workflowUsageEditDialog',
                width: '80%',
                height: '80%',
                path: isGlobal ? `/${mode}/${workflowId.replace('linked', '')}` : `/${mode}/${spaceKey}/${workflowId}`,
                query: {
                    workflowType,
                    isDialog: true
                }
            });

            workflowPreview.show();
        });
    })
});