/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.general;

import java.util.regex.Pattern;
import org.randombits.confluence.filtering.criteria.general.GeneralCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextCriterion
extends GeneralCriterion<Object> {
    private Pattern include;
    private Pattern exclude;
    private int minLength = -1;
    private int maxLength = -1;
    private String value;

    public TextCriterion() {
        super(Object.class);
    }

    public TextCriterion(Pattern include, Pattern exclude) {
        this(-1, -1, include, exclude);
    }

    public TextCriterion(int minLength, int maxLength) {
        this(minLength, maxLength, null, null);
    }

    public TextCriterion(int minLength, int maxLength, Pattern include, Pattern exclude) {
        this();
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.include = include;
        this.exclude = exclude;
    }

    @Override
    public boolean matchesType(Object object) {
        String stringValue = object == null ? "" : object.toString();
        String string = stringValue = stringValue == null ? "" : stringValue;
        if (this.isRequired() && stringValue.trim().length() == 0) {
            return false;
        }
        if (this.minLength >= 0 && stringValue.length() < this.minLength) {
            return false;
        }
        if (this.maxLength >= 0 && stringValue.length() > this.maxLength) {
            return false;
        }
        if (this.value != null && !this.value.equals(stringValue)) {
            return false;
        }
        if (this.include != null && !this.include.matcher(stringValue).matches()) {
            return false;
        }
        return this.exclude == null || !this.exclude.matcher(stringValue).matches();
    }

    public Pattern getInclude() {
        return this.include;
    }

    public Pattern getExclude() {
        return this.exclude;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setInclude(Pattern include) {
        this.include = include;
    }

    public void setExclude(Pattern exclude) {
        this.exclude = exclude;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "{text" + (this.minLength >= 0 ? "; min length: " + this.minLength : "") + (this.maxLength >= 0 ? "; max length: " + this.maxLength : "") + (this.include != null ? "; include: " + this.include : "") + (this.exclude != null ? "; exclude: " + this.exclude : "") + (this.value != null ? "; value: " + this.value : "") + "}";
    }
}

