/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.search;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class LuceneHelper {
    private static final String LUCENE_DATE_SECONDS = "yyyyMMddHHmmss";
    private static final String LUCENE_DATE_MILLISECONDS = "yyyyMMddHHmmssSSS";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final SimpleDateFormat LUCENE_SECONDS_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final SimpleDateFormat LUCENE_MILLISECONDS_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final String SEPARATOR = "otapaz";
    private static final String DASH_SEPARATOR = "otapab";

    public static String makeTimerFieldName(String name) {
        return "timer-" + name.replaceAll(" ", "-");
    }

    public static String makeActiveTimerFieldName(String name) {
        return "active-timer-" + name.replaceAll(" ", "-");
    }

    public static String maskSpaces(String str) {
        return str.replaceAll("_", " ").replaceAll(" ", SEPARATOR).replaceAll("-", DASH_SEPARATOR);
    }

    public static String unmaskSpaces(String str) {
        return str.replaceAll(DASH_SEPARATOR, "-").replaceAll(SEPARATOR, " ");
    }

    public static String makeStatesVectorKey(String spaceKey) {
        return LuceneHelper.getStatesVectorKey() + "-" + spaceKey;
    }

    public static String makeStatesVectorKeyNullSafe(String spaceKey) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return LuceneHelper.getStatesVectorKey();
        }
        return LuceneHelper.getStatesVectorKey() + "-" + spaceKey;
    }

    public static String getStatesVectorKey() {
        return "states-vector";
    }

    public static String makeAssigneesVectorKey(String spaceKey) {
        return "assignees-vector-" + spaceKey;
    }

    public static String makeTimersVectorKey(String spaceKey) {
        return "timers-" + spaceKey;
    }

    public static String luceneDateToMilliSeconds(Date date) {
        if (date == null) {
            return null;
        }
        LUCENE_MILLISECONDS_FORMAT.setTimeZone(GMT);
        Calendar cal = Calendar.getInstance(GMT, Locale.ROOT);
        cal.setTimeInMillis(date.getTime());
        return LUCENE_MILLISECONDS_FORMAT.format(cal.getTimeInMillis());
    }

    public static String luceneDateToSeconds(Date date) {
        if (date == null) {
            return null;
        }
        LUCENE_SECONDS_FORMAT.setTimeZone(GMT);
        Calendar cal = Calendar.getInstance(GMT, Locale.ROOT);
        cal.setTimeInMillis(date.getTime());
        return LUCENE_SECONDS_FORMAT.format(cal.getTimeInMillis());
    }
}

